/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpBilinearOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        byte[] byArray2 = new byte[n8];
        int n12 = 0;
        while (n12 < n8) {
            byArray2[n12] = (byte)this.backgroundValues[n12];
            ++n12;
        }
        if (this.ctable == null) {
            int n13 = 0;
            while (n13 < n7) {
                int n14 = n11;
                n11 += n9;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
                int n15 = 0;
                int n16 = 0;
                while (n16 < n6) {
                    int n17;
                    float f2 = fArray[n15++];
                    float f3 = fArray[n15++];
                    int n18 = WarpBilinearOpImage.floor(f2);
                    int n19 = WarpBilinearOpImage.floor(f3);
                    float f4 = f2 - (float)n18;
                    float f5 = f3 - (float)n19;
                    if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                        if (this.setBackground) {
                            n17 = 0;
                            while (n17 < n8) {
                                byArray[n17][n14 + nArray[n17]] = byArray2[n17];
                                ++n17;
                            }
                        }
                    } else {
                        n17 = 0;
                        while (n17 < n8) {
                            int n20 = randomIter.getSample(n18, n19, n17) & 0xFF;
                            int n21 = randomIter.getSample(n18 + 1, n19, n17) & 0xFF;
                            int n22 = randomIter.getSample(n18, n19 + 1, n17) & 0xFF;
                            int n23 = randomIter.getSample(n18 + 1, n19 + 1, n17) & 0xFF;
                            float f6 = (float)(n21 - n20) * f4 + (float)n20;
                            float f7 = (float)(n23 - n22) * f4 + (float)n22;
                            float f8 = (f7 - f6) * f5 + f6;
                            byArray[n17][n14 + nArray[n17]] = (byte)f8;
                            ++n17;
                        }
                    }
                    n14 += n10;
                    ++n16;
                }
                ++n13;
            }
        } else {
            int n24 = 0;
            while (n24 < n7) {
                int n25 = n11;
                n11 += n9;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n24, n6, 1, fArray);
                int n26 = 0;
                int n27 = 0;
                while (n27 < n6) {
                    int n28;
                    float f9 = fArray[n26++];
                    float f10 = fArray[n26++];
                    int n29 = WarpBilinearOpImage.floor(f9);
                    int n30 = WarpBilinearOpImage.floor(f10);
                    float f11 = f9 - (float)n29;
                    float f12 = f10 - (float)n30;
                    if (n29 < n2 || n29 >= n3 || n30 < n4 || n30 >= n5) {
                        if (this.setBackground) {
                            n28 = 0;
                            while (n28 < n8) {
                                byArray[n28][n25 + nArray[n28]] = byArray2[n28];
                                ++n28;
                            }
                        }
                    } else {
                        n28 = 0;
                        while (n28 < n8) {
                            byte[] byArray3 = this.ctable[n28];
                            int n31 = byArray3[randomIter.getSample(n29, n30, 0) & 0xFF] & 0xFF;
                            int n32 = byArray3[randomIter.getSample(n29 + 1, n30, 0) & 0xFF] & 0xFF;
                            int n33 = byArray3[randomIter.getSample(n29, n30 + 1, 0) & 0xFF] & 0xFF;
                            int n34 = byArray3[randomIter.getSample(n29 + 1, n30 + 1, 0) & 0xFF] & 0xFF;
                            float f13 = (float)(n32 - n31) * f11 + (float)n31;
                            float f14 = (float)(n34 - n33) * f11 + (float)n33;
                            float f15 = (f14 - f13) * f12 + f13;
                            byArray[n28][n25 + nArray[n28]] = (byte)f15;
                            ++n28;
                        }
                    }
                    n25 += n10;
                    ++n27;
                }
                ++n24;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        int n12 = 0;
        while (n12 < n8) {
            sArray2[n12] = (short)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                float f2 = fArray[n15++];
                float f3 = fArray[n15++];
                int n18 = WarpBilinearOpImage.floor(f2);
                int n19 = WarpBilinearOpImage.floor(f3);
                float f4 = f2 - (float)n18;
                float f5 = f3 - (float)n19;
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            sArray[n17][n14 + nArray[n17]] = sArray2[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        int n20 = randomIter.getSample(n18, n19, n17) & 0xFFFF;
                        int n21 = randomIter.getSample(n18 + 1, n19, n17) & 0xFFFF;
                        int n22 = randomIter.getSample(n18, n19 + 1, n17) & 0xFFFF;
                        int n23 = randomIter.getSample(n18 + 1, n19 + 1, n17) & 0xFFFF;
                        float f6 = (float)(n21 - n20) * f4 + (float)n20;
                        float f7 = (float)(n23 - n22) * f4 + (float)n22;
                        float f8 = (f7 - f6) * f5 + f6;
                        sArray[n17][n14 + nArray[n17]] = (short)f8;
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        int n12 = 0;
        while (n12 < n8) {
            sArray2[n12] = (short)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                float f2 = fArray[n15++];
                float f3 = fArray[n15++];
                int n18 = WarpBilinearOpImage.floor(f2);
                int n19 = WarpBilinearOpImage.floor(f3);
                float f4 = f2 - (float)n18;
                float f5 = f3 - (float)n19;
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            sArray[n17][n14 + nArray[n17]] = sArray2[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        int n20 = randomIter.getSample(n18, n19, n17);
                        int n21 = randomIter.getSample(n18 + 1, n19, n17);
                        int n22 = randomIter.getSample(n18, n19 + 1, n17);
                        int n23 = randomIter.getSample(n18 + 1, n19 + 1, n17);
                        float f6 = (float)(n21 - n20) * f4 + (float)n20;
                        float f7 = (float)(n23 - n22) * f4 + (float)n22;
                        float f8 = (f7 - f6) * f5 + f6;
                        sArray[n17][n14 + nArray[n17]] = (short)f8;
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int[] nArray3 = new int[n8];
        int n12 = 0;
        while (n12 < n8) {
            nArray3[n12] = (int)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                float f2 = fArray[n15++];
                float f3 = fArray[n15++];
                int n18 = WarpBilinearOpImage.floor(f2);
                int n19 = WarpBilinearOpImage.floor(f3);
                float f4 = f2 - (float)n18;
                float f5 = f3 - (float)n19;
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            nArray2[n17][n14 + nArray[n17]] = nArray3[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        int n20 = randomIter.getSample(n18, n19, n17);
                        int n21 = randomIter.getSample(n18 + 1, n19, n17);
                        int n22 = randomIter.getSample(n18, n19 + 1, n17);
                        int n23 = randomIter.getSample(n18 + 1, n19 + 1, n17);
                        float f6 = (float)(n21 - n20) * f4 + (float)n20;
                        float f7 = (float)(n23 - n22) * f4 + (float)n22;
                        float f8 = (f7 - f6) * f5 + f6;
                        nArray2[n17][n14 + nArray[n17]] = (int)f8;
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n6];
        int n11 = 0;
        float[] fArray3 = new float[n8];
        int n12 = 0;
        while (n12 < n8) {
            fArray3[n12] = (float)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray2);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                float f2 = fArray2[n15++];
                float f3 = fArray2[n15++];
                int n18 = WarpBilinearOpImage.floor(f2);
                int n19 = WarpBilinearOpImage.floor(f3);
                float f4 = f2 - (float)n18;
                float f5 = f3 - (float)n19;
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            fArray[n17][n14 + nArray[n17]] = fArray3[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        float f6;
                        float f7 = randomIter.getSampleFloat(n18, n19, n17);
                        float f8 = randomIter.getSampleFloat(n18 + 1, n19, n17);
                        float f9 = randomIter.getSampleFloat(n18, n19 + 1, n17);
                        float f10 = randomIter.getSampleFloat(n18 + 1, n19 + 1, n17);
                        float f11 = (f8 - f7) * f4 + f7;
                        float f12 = (f10 - f9) * f4 + f9;
                        fArray[n17][n14 + nArray[n17]] = f6 = (f12 - f11) * f5 + f11;
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int n12 = 0;
        while (n12 < n7) {
            int n13 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n6, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n6) {
                int n16;
                float f2 = fArray[n14++];
                float f3 = fArray[n14++];
                int n17 = WarpBilinearOpImage.floor(f2);
                int n18 = WarpBilinearOpImage.floor(f3);
                float f4 = f2 - (float)n17;
                float f5 = f3 - (float)n18;
                if (n17 < n2 || n17 >= n3 || n18 < n4 || n18 >= n5) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n8) {
                            dArray[n16][n13 + nArray[n16]] = this.backgroundValues[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n8) {
                        double d2;
                        double d3 = randomIter.getSampleDouble(n17, n18, n16);
                        double d4 = randomIter.getSampleDouble(n17 + 1, n18, n16);
                        double d5 = randomIter.getSampleDouble(n17, n18 + 1, n16);
                        double d6 = randomIter.getSampleDouble(n17 + 1, n18 + 1, n16);
                        double d7 = (d4 - d3) * (double)f4 + d3;
                        double d8 = (d6 - d5) * (double)f4 + d5;
                        dArray[n16][n13 + nArray[n16]] = d2 = (d8 - d7) * (double)f5 + d7;
                        ++n16;
                    }
                }
                n13 += n10;
                ++n15;
            }
            ++n12;
        }
    }

    private static final int floor(float f2) {
        return f2 >= 0.0f ? (int)f2 : (int)f2 - 1;
    }
}

