/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.StreamImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.ImagingListener;

public class URLRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        try {
            URL uRL = (URL)parameterBlock.getObjectParameter(0);
            InputStream inputStream = uRL.openStream();
            SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
            ImageDecodeParam imageDecodeParam = null;
            if (parameterBlock.getNumParameters() > 1) {
                imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
            }
            ParameterBlock parameterBlock2 = new ParameterBlock();
            parameterBlock2.add(seekableStream);
            parameterBlock2.add(imageDecodeParam);
            RenderingHints.Key key = JAI.KEY_OPERATION_BOUND;
            int n2 = 3;
            if (renderingHints == null) {
                renderingHints = new RenderingHints(key, new Integer(n2));
            } else if (!renderingHints.containsKey(key)) {
                renderingHints.put(key, new Integer(n2));
            }
            OperationRegistry operationRegistry = (OperationRegistry)renderingHints.get(JAI.KEY_OPERATION_REGISTRY);
            RenderedImage renderedImage = RIFRegistry.create(operationRegistry, "stream", parameterBlock2, renderingHints);
            return renderedImage == null ? null : new StreamImage(renderedImage, seekableStream);
        }
        catch (IOException iOException) {
            ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
            String string = JaiI18N.getString("URLRIF0");
            imagingListener.errorOccurred(string, iOException, this, false);
            return null;
        }
    }
}

