/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;

public final class TranslateIntOpImage
extends OpImage {
    private int transX;
    private int transY;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, int n2, int n3) {
        ImageLayout imageLayout = new ImageLayout(renderedImage.getMinX() + n2, renderedImage.getMinY() + n3, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset() + n2, renderedImage.getTileGridYOffset() + n3, renderedImage.getTileWidth(), renderedImage.getTileHeight(), renderedImage.getSampleModel(), renderedImage.getColorModel());
        return imageLayout;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
                map2.remove(JAI.KEY_TILE_CACHE);
            } else if (map2.containsKey(JAI.KEY_TILE_CACHE)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.remove(JAI.KEY_TILE_CACHE);
            }
        }
        return map2;
    }

    public TranslateIntOpImage(RenderedImage renderedImage, Map map, int n2, int n3) {
        super(OpImage.vectorize(renderedImage), TranslateIntOpImage.layoutHelper(renderedImage, n2, n3), TranslateIntOpImage.configHelper(map), false);
        this.transX = n2;
        this.transY = n3;
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster computeTile(int n2, int n3) {
        return this.getTile(n2, n3);
    }

    public Raster getTile(int n2, int n3) {
        Raster raster = this.getSource(0).getTile(n2, n3);
        if (raster == null) {
            return null;
        }
        return raster.createTranslatedChild(this.tileXToX(n2), this.tileYToY(n3));
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(this.transX, this.transY);
        return rectangle2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(-this.transX, -this.transY);
        return rectangle2;
    }
}

