/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ThresholdOpImage
extends ColormapOpImage {
    private double[] low;
    private double[] high;
    private double[] constants;
    private byte[][] byteTable = null;

    public ThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.getSampleModel().getNumBands();
        this.low = new double[n2];
        this.high = new double[n2];
        this.constants = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.low[n3] = dArray.length < n2 ? dArray[0] : dArray[n3];
            this.high[n3] = dArray2.length < n2 ? dArray2[0] : dArray2[n3];
            this.constants[n3] = dArray3.length < n2 ? dArray3[0] : dArray3[n3];
            ++n3;
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        this.initByteTable();
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            byte[] byArray3 = this.byteTable[n2 >= this.byteTable.length ? 0 : n2];
            int n3 = byArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = byArray3[byArray2[n4] & 0xFF];
                ++n4;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getWidth() * n4;
        int n7 = rasterAccessor2.getHeight() * n5;
        int n8 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getByteDataArrays(), n4, n5, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getShortDataArrays(), n4, n5, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getShortDataArrays(), n4, n5, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getIntDataArrays(), n4, n5, nArray2, rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getFloatDataArrays(), n4, n5, nArray2, rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getDoubleDataArrays(), n4, n5, nArray2, rasterAccessor2.getDoubleDataArrays());
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, byte[][] byArray, int n7, int n8, int[] nArray2, byte[][] byArray2) {
        this.initByteTable();
        int n9 = 0;
        while (n9 < n4) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            byte[] byArray5 = this.byteTable[n9];
            int n10 = nArray2[n9] + n3;
            int n11 = nArray2[n9];
            int n12 = nArray[n9];
            while (n11 < n10) {
                int n13 = n11 + n2;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    byArray4[n14] = byArray5[byArray3[n15] & 0xFF];
                    n14 += n7;
                    n15 += n5;
                }
                n11 += n8;
                n12 += n6;
            }
            ++n9;
        }
    }

    private void shortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            short s2 = (short)this.constants[n9];
            int n10 = nArray2[n9] + n3;
            int n11 = nArray2[n9];
            int n12 = nArray[n9];
            while (n11 < n10) {
                int n13 = n11 + n2;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    short s3 = sArray3[n15];
                    sArray4[n14] = (double)s3 >= d2 && (double)s3 <= d3 ? s2 : s3;
                    n14 += n7;
                    n15 += n5;
                }
                n11 += n8;
                n12 += n6;
            }
            ++n9;
        }
    }

    private void ushortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            short s2 = (short)this.constants[n9];
            int n10 = nArray2[n9] + n3;
            int n11 = nArray2[n9];
            int n12 = nArray[n9];
            while (n11 < n10) {
                int n13 = n11 + n2;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    int n16 = sArray3[n15] & 0xFFFF;
                    sArray4[n14] = (double)n16 >= d2 && (double)n16 <= d3 ? s2 : (short)n16;
                    n14 += n7;
                    n15 += n5;
                }
                n11 += n8;
                n12 += n6;
            }
            ++n9;
        }
    }

    private void intLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[][] nArray2, int n7, int n8, int[] nArray3, int[][] nArray4) {
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            int n10 = (int)this.constants[n9];
            int n11 = nArray3[n9] + n3;
            int n12 = nArray3[n9];
            int n13 = nArray[n9];
            while (n12 < n11) {
                int n14 = n12 + n2;
                int n15 = n12;
                int n16 = n13;
                while (n15 < n14) {
                    int n17 = nArray5[n16];
                    nArray6[n15] = (double)n17 >= d2 && (double)n17 <= d3 ? n10 : n17;
                    n15 += n7;
                    n16 += n5;
                }
                n12 += n8;
                n13 += n6;
            }
            ++n9;
        }
    }

    private void floatLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, float[][] fArray, int n7, int n8, int[] nArray2, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            float f2 = (float)this.constants[n9];
            int n10 = nArray2[n9] + n3;
            int n11 = nArray2[n9];
            int n12 = nArray[n9];
            while (n11 < n10) {
                int n13 = n11 + n2;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    float f3 = fArray3[n15];
                    fArray4[n14] = (double)f3 >= d2 && (double)f3 <= d3 ? f2 : f3;
                    n14 += n7;
                    n15 += n5;
                }
                n11 += n8;
                n12 += n6;
            }
            ++n9;
        }
    }

    private void doubleLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, double[][] dArray, int n7, int n8, int[] nArray2, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            double d2 = this.low[n9];
            double d3 = this.high[n9];
            double d4 = this.constants[n9];
            int n10 = nArray2[n9] + n3;
            int n11 = nArray2[n9];
            int n12 = nArray[n9];
            while (n11 < n10) {
                int n13 = n11 + n2;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    double d5 = dArray3[n15];
                    dArray4[n14] = d5 >= d2 && d5 <= d3 ? d4 : d5;
                    n14 += n7;
                    n15 += n5;
                }
                n11 += n8;
                n12 += n6;
            }
            ++n9;
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int n2 = this.getSampleModel().getNumBands();
        this.byteTable = new byte[n2][256];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = this.low[n3];
            double d3 = this.high[n3];
            byte by = (byte)this.constants[n3];
            byte[] byArray = this.byteTable[n3];
            int n4 = 0;
            while (n4 < 256) {
                byArray[n4] = (double)n4 >= d2 && (double)n4 <= d3 ? by : (byte)n4;
                ++n4;
            }
            ++n3;
        }
    }
}

