/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.SubsampleBinaryToGrayOpImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

class SubsampleBinaryToGray2x2OpImage
extends GeometricOpImage {
    private int blockX = 2;
    private int blockY = 2;
    private int dWidth;
    private int dHeight;
    private int[] lut4_45;
    private int[] lut4_67;
    private byte[] lutGray;

    public SubsampleBinaryToGray2x2OpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        super(OpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, 0.5f, 0.5f, imageLayout, map), map, true, null, null, null);
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        this.dWidth = n2 / this.blockX;
        this.dHeight = n3 / this.blockY;
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * 2.0, point2D.getY() * 2.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / 2.0, point2D.getY() / 2.0);
        return point2D2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x / this.blockX;
        int n4 = rectangle.y / this.blockY;
        int n5 = (rectangle.x + rectangle.width - 1) / this.blockX;
        int n6 = (rectangle.y + rectangle.height - 1) / this.blockY;
        return new Rectangle(n3, n4, n5 - n3 + 1, n6 - n4 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x * this.blockX;
        int n4 = rectangle.y * this.blockY;
        int n5 = (rectangle.x + rectangle.width - 1) * this.blockX;
        int n6 = (rectangle.y + rectangle.height - 1) * this.blockY;
        return new Rectangle(n3, n4, n5 - n3 + this.blockX, n6 - n4 + this.blockY);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop2x2(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop2x2(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n2 = packedImageData.offset;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = packedImageData.rect.x;
        int n8 = packedImageData.rect.y;
        int n9 = packedImageData.bitOffset;
        int n10 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n14 = dataBufferByte.getOffset();
        int[] nArray = new int[4];
        if ((n9 & 1) == 0) {
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n4 + n15 << 1;
                int n17 = (n16 - n8) * n10 + n2;
                int n18 = n17 + n10;
                int n19 = (n15 + n4 - n12) * n13 + n14;
                n19 += n3 - n11;
                int n20 = (n3 << 1) - n7 + n9;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = n20 >> 3;
                    int n23 = n20 % 8;
                    int n24 = 0xFF & byArray[n17 + n22];
                    nArray[2] = this.lut4_45[n24 & 0xF];
                    nArray[3] = this.lut4_67[n24 & 0xF];
                    nArray[0] = this.lut4_45[n24 >>= 4];
                    nArray[1] = this.lut4_67[n24];
                    n24 = 0xFF & byArray[n18 + n22];
                    nArray[2] = nArray[2] + this.lut4_45[n24 & 0xF];
                    nArray[3] = nArray[3] + this.lut4_67[n24 & 0xF];
                    nArray[0] = nArray[0] + this.lut4_45[n24 >>= 4];
                    nArray[1] = nArray[1] + this.lut4_67[n24];
                    n23 >>= 1;
                    while (n23 < 4 && n21 < n5) {
                        byArray2[n19 + n21] = this.lutGray[nArray[n23]];
                        ++n23;
                        ++n21;
                        n20 += this.blockX;
                    }
                }
                ++n15;
            }
        } else {
            int n25 = 0;
            while (n25 < n6) {
                int n26 = n4 + n25 << 1;
                int n27 = (n26 - n8) * n10 + n2;
                int n28 = n27 + n10;
                int n29 = (n25 + n4 - n12) * n13 + n14;
                n29 += n3 - n11;
                int n30 = (n3 << 1) - n7 + n9;
                int n31 = 0;
                while (n31 < n5) {
                    int n32 = n30 >> 3;
                    int n33 = n30 % 8;
                    int n34 = 0xFF & byArray[n27 + n32] << 1;
                    nArray[2] = this.lut4_45[n34 & 0xF];
                    nArray[3] = this.lut4_67[n34 & 0xF];
                    nArray[0] = this.lut4_45[n34 >>= 4];
                    nArray[1] = this.lut4_67[n34];
                    n34 = 0xFF & byArray[n28 + n32] << 1;
                    nArray[2] = nArray[2] + this.lut4_45[n34 & 0xF];
                    nArray[3] = nArray[3] + this.lut4_67[n34 & 0xF];
                    nArray[0] = nArray[0] + this.lut4_45[n34 >>= 4];
                    nArray[1] = nArray[1] + this.lut4_67[n34];
                    if (++n32 < byArray.length - n28) {
                        nArray[3] = nArray[3] + (byArray[n27 + n32] < 0 ? 1 : 0);
                        nArray[3] = nArray[3] + (byArray[n28 + n32] < 0 ? 1 : 0);
                    }
                    n33 >>= 1;
                    while (n33 < 4 && n31 < n5) {
                        byArray2[n29 + n31] = this.lutGray[nArray[n33]];
                        ++n33;
                        ++n31;
                        n30 += this.blockX;
                    }
                }
                ++n25;
            }
        }
    }

    private final void buildLookupTables() {
        int n2;
        this.lut4_45 = new int[16];
        this.lut4_67 = new int[16];
        this.lut4_67[0] = 0;
        this.lut4_67[1] = 1;
        this.lut4_67[2] = 1;
        this.lut4_67[3] = 2;
        int n3 = 4;
        while (n3 < 16) {
            this.lut4_67[n3] = this.lut4_67[n3 & 3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < 16) {
            this.lut4_45[n4] = this.lut4_67[n4 >> 2];
            ++n4;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        int n5 = 0;
        while (n5 < this.lutGray.length) {
            n2 = Math.round(255.0f * (float)n5 / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n5] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n5;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n2 = 0;
            while (n2 < this.lutGray.length) {
                this.lutGray[n2] = (byte)(255 - (0xFF & this.lutGray[n2]));
                ++n2;
            }
        }
    }
}

