/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.InterpAverage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class SubsampleAverageOpImage
extends GeometricOpImage {
    protected double scaleX;
    protected double scaleY;
    protected int blockX;
    protected int blockY;
    protected int sourceMinX;
    protected int sourceMinY;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, double d2, double d3, ImageLayout imageLayout) {
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAverageOpImage0"));
        }
        if (d3 <= 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAverageOpImage1"));
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX((int)Math.floor((double)renderedImage.getMinX() * d2));
        imageLayout2.setMinY((int)Math.floor((double)renderedImage.getMinY() * d3));
        imageLayout2.setWidth((int)((double)renderedImage.getWidth() * d2));
        imageLayout2.setHeight((int)((double)renderedImage.getHeight() * d3));
        return imageLayout2;
    }

    public SubsampleAverageOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, double d2, double d3) {
        super(OpImage.vectorize(renderedImage), SubsampleAverageOpImage.layoutHelper(renderedImage, d2, d3, imageLayout), map, true, null, new InterpAverage((int)Math.ceil(1.0 / d2), (int)Math.ceil(1.0 / d3)), null);
        this.scaleX = d2;
        this.scaleY = d3;
        this.blockX = (int)Math.ceil(1.0 / d2);
        this.blockY = (int)Math.ceil(1.0 / d3);
        this.sourceMinX = renderedImage.getMinX();
        this.sourceMinY = renderedImage.getMinY();
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("destPt == null!");
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)this.sourceMinX + (point2D.getX() - (double)this.minX) / this.scaleX, (double)this.sourceMinY + (point2D.getY() - (double)this.minY) / this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("sourcePt == null!");
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)this.minX + (point2D.getX() - (double)this.sourceMinX) * this.scaleX, (double)this.minY + (point2D.getY() - (double)this.sourceMinY) * this.scaleY);
        return point2D2;
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = this.sourceMinX + (int)Math.floor((double)(rectangle.x - this.minX) / this.scaleX + 0.5);
        int n4 = this.sourceMinY + (int)Math.floor((double)(rectangle.y - this.minY) / this.scaleY + 0.5);
        int n5 = n3 + (rectangle.width - 1) * this.blockX;
        int n6 = n4 + (rectangle.height - 1) * this.blockY;
        return new Rectangle(n3, n4, n5 - n3 + 1, n6 - n4 + 1);
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(this.minX + (int)Math.floor((double)(rectangle.x - this.sourceMinX) * this.scaleX), this.minY + (int)Math.floor((double)(rectangle.y - this.sourceMinY) * this.scaleY), (int)Math.ceil((double)rectangle.width * this.scaleX), (int)Math.ceil((double)rectangle.height * this.scaleY));
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic3"));
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray3 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray3[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray4 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray4[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        float f2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            byte[] byArray3 = byArray[n11];
            byte[] byArray4 = byArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < this.blockY) {
                        int n23 = n20;
                        int n24 = 0;
                        while (n24 < this.blockX) {
                            n21 += byArray4[n23] & 0xFF;
                            n23 += n7;
                            ++n24;
                        }
                        n20 += n8;
                        ++n22;
                    }
                    byArray3[n17] = ImageUtil.clampRoundByte((float)n21 / f2);
                    n18 = n16 + nArray3[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray4[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray3 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray3[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray4 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray4[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        float f2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    long l2 = 0L;
                    int n21 = 0;
                    while (n21 < this.blockY) {
                        int n22 = n20;
                        int n23 = 0;
                        while (n23 < this.blockX) {
                            l2 += (long)(sArray4[n22] & 0xFFFF);
                            n22 += n7;
                            ++n23;
                        }
                        n20 += n8;
                        ++n21;
                    }
                    sArray3[n17] = ImageUtil.clampRoundUShort((float)l2 / f2);
                    n18 = n16 + nArray3[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray4[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray3 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray3[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray4 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray4[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        float f2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    long l2 = 0L;
                    int n21 = 0;
                    while (n21 < this.blockY) {
                        int n22 = n20;
                        int n23 = 0;
                        while (n23 < this.blockX) {
                            l2 += (long)sArray4[n22];
                            n22 += n7;
                            ++n23;
                        }
                        n20 += n8;
                        ++n21;
                    }
                    sArray3[n17] = ImageUtil.clampRoundShort((float)l2 / f2);
                    n18 = n16 + nArray3[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray4[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray5 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray5[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray6 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray6[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        float f2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            int[] nArray7 = nArray[n11];
            int[] nArray8 = nArray3[n11];
            int n12 = nArray4[n11];
            int n13 = nArray2[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    double d2 = 0.0;
                    int n21 = 0;
                    while (n21 < this.blockY) {
                        int n22 = n20;
                        int n23 = 0;
                        while (n23 < this.blockX) {
                            d2 += (double)nArray8[n22];
                            n22 += n7;
                            ++n23;
                        }
                        n20 += n8;
                        ++n21;
                    }
                    nArray7[n17] = ImageUtil.clampRoundInt(d2 / (double)f2);
                    n18 = n16 + nArray5[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray6[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray3 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray3[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray4 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray4[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        float f2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            float[] fArray3 = fArray[n11];
            float[] fArray4 = fArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    double d2 = 0.0;
                    int n21 = 0;
                    while (n21 < this.blockY) {
                        int n22 = n20;
                        int n23 = 0;
                        while (n23 < this.blockX) {
                            d2 += (double)fArray4[n22];
                            n22 += n7;
                            ++n23;
                        }
                        n20 += n8;
                        ++n21;
                    }
                    fArray3[n17] = ImageUtil.clampFloat(d2 / (double)f2);
                    n18 = n16 + nArray3[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray4[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray3 = new int[n2];
        int n9 = 0;
        while (n9 < n2) {
            nArray3[n9] = (int)Math.floor((double)n9 / this.scaleX) * n7;
            ++n9;
        }
        int[] nArray4 = new int[n3];
        int n10 = 0;
        while (n10 < n3) {
            nArray4[n10] = (int)Math.floor((double)n10 / this.scaleY) * n8;
            ++n10;
        }
        double d2 = this.blockX * this.blockY;
        int n11 = 0;
        while (n11 < n4) {
            double[] dArray3 = dArray[n11];
            double[] dArray4 = dArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = n12;
            int n15 = 0;
            while (n15 < n3) {
                int n16 = n14;
                int n17 = n13;
                int n18 = n16;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n18;
                    double d3 = 0.0;
                    int n21 = 0;
                    while (n21 < this.blockY) {
                        int n22 = n20;
                        int n23 = 0;
                        while (n23 < this.blockX) {
                            d3 += dArray4[n22];
                            n22 += n7;
                            ++n23;
                        }
                        n20 += n8;
                        ++n21;
                    }
                    dArray3[n17] = d3 / d2;
                    n18 = n16 + nArray3[n19];
                    n17 += n5;
                    ++n19;
                }
                n14 = n12 + nArray4[n15];
                n13 += n6;
                ++n15;
            }
            ++n11;
        }
    }
}

