/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class SeparableConvolveOpImage
extends AreaOpImage {
    static int byteLoopCounter = 0;
    protected KernelJAI kernel;
    protected int kw;
    protected int kh;
    protected int kx;
    protected int ky;
    protected float[] hValues;
    protected float[] vValues;
    protected float[][] hTables;

    public SeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        if (this.sampleModel.getDataType() == 0) {
            this.hTables = new float[this.hValues.length][256];
            int n2 = 0;
            while (n2 < this.hValues.length) {
                float f2 = this.hValues[n2];
                int n3 = 0;
                while (n3 < 256) {
                    byte by = (byte)n3;
                    float f3 = n3;
                    this.hTables[n2][by + 128] = f2 * f3;
                    ++n3;
                }
                ++n2;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2[n10];
            int n15 = nArray2[n10];
            int n16 = nArray[n10];
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n19 < this.kh - 1) {
                n14 = n15;
                n13 = 0;
                while (n13 < n2) {
                    n12 = n14;
                    float f2 = 0.0f;
                    n11 = 0;
                    while (n11 < this.kw) {
                        f2 += this.hTables[n11][byArray4[n12] + 128];
                        n12 += n7;
                        ++n11;
                    }
                    fArray[n17 + n13] = f2;
                    n14 += n7;
                    ++n13;
                }
                n17 += n2;
                n15 += n8;
                ++n19;
            }
            n14 = 0;
            while (n14 < n3) {
                n13 = n15;
                n12 = n16;
                int n20 = 0;
                while (n20 < n2) {
                    n11 = n13;
                    float f3 = 0.0f;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        f3 += this.hTables[n21][byArray4[n11] + 128];
                        n11 += n7;
                        ++n21;
                    }
                    fArray[n17 + n20] = f3;
                    f3 = 0.5f;
                    int n22 = n18 + n20;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        f3 += fArray[n22] * this.vValues[n23];
                        if ((n22 += n2) >= n9) {
                            n22 -= n9;
                        }
                        ++n23;
                    }
                    int n24 = (int)f3;
                    if (n24 < 0) {
                        n24 = 0;
                    } else if (n24 > 255) {
                        n24 = 255;
                    }
                    byArray3[n12] = (byte)n24;
                    n13 += n7;
                    n12 += n5;
                    ++n20;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                if ((n18 += n2) == n9) {
                    n18 = 0;
                }
                n15 += n8;
                n16 += n6;
                ++n14;
            }
            ++n10;
        }
    }

    protected void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n15 = nArray2[n10];
            int n16 = nArray[n10];
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n19 < this.kh - 1) {
                n14 = n15;
                n13 = 0;
                while (n13 < n2) {
                    n12 = n14;
                    float f2 = 0.0f;
                    n11 = 0;
                    while (n11 < this.kw) {
                        f2 += (float)sArray4[n12] * this.hValues[n11];
                        n12 += n7;
                        ++n11;
                    }
                    fArray[n17 + n13] = f2;
                    n14 += n7;
                    ++n13;
                }
                n17 += n2;
                n15 += n8;
                ++n19;
            }
            n14 = 0;
            while (n14 < n3) {
                n13 = n15;
                n12 = n16;
                int n20 = 0;
                while (n20 < n2) {
                    n11 = n13;
                    float f3 = 0.0f;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        f3 += (float)sArray4[n11] * this.hValues[n21];
                        n11 += n7;
                        ++n21;
                    }
                    fArray[n17 + n20] = f3;
                    f3 = 0.5f;
                    int n22 = n18 + n20;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        f3 += fArray[n22] * this.vValues[n23];
                        if ((n22 += n2) >= n9) {
                            n22 -= n9;
                        }
                        ++n23;
                    }
                    int n24 = (int)f3;
                    if (n24 < Short.MIN_VALUE) {
                        n24 = Short.MIN_VALUE;
                    } else if (n24 > Short.MAX_VALUE) {
                        n24 = Short.MAX_VALUE;
                    }
                    sArray3[n12] = (short)n24;
                    n13 += n7;
                    n12 += n5;
                    ++n20;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                if ((n18 += n2) == n9) {
                    n18 = 0;
                }
                n15 += n8;
                n16 += n6;
                ++n14;
            }
            ++n10;
        }
    }

    protected void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n15 = nArray2[n10];
            int n16 = nArray[n10];
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n19 < this.kh - 1) {
                n14 = n15;
                n13 = 0;
                while (n13 < n2) {
                    n12 = n14;
                    float f2 = 0.0f;
                    n11 = 0;
                    while (n11 < this.kw) {
                        f2 += (float)(sArray4[n12] & 0xFFFF) * this.hValues[n11];
                        n12 += n7;
                        ++n11;
                    }
                    fArray[n17 + n13] = f2;
                    n14 += n7;
                    ++n13;
                }
                n17 += n2;
                n15 += n8;
                ++n19;
            }
            n14 = 0;
            while (n14 < n3) {
                n13 = n15;
                n12 = n16;
                int n20 = 0;
                while (n20 < n2) {
                    n11 = n13;
                    float f3 = 0.0f;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        f3 += (float)(sArray4[n11] & 0xFFFF) * this.hValues[n21];
                        n11 += n7;
                        ++n21;
                    }
                    fArray[n17 + n20] = f3;
                    f3 = 0.5f;
                    int n22 = n18 + n20;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        f3 += fArray[n22] * this.vValues[n23];
                        if ((n22 += n2) >= n9) {
                            n22 -= n9;
                        }
                        ++n23;
                    }
                    int n24 = (int)f3;
                    if (n24 < 0) {
                        n24 = 0;
                    } else if (n24 > 65535) {
                        n24 = 65535;
                    }
                    sArray3[n12] = (short)n24;
                    n13 += n7;
                    n12 += n5;
                    ++n20;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                if ((n18 += n2) == n9) {
                    n18 = 0;
                }
                n15 += n8;
                n16 += n6;
                ++n14;
            }
            ++n10;
        }
    }

    protected void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            int[] nArray5 = nArray[n10];
            int[] nArray6 = nArray3[n10];
            int n15 = nArray4[n10];
            int n16 = nArray2[n10];
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n19 < this.kh - 1) {
                n14 = n15;
                n13 = 0;
                while (n13 < n2) {
                    n12 = n14;
                    float f2 = 0.0f;
                    n11 = 0;
                    while (n11 < this.kw) {
                        f2 += (float)nArray6[n12] * this.hValues[n11];
                        n12 += n7;
                        ++n11;
                    }
                    fArray[n17 + n13] = f2;
                    n14 += n7;
                    ++n13;
                }
                n17 += n2;
                n15 += n8;
                ++n19;
            }
            n14 = 0;
            while (n14 < n3) {
                n13 = n15;
                n12 = n16;
                int n20 = 0;
                while (n20 < n2) {
                    int n21;
                    n11 = n13;
                    float f3 = 0.0f;
                    int n22 = 0;
                    while (n22 < this.kw) {
                        f3 += (float)nArray6[n11] * this.hValues[n22];
                        n11 += n7;
                        ++n22;
                    }
                    fArray[n17 + n20] = f3;
                    f3 = 0.5f;
                    int n23 = n18 + n20;
                    int n24 = 0;
                    while (n24 < this.kh) {
                        f3 += fArray[n23] * this.vValues[n24];
                        if ((n23 += n2) >= n9) {
                            n23 -= n9;
                        }
                        ++n24;
                    }
                    nArray5[n12] = n21 = (int)f3;
                    n13 += n7;
                    n12 += n5;
                    ++n20;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                if ((n18 += n2) == n9) {
                    n18 = 0;
                }
                n15 += n8;
                n16 += n6;
                ++n14;
            }
            ++n10;
        }
    }

    protected void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        float[] fArray3 = new float[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            int n14;
            float[] fArray4 = fArray[n10];
            float[] fArray5 = fArray2[n10];
            int n15 = nArray2[n10];
            int n16 = nArray[n10];
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n19 < this.kh - 1) {
                n14 = n15;
                n13 = 0;
                while (n13 < n2) {
                    n12 = n14;
                    float f2 = 0.0f;
                    n11 = 0;
                    while (n11 < this.kw) {
                        f2 += fArray5[n12] * this.hValues[n11];
                        n12 += n7;
                        ++n11;
                    }
                    fArray3[n17 + n13] = f2;
                    n14 += n7;
                    ++n13;
                }
                n17 += n2;
                n15 += n8;
                ++n19;
            }
            n14 = 0;
            while (n14 < n3) {
                n13 = n15;
                n12 = n16;
                int n20 = 0;
                while (n20 < n2) {
                    n11 = n13;
                    float f3 = 0.0f;
                    int n21 = 0;
                    while (n21 < this.kw) {
                        f3 += fArray5[n11] * this.hValues[n21];
                        n11 += n7;
                        ++n21;
                    }
                    fArray3[n17 + n20] = f3;
                    f3 = 0.0f;
                    int n22 = n18 + n20;
                    int n23 = 0;
                    while (n23 < this.kh) {
                        f3 += fArray3[n22] * this.vValues[n23];
                        if ((n22 += n2) >= n9) {
                            n22 -= n9;
                        }
                        ++n23;
                    }
                    fArray4[n12] = f3;
                    n13 += n7;
                    n12 += n5;
                    ++n20;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                if ((n18 += n2) == n9) {
                    n18 = 0;
                }
                n15 += n8;
                n16 += n6;
                ++n14;
            }
            ++n10;
        }
    }

    protected void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        double[] dArray3 = new double[this.kh * n2];
        int n9 = this.kh * n2;
        int n10 = 0;
        while (n10 < n4) {
            int n11;
            int n12;
            int n13;
            double[] dArray4 = dArray[n10];
            double[] dArray5 = dArray2[n10];
            int n14 = nArray2[n10];
            int n15 = nArray[n10];
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < this.kh - 1) {
                n13 = n14;
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    double d2 = 0.0;
                    int n19 = 0;
                    while (n19 < this.kw) {
                        d2 += dArray5[n11] * (double)this.hValues[n19];
                        n11 += n7;
                        ++n19;
                    }
                    dArray3[n16 + n12] = d2;
                    n13 += n7;
                    ++n12;
                }
                n16 += n2;
                n14 += n8;
                ++n18;
            }
            n13 = 0;
            while (n13 < n3) {
                n12 = n14;
                n11 = n15;
                int n20 = 0;
                while (n20 < n2) {
                    int n21 = n12;
                    double d3 = 0.0;
                    int n22 = 0;
                    while (n22 < this.kw) {
                        d3 += dArray5[n21] * (double)this.hValues[n22];
                        n21 += n7;
                        ++n22;
                    }
                    dArray3[n16 + n20] = d3;
                    d3 = 0.0;
                    int n23 = n17 + n20;
                    int n24 = 0;
                    while (n24 < this.kh) {
                        d3 += dArray3[n23] * (double)this.vValues[n24];
                        if ((n23 += n2) >= n9) {
                            n23 -= n9;
                        }
                        ++n24;
                    }
                    dArray4[n11] = d3;
                    n12 += n7;
                    n11 += n5;
                    ++n20;
                }
                if ((n16 += n2) == n9) {
                    n16 = 0;
                }
                if ((n17 += n2) == n9) {
                    n17 = 0;
                }
                n14 += n8;
                n15 += n6;
                ++n13;
            }
            ++n10;
        }
    }
}

