/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBilinearOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    Rational half = new Rational(1L, 2L);
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f2, f3, f4, f5);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n3];
                nArray3 = new int[n2];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n4, n5, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n3];
                fArray = new float[n2];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n4, n5, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l2 = n9;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n8;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n11 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n12 = 0;
        while (n12 < n6) {
            nArray[n12] = (n11 - n2) * n4;
            nArray3[n12] = (int)((float)l9 / (float)l10 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n11;
                l9 -= l10;
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            nArray2[n13] = (n10 - n3) * n5;
            nArray4[n13] = (int)((float)l4 / (float)l5 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n13;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l2 = n9;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n8;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n11 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n12 = 0;
        while (n12 < n6) {
            nArray[n12] = (n11 - n2) * n4;
            fArray[n12] = (float)l9 / (float)l10;
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n11;
                l9 -= l10;
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            nArray2[n13] = (n10 - n3) * n5;
            fArray2[n13] = (float)l4 / (float)l5;
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n13;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2[n10];
            int n11 = nArray5[n10];
            int n12 = nArray6[n10];
            int n13 = 0;
            while (n13 < n6) {
                int n14 = n11;
                int n15 = nArray4[n13];
                int n16 = nArray2[n13] + n12;
                int n17 = n16 + n3;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 + n2;
                    int n22 = byArray4[n20 + n16] & 0xFF;
                    int n23 = byArray4[n21 + n16] & 0xFF;
                    int n24 = byArray4[n20 + n17] & 0xFF;
                    int n25 = byArray4[n21 + n17] & 0xFF;
                    int n26 = (n23 - n22) * n19 + (n22 << this.subsampleBits);
                    int n27 = (n25 - n24) * n19 + (n24 << this.subsampleBits);
                    int n28 = (n27 - n26) * n15 + (n26 << this.subsampleBits) + this.round2 >> this.shift2;
                    byArray3[n14] = (byte)(n28 & 0xFF);
                    n14 += n8;
                    ++n18;
                }
                n11 += n9;
                ++n13;
            }
            ++n10;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray5[n10];
            int n12 = nArray6[n10];
            int n13 = 0;
            while (n13 < n6) {
                int n14 = n11;
                int n15 = nArray4[n13];
                int n16 = nArray2[n13] + n12;
                int n17 = n16 + n3;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 + n2;
                    short s2 = sArray4[n20 + n16];
                    short s3 = sArray4[n21 + n16];
                    short s4 = sArray4[n20 + n17];
                    short s5 = sArray4[n21 + n17];
                    int n22 = (s3 - s2) * n19 + (s2 << this.subsampleBits);
                    int n23 = (s5 - s4) * n19 + (s4 << this.subsampleBits);
                    int n24 = (n23 - n22) * n15 + (n22 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n14] = (short)n24;
                    n14 += n8;
                    ++n18;
                }
                n11 += n9;
                ++n13;
            }
            ++n10;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray5[n10];
            int n12 = nArray6[n10];
            int n13 = 0;
            while (n13 < n6) {
                int n14 = n11;
                int n15 = nArray4[n13];
                int n16 = nArray2[n13] + n12;
                int n17 = n16 + n3;
                int n18 = 0;
                while (n18 < n5) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 + n2;
                    int n22 = sArray4[n20 + n16] & 0xFFFF;
                    int n23 = sArray4[n21 + n16] & 0xFFFF;
                    int n24 = sArray4[n20 + n17] & 0xFFFF;
                    int n25 = sArray4[n21 + n17] & 0xFFFF;
                    int n26 = (n23 - n22) * n19 + (n22 << this.subsampleBits);
                    int n27 = (n25 - n24) * n19 + (n24 << this.subsampleBits);
                    int n28 = (n27 - n26) * n15 + (n26 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n14] = (short)(n28 & 0xFFFF);
                    n14 += n8;
                    ++n18;
                }
                n11 += n9;
                ++n13;
            }
            ++n10;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 29 - this.subsampleBits;
        int n11 = 0;
        while (n11 < n7) {
            int[] nArray9 = nArray5[n11];
            int[] nArray10 = nArray7[n11];
            int n12 = nArray6[n11];
            int n13 = nArray8[n11];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n12;
                int n16 = nArray4[n14];
                int n17 = nArray2[n14] + n13;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n5) {
                    long l2;
                    long l3;
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 + n2;
                    int n23 = nArray10[n21 + n17];
                    int n24 = nArray10[n22 + n17];
                    int n25 = nArray10[n21 + n18];
                    int n26 = nArray10[n22 + n18];
                    if ((n23 | n25) >>> n10 == 0) {
                        if ((n24 | n26) >>> n10 == 0) {
                            l3 = (n24 - n23) * n20 + (n23 << this.subsampleBits);
                            l2 = (n26 - n25) * n20 + (n25 << this.subsampleBits);
                        } else {
                            l3 = ((long)n24 - (long)n23) * (long)n20 + (long)(n23 << this.subsampleBits);
                            l2 = ((long)n26 - (long)n25) * (long)n20 + (long)(n25 << this.subsampleBits);
                        }
                    } else {
                        l3 = ((long)n24 - (long)n23) * (long)n20 + ((long)n23 << this.subsampleBits);
                        l2 = ((long)n26 - (long)n25) * (long)n20 + ((long)n25 << this.subsampleBits);
                    }
                    nArray9[n15] = (int)((l2 - l3) * (long)n16 + (l3 << this.subsampleBits) + (long)this.round2 >> this.shift2);
                    n15 += n8;
                    ++n19;
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            float[] fArray5 = fArray3[n10];
            float[] fArray6 = fArray4[n10];
            int n11 = nArray3[n10];
            int n12 = nArray4[n10];
            int n13 = 0;
            while (n13 < n6) {
                int n14 = n11;
                float f2 = fArray2[n13];
                int n15 = nArray2[n13] + n12;
                int n16 = n15 + n3;
                int n17 = 0;
                while (n17 < n5) {
                    float f3 = fArray[n17];
                    int n18 = nArray[n17];
                    int n19 = n18 + n2;
                    float f4 = fArray6[n18 + n15];
                    float f5 = fArray6[n19 + n15];
                    float f6 = fArray6[n18 + n16];
                    float f7 = fArray6[n19 + n16];
                    float f8 = (f5 - f4) * f3 + f4;
                    float f9 = (f7 - f6) * f3 + f6;
                    fArray5[n14] = (f9 - f8) * f2 + f8;
                    n14 += n8;
                    ++n17;
                }
                n11 += n9;
                ++n13;
            }
            ++n10;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = (rasterAccessor.getWidth() - 1) * n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            double[] dArray3 = dArray[n10];
            double[] dArray4 = dArray2[n10];
            int n11 = nArray3[n10];
            int n12 = nArray4[n10];
            int n13 = 0;
            while (n13 < n6) {
                int n14 = n11;
                double d2 = fArray2[n13];
                int n15 = nArray2[n13] + n12;
                int n16 = n15 + n3;
                int n17 = 0;
                while (n17 < n5) {
                    double d3 = fArray[n17];
                    int n18 = nArray[n17];
                    int n19 = n18 + n2;
                    double d4 = dArray4[n18 + n15];
                    double d5 = dArray4[n19 + n15];
                    double d6 = dArray4[n18 + n16];
                    double d7 = dArray4[n19 + n16];
                    double d8 = (d5 - d4) * d3 + d4;
                    double d9 = (d7 - d6) * d3 + d6;
                    dArray3[n14] = (d9 - d8) * d2 + d8;
                    n14 += n8;
                    ++n17;
                }
                n11 += n9;
                ++n13;
            }
            ++n10;
        }
    }
}

