/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;

public final class ScaleBilinearBinaryOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleBilinearBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f2, f3, f4, f5);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n7];
        long l2 = n4;
        long l3 = 1L;
        long l4 = n5;
        long l5 = 1L;
        l2 = l2 * this.transXRationalDenom - this.transXRationalNum * l3;
        l4 = l4 * this.transYRationalDenom - this.transYRationalNum * l5;
        l2 = 2L * l2 + (l3 *= this.transXRationalDenom);
        l3 *= 2L;
        l4 = 2L * l4 + (l5 *= this.transYRationalDenom);
        l5 *= 2L;
        l2 *= this.invScaleXRationalNum;
        l4 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleXRationalDenom);
        l4 = 2L * l4 - (l5 *= this.invScaleYRationalDenom);
        l5 *= 2L;
        int n8 = Rational.floor(l2, l3 *= 2L);
        long l6 = l2 % l3;
        if (n8 < 0) {
            l6 = l3 + l6;
        }
        int n9 = Rational.floor(l4, l5);
        long l7 = l4 % l5;
        if (n9 < 0) {
            l7 = l5 + l7;
        }
        long l8 = l3 * this.invScaleXRationalDenom;
        l6 *= this.invScaleXRationalDenom;
        long l9 = this.invScaleXFrac * l3;
        long l10 = l5 * this.invScaleYRationalDenom;
        l7 *= this.invScaleYRationalDenom;
        long l11 = this.invScaleYFrac * l5;
        int n10 = 0;
        while (n10 < n6) {
            nArray[n10] = n8;
            nArray3[n10] = (int)((float)l6 / (float)l8 * (float)this.one);
            n8 = (int)((long)n8 + this.invScaleXInt);
            if ((l6 += l9) >= l8) {
                ++n8;
                l6 -= l8;
            }
            ++n10;
        }
        int n11 = 0;
        while (n11 < n7) {
            nArray2[n11] = n9;
            nArray4[n11] = (int)((float)l7 / (float)l10 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l7 += l11) >= l10) {
                ++n9;
                l7 -= l10;
            }
            ++n11;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n18 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n19 = dataBufferByte2.getOffset();
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int n20 = 0;
        while (n20 < n4) {
            n7 = nArray[n20];
            n6 = n10 + (n7 - n8);
            nArray5[n20] = n6 >> 3;
            nArray6[n20] = 7 - (n6 & 7);
            ++n20;
        }
        int n21 = 0;
        int n22 = 0;
        int n23 = (n3 - n15) * n17 + n19;
        int n24 = n16 + (n2 - n14);
        int n25 = 0;
        int n26 = 0;
        n26 = 0;
        while (n26 < n5) {
            n22 = nArray2[n26];
            int n27 = nArray4[n26];
            n7 = (n22 - n9) * n11 + n18;
            n24 = n16 + (n2 - n14);
            n25 = 0;
            while (n25 < n4) {
                int n28 = nArray3[n25];
                n21 = nArray[n25];
                int n29 = n10 + (n21 + 1 - n8);
                int n30 = n29 >> 3;
                int n31 = 7 - (n29 & 7);
                n6 = byArray[n7 + nArray5[n25]] >> nArray6[n25] & 1;
                int n32 = byArray[n7 + n30] >> n31 & 1;
                int n33 = byArray[n7 + n11 + nArray5[n25]] >> nArray6[n25] & 1;
                int n34 = byArray[n7 + n11 + n30] >> n31 & 1;
                int n35 = (n32 - n6) * n28 + (n6 << this.subsampleBits);
                int n36 = (n34 - n33) * n28 + (n33 << this.subsampleBits);
                int n37 = (n36 - n35) * n27 + ((n35 << this.subsampleBits) + this.round2) >> this.shift2;
                int n38 = n24 >> 3;
                int n39 = 7 - (n24 & 7);
                if (n37 == 1) {
                    int n40 = n23 + n38;
                    byArray2[n40] = (byte)(byArray2[n40] | 1 << n39);
                } else {
                    int n41 = n23 + n38;
                    byArray2[n41] = (byte)(byArray2[n41] & 255 - (1 << n39));
                }
                ++n24;
                ++n25;
            }
            n23 += n17;
            ++n26;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n18 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n19 = dataBufferUShort2.getOffset();
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int n20 = 0;
        while (n20 < n4) {
            n7 = nArray[n20];
            n6 = n10 + (n7 - n8);
            nArray5[n20] = n6 >> 4;
            nArray6[n20] = 15 - (n6 & 0xF);
            ++n20;
        }
        int n21 = (n3 - n15) * n17 + n19;
        int n22 = n16 + (n2 - n14);
        int n23 = 0;
        while (n23 < n5) {
            int n24 = nArray2[n23];
            int n25 = nArray4[n23];
            n7 = (n24 - n9) * n11 + n18;
            n22 = n16 + (n2 - n14);
            int n26 = 0;
            while (n26 < n4) {
                int n27 = nArray3[n26];
                int n28 = nArray[n26];
                int n29 = n10 + (n28 + 1 - n8);
                int n30 = n29 >> 4;
                int n31 = 15 - (n29 & 0xF);
                n6 = sArray[n7 + nArray5[n26]] >> nArray6[n26] & 1;
                int n32 = sArray[n7 + n30] >> n31 & 1;
                int n33 = sArray[n7 + n11 + nArray5[n26]] >> nArray6[n26] & 1;
                int n34 = sArray[n7 + n11 + n30] >> n31 & 1;
                int n35 = (n32 - n6) * n27 + (n6 << this.subsampleBits);
                int n36 = (n34 - n33) * n27 + (n33 << this.subsampleBits);
                int n37 = (n36 - n35) * n25 + (n35 << this.subsampleBits) + this.round2 >> this.shift2;
                int n38 = n22 >> 4;
                int n39 = 15 - (n22 & 0xF);
                if (n37 == 1) {
                    int n40 = n21 + n38;
                    sArray2[n40] = (short)(sArray2[n40] | 1 << n39);
                } else {
                    int n41 = n21 + n38;
                    sArray2[n41] = (short)(sArray2[n41] & 65535 - (1 << n39));
                }
                ++n22;
                ++n26;
            }
            n21 += n17;
            ++n23;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray5 = dataBufferInt.getData();
        int n18 = dataBufferInt.getOffset();
        int[] nArray6 = dataBufferInt2.getData();
        int n19 = dataBufferInt2.getOffset();
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n4];
        int n20 = 0;
        while (n20 < n4) {
            n7 = nArray[n20];
            n6 = n10 + (n7 - n8);
            nArray7[n20] = n6 >> 5;
            nArray8[n20] = 31 - (n6 & 0x1F);
            ++n20;
        }
        int n21 = (n3 - n15) * n17 + n19;
        int n22 = n16 + (n2 - n14);
        int n23 = 0;
        while (n23 < n5) {
            int n24 = nArray2[n23];
            int n25 = nArray4[n23];
            n7 = (n24 - n9) * n11 + n18;
            n22 = n16 + (n2 - n14);
            int n26 = 0;
            while (n26 < n4) {
                int n27 = nArray3[n26];
                int n28 = nArray[n26];
                int n29 = n10 + (n28 + 1 - n8);
                int n30 = n29 >> 5;
                int n31 = 31 - (n29 & 0x1F);
                n6 = nArray5[n7 + nArray7[n26]] >> nArray8[n26] & 1;
                int n32 = nArray5[n7 + n30] >> n31 & 1;
                int n33 = nArray5[n7 + n11 + nArray7[n26]] >> nArray8[n26] & 1;
                int n34 = nArray5[n7 + n11 + n30] >> n31 & 1;
                int n35 = (n32 - n6) * n27 + (n6 << this.subsampleBits);
                int n36 = (n34 - n33) * n27 + (n33 << this.subsampleBits);
                int n37 = (n36 - n35) * n25 + (n35 << this.subsampleBits) + this.round2 >> this.shift2;
                int n38 = n22 >> 5;
                int n39 = 31 - (n22 & 0x1F);
                if (n37 == 1) {
                    int n40 = n21 + n38;
                    nArray6[n40] = nArray6[n40] | 1 << n39;
                } else {
                    int n41 = n21 + n38;
                    nArray6[n41] = nArray6[n41] & 255 - (1 << n39);
                }
                ++n22;
                ++n26;
            }
            n21 += n17;
            ++n23;
        }
    }
}

