/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class OrOpImage
extends PointOpImage {
    public OrOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            byte[] byArray3 = rasterAccessor3.getBinaryDataArray();
            int n2 = byArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray3[n3] = (byte)(byArray[n3] | byArray2[n3]);
                ++n3;
            }
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getWidth();
        int n10 = rasterAccessor3.getHeight();
        int n11 = rasterAccessor3.getScanlineStride();
        int n12 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.byteLoop(n8, n9, n10, n4, n5, nArray, rasterAccessor.getByteDataArrays(), n6, n7, nArray2, rasterAccessor2.getByteDataArrays(), n11, n12, nArray3, rasterAccessor3.getByteDataArrays());
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(n8, n9, n10, n4, n5, nArray, rasterAccessor.getShortDataArrays(), n6, n7, nArray2, rasterAccessor2.getShortDataArrays(), n11, n12, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n8, n9, n10, n4, n5, nArray, rasterAccessor.getIntDataArrays(), n6, n7, nArray2, rasterAccessor2.getIntDataArrays(), n11, n12, nArray3, rasterAccessor3.getIntDataArrays());
            }
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void byteLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, byte[][] byArray, int n7, int n8, int[] nArray2, byte[][] byArray2, int n9, int n10, int[] nArray3, byte[][] byArray3) {
        int n11 = 0;
        while (n11 < n2) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n11];
            byte[] byArray6 = byArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n4) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n5;
                n13 += n7;
                n14 += n9;
                int n19 = 0;
                while (n19 < n3) {
                    byArray6[n18] = (byte)(byArray4[n16] | byArray5[n17]);
                    n16 += n6;
                    n17 += n8;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void shortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2, int n9, int n10, int[] nArray3, short[][] sArray3) {
        int n11 = 0;
        while (n11 < n2) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n11];
            short[] sArray6 = sArray3[n11];
            int n12 = nArray[n11];
            int n13 = nArray2[n11];
            int n14 = nArray3[n11];
            int n15 = 0;
            while (n15 < n4) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n5;
                n13 += n7;
                n14 += n9;
                int n19 = 0;
                while (n19 < n3) {
                    sArray6[n18] = (short)(sArray4[n16] | sArray5[n17]);
                    n16 += n6;
                    n17 += n8;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }

    private void intLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[][] nArray2, int n7, int n8, int[] nArray3, int[][] nArray4, int n9, int n10, int[] nArray5, int[][] nArray6) {
        int n11 = 0;
        while (n11 < n2) {
            int[] nArray7 = nArray2[n11];
            int[] nArray8 = nArray4[n11];
            int[] nArray9 = nArray6[n11];
            int n12 = nArray[n11];
            int n13 = nArray3[n11];
            int n14 = nArray5[n11];
            int n15 = 0;
            while (n15 < n4) {
                int n16 = n12;
                int n17 = n13;
                int n18 = n14;
                n12 += n5;
                n13 += n7;
                n14 += n9;
                int n19 = 0;
                while (n19 < n3) {
                    nArray9[n18] = nArray7[n16] | nArray8[n17];
                    n16 += n6;
                    n17 += n8;
                    n18 += n10;
                    ++n19;
                }
                ++n15;
            }
            ++n11;
        }
    }
}

