/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;

public class OctTreeOpImage
extends ColorQuantizerOpImage {
    private int treeSize;
    private int maxTreeDepth = 8;
    private int[] squares = new int[(this.maxColorNum << 1) + 1];

    public OctTreeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, int n3, ROI rOI, int n4, int n5) {
        super(renderedImage, map, imageLayout, n2, rOI, n4, n5);
        int n6 = -this.maxColorNum;
        while (n6 <= this.maxColorNum) {
            this.squares[n6 + this.maxColorNum] = n6 * n6;
            ++n6;
        }
        this.colorMap = null;
        this.treeSize = n3;
    }

    protected synchronized void train() {
        Cube cube = new Cube(this.getSourceImage(0), this.maxColorNum);
        cube.constructTree();
        cube.reduction();
        cube.assignment();
        this.colorMap = new LookupTableJAI(cube.colormap);
        this.setProperty("LUT", this.colorMap);
    }

    class Cube {
        PlanarImage source;
        int max_colors;
        byte[][] colormap = new byte[3][];
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(PlanarImage planarImage, int n2) {
            this.source = planarImage;
            this.max_colors = n2;
            int n3 = n2;
            this.depth = 0;
            while (n3 != 0) {
                n3 >>>= 1;
                ++this.depth;
            }
            if (this.depth > OctTreeOpImage.this.maxTreeDepth) {
                this.depth = OctTreeOpImage.this.maxTreeDepth;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void constructTree() {
            if (OctTreeOpImage.this.roi == null) {
                OctTreeOpImage.this.roi = new ROIShape(this.source.getBounds());
            }
            int n2 = this.source.getMinTileX();
            int n3 = this.source.getMaxTileX();
            int n4 = this.source.getMinTileY();
            int n5 = this.source.getMaxTileY();
            int n6 = this.source.getMinX();
            int n7 = this.source.getMinY();
            int n8 = n4;
            while (n8 <= n5) {
                int n9 = n2;
                while (n9 <= n3) {
                    block6: {
                        Rectangle rectangle;
                        block7: {
                            rectangle = this.source.getTileRect(n9, n8);
                            if (!OctTreeOpImage.this.roi.intersects(rectangle)) break block6;
                            if (!OctTreeOpImage.this.checkForSkippedTiles || rectangle.x < n6 || rectangle.y < n7) break block7;
                            int n10 = (OctTreeOpImage.this.xPeriod - (rectangle.x - n6) % OctTreeOpImage.this.xPeriod) % OctTreeOpImage.this.xPeriod;
                            int n11 = (OctTreeOpImage.this.yPeriod - (rectangle.y - n7) % OctTreeOpImage.this.yPeriod) % OctTreeOpImage.this.yPeriod;
                            if (n10 >= rectangle.width || n11 >= rectangle.height) break block6;
                        }
                        this.constructTree(this.source.getData(rectangle));
                    }
                    ++n9;
                }
                ++n8;
            }
        }

        private void constructTree(Raster raster) {
            LinkedList linkedList;
            if (!OctTreeOpImage.this.isInitialized) {
                OctTreeOpImage.this.srcPA = new PixelAccessor(OctTreeOpImage.this.getSourceImage(0));
                OctTreeOpImage.this.srcSampleType = OctTreeOpImage.this.srcPA.sampleType == -1 ? 0 : OctTreeOpImage.this.srcPA.sampleType;
                OctTreeOpImage.this.isInitialized = true;
            }
            Rectangle rectangle = OctTreeOpImage.this.getSourceImage(0).getBounds().intersection(raster.getBounds());
            if (OctTreeOpImage.this.roi == null) {
                linkedList = new LinkedList();
                linkedList.addLast(rectangle);
            } else {
                linkedList = OctTreeOpImage.this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (linkedList == null) {
                    return;
                }
            }
            ListIterator listIterator = linkedList.listIterator(0);
            int n2 = raster.getMinX();
            int n3 = raster.getMinY();
            while (listIterator.hasNext()) {
                Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
                int n4 = rectangle2.x;
                int n5 = rectangle2.y;
                rectangle2.x = ColorQuantizerOpImage.startPosition(n4, n2, OctTreeOpImage.this.xPeriod);
                rectangle2.y = ColorQuantizerOpImage.startPosition(n5, n3, OctTreeOpImage.this.yPeriod);
                rectangle2.width = n4 + rectangle2.width - rectangle2.x;
                rectangle2.height = n5 + rectangle2.height - rectangle2.y;
                if (rectangle2.isEmpty()) continue;
                UnpackedImageData unpackedImageData = OctTreeOpImage.this.srcPA.getPixels(raster, rectangle2, OctTreeOpImage.this.srcSampleType, false);
                switch (unpackedImageData.type) {
                    case 0: {
                        this.constructTreeByte(unpackedImageData);
                    }
                }
            }
        }

        private void constructTreeByte(UnpackedImageData unpackedImageData) {
            Rectangle rectangle = unpackedImageData.rect;
            byte[][] byArray = unpackedImageData.getByteData();
            int n2 = unpackedImageData.lineStride;
            int n3 = unpackedImageData.pixelStride;
            byte[] byArray2 = byArray[0];
            byte[] byArray3 = byArray[1];
            byte[] byArray4 = byArray[2];
            int n4 = n2 * OctTreeOpImage.this.yPeriod;
            int n5 = n3 * OctTreeOpImage.this.xPeriod;
            int n6 = rectangle.height * n2;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n3;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = byArray2[n9 + unpackedImageData.bandOffsets[0]] & 0xFF;
                    int n11 = byArray3[n9 + unpackedImageData.bandOffsets[1]] & 0xFF;
                    int n12 = byArray4[n9 + unpackedImageData.bandOffsets[2]] & 0xFF;
                    if (this.nodes > OctTreeOpImage.this.treeSize) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    int n13 = 1;
                    while (n13 <= this.depth) {
                        int n14 = (n10 > node.mid_red ? 1 : 0) | (n11 > node.mid_green ? 1 : 0) << 1 | (n12 > node.mid_blue ? 1 : 0) << 2;
                        node = node.child[n14] == null ? new Node(node, n14, n13) : node.child[n14];
                        ++node.number_pixels;
                        ++n13;
                    }
                    ++node.unique;
                    node.total_red += n10;
                    node.total_green += n11;
                    node.total_blue += n12;
                    n9 += n5;
                }
                n7 += n4;
            }
        }

        void reduction() {
            int n2 = (this.source.getWidth() + OctTreeOpImage.this.xPeriod - 1) / OctTreeOpImage.this.xPeriod * (this.source.getHeight() + OctTreeOpImage.this.yPeriod - 1) / OctTreeOpImage.this.yPeriod;
            int n3 = Math.max(1, n2 / (this.max_colors * 8));
            while (this.colors > this.max_colors) {
                this.colors = 0;
                n3 = this.root.reduce(n3, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new byte[3][this.colors];
            this.colors = 0;
            this.root.colormap();
        }

        class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube2) {
                this.cube = cube2;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
                this.mid_green = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
                this.mid_blue = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
            }

            Node(Node node, int n2, int n3) {
                this.cube = node.cube;
                this.parent = node;
                this.child = new Node[8];
                this.id = n2;
                this.level = n3;
                ++this.cube.nodes;
                if (n3 == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++node.nchild;
                node.child[n2] = this;
                int n4 = 1 << OctTreeOpImage.this.maxTreeDepth - n3 >> 1;
                this.mid_red = node.mid_red + ((n2 & 1) > 0 ? n4 : -n4);
                this.mid_green = node.mid_green + ((n2 & 2) > 0 ? n4 : -n4);
                this.mid_blue = node.mid_blue + ((n2 & 4) > 0 ? n4 : -n4);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    int n2 = 0;
                    while (n2 < 8) {
                        if (this.child[n2] != null) {
                            this.child[n2].pruneLevel();
                        }
                        ++n2;
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int n2, int n3) {
                if (this.nchild != 0) {
                    int n4 = 0;
                    while (n4 < 8) {
                        if (this.child[n4] != null) {
                            n3 = this.child[n4].reduce(n2, n3);
                        }
                        ++n4;
                    }
                }
                if (this.number_pixels <= n2) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < n3) {
                        n3 = this.number_pixels;
                    }
                }
                return n3;
            }

            void colormap() {
                if (this.nchild != 0) {
                    int n2 = 0;
                    while (n2 < 8) {
                        if (this.child[n2] != null) {
                            this.child[n2].colormap();
                        }
                        ++n2;
                    }
                }
                if (this.unique != 0) {
                    this.cube.colormap[0][this.cube.colors] = (byte)((this.total_red + (this.unique >> 1)) / this.unique);
                    this.cube.colormap[1][this.cube.colors] = (byte)((this.total_green + (this.unique >> 1)) / this.unique);
                    this.cube.colormap[2][this.cube.colors] = (byte)((this.total_blue + (this.unique >> 1)) / this.unique);
                    this.color_number = this.cube.colors++;
                }
            }
        }
    }
}

