/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class NotOpImage
extends ColormapOpImage {
    public NotOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = ~byArray2[n4];
                ++n4;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = ~byArray[n3];
                ++n3;
            }
            rasterAccessor2.copyBinaryDataToRaster();
            return;
        }
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor2.getNumBands();
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getScanlineStride();
        int n10 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n6, n7, n8, n4, n5, nArray, rasterAccessor.getByteDataArrays(), n9, n10, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(n6, n7, n8, n4, n5, nArray, rasterAccessor.getShortDataArrays(), n9, n10, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n6, n7, n8, n4, n5, nArray, rasterAccessor.getIntDataArrays(), n9, n10, nArray2, rasterAccessor2.getIntDataArrays());
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void byteLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, byte[][] byArray, int n7, int n8, int[] nArray2, byte[][] byArray2) {
        int n9 = 0;
        while (n9 < n2) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n3) {
                    byArray4[n14] = ~byArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n2) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n3) {
                    sArray4[n14] = ~sArray3[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[][] nArray2, int n7, int n8, int[] nArray3, int[][] nArray4) {
        int n9 = 0;
        while (n9 < n2) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n3) {
                    nArray6[n14] = ~nArray5[n13];
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }
}

