/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class MultiplyConstOpImage
extends ColormapOpImage {
    protected double[] constants;

    public MultiplyConstOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.getSampleModel().getNumBands();
        if (dArray.length < n2) {
            this.constants = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.constants[n3] = dArray[0];
                ++n3;
            }
        } else {
            this.constants = (double[])dArray.clone();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            double d2 = n2 < this.constants.length ? this.constants[n2] : this.constants[0];
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = ImageUtil.clampRoundByte((double)(byArray2[n4] & 0xFF) * d2);
                ++n4;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float f2 = (float)this.constants[n9];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    byArray3[n13] = ImageUtil.clampRoundByte((float)(byArray4[n14] & 0xFF) * f2);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float f2 = (float)this.constants[n9];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    sArray3[n13] = ImageUtil.clampRoundUShort((float)(sArray4[n14] & 0xFFFF) * f2);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float f2 = (float)this.constants[n9];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    sArray3[n13] = ImageUtil.clampRoundShort((float)sArray4[n14] * f2);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double d2 = this.constants[n9];
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    nArray5[n13] = ImageUtil.clampRoundInt((double)nArray6[n14] * d2);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double d2 = this.constants[n9];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    fArray3[n13] = ImageUtil.clampFloat((double)fArray4[n14] * d2);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double d2 = this.constants[n9];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    dArray3[n13] = dArray4[n14] * d2;
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }
}

