/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    private static final int WEIGHT_TYPE_ALPHA = 1;
    private static final int WEIGHT_TYPE_ROI = 2;
    private static final int WEIGHT_TYPE_THRESHOLD = 3;
    protected MosaicType mosaicType;
    protected PlanarImage[] sourceAlpha;
    protected ROI[] sourceROI;
    protected double[][] sourceThreshold;
    protected double[] backgroundValues;
    protected int numBands = this.sampleModel.getNumBands();
    protected int[] background;
    protected int[][] threshold;
    protected boolean isAlphaBitmask = false;
    private BorderExtender sourceExtender;
    private BorderExtender zeroExtender;
    private PlanarImage[] roiImage;

    private static final ImageLayout getLayout(Vector vector, ImageLayout imageLayout) {
        int n2;
        Object object;
        Object object2;
        RenderedImage renderedImage = null;
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        int n3 = vector.size();
        if (n3 > 0) {
            renderedImage = (RenderedImage)vector.get(0);
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
        } else if (imageLayout != null && imageLayout.isValid(268)) {
            sampleModel = imageLayout.getSampleModel(null);
            if (sampleModel == null) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage7"));
            }
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage8"));
        }
        int n4 = sampleModel.getDataType();
        int n5 = sampleModel.getNumBands();
        int n6 = sampleModel.getSampleSize(0);
        int n7 = 1;
        while (n7 < n5) {
            if (sampleModel.getSampleSize(n7) != n6) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
            }
            ++n7;
        }
        if (n3 < 1) {
            return (ImageLayout)imageLayout.clone();
        }
        int n8 = 1;
        while (n8 < n3) {
            object2 = (RenderedImage)vector.get(n8);
            object = object2.getSampleModel();
            if (((SampleModel)object).getDataType() != n4) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage2"));
            }
            if (((SampleModel)object).getNumBands() != n5) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage3"));
            }
            n2 = 0;
            while (n2 < n5) {
                if (((SampleModel)object).getSampleSize(n2) != n6) {
                    throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
                }
                ++n2;
            }
            ++n8;
        }
        object2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        object = new Rectangle();
        if (((ImageLayout)object2).isValid(15)) {
            ((Rectangle)object).setBounds(((ImageLayout)object2).getMinX(null), ((ImageLayout)object2).getMinY(null), ((ImageLayout)object2).getWidth(null), ((ImageLayout)object2).getHeight(null));
        } else if (n3 > 0) {
            ((Rectangle)object).setBounds(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            n2 = 1;
            while (n2 < n3) {
                RenderedImage renderedImage2 = (RenderedImage)vector.get(n2);
                Rectangle rectangle = new Rectangle(renderedImage2.getMinX(), renderedImage2.getMinY(), renderedImage2.getWidth(), renderedImage2.getHeight());
                object = ((Rectangle)object).union(rectangle);
                ++n2;
            }
        }
        ((ImageLayout)object2).setMinX(((Rectangle)object).x);
        ((ImageLayout)object2).setMinY(((Rectangle)object).y);
        ((ImageLayout)object2).setWidth(((Rectangle)object).width);
        ((ImageLayout)object2).setHeight(((Rectangle)object).height);
        if (((ImageLayout)object2).isValid(256)) {
            SampleModel sampleModel2 = ((ImageLayout)object2).getSampleModel(null);
            boolean bl = sampleModel2.getNumBands() != n5 || sampleModel2.getDataType() != n4;
            int n9 = 0;
            while (!bl && n9 < n5) {
                if (sampleModel2.getSampleSize(n9) != n6) {
                    bl = true;
                }
                ++n9;
            }
            if (bl) {
                ((ImageLayout)object2).unsetValid(256);
            }
        }
        return object2;
    }

    public MosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] object, double[] dArray) {
        super(vector, MosaicOpImage.getLayout(vector, imageLayout), map, true);
        double d2;
        int n2;
        int n3;
        int n4 = this.getNumSources();
        this.mosaicType = mosaicType;
        this.sourceAlpha = null;
        if (planarImageArray != null) {
            n3 = 0;
            while (n3 < planarImageArray.length) {
                if (planarImageArray[n3] != null) {
                    SampleModel sampleModel = planarImageArray[n3].getSampleModel();
                    if (sampleModel.getNumBands() != 1) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                    if (sampleModel.getDataType() != this.sampleModel.getDataType()) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                    if (sampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                }
                ++n3;
            }
            this.sourceAlpha = new PlanarImage[n4];
            System.arraycopy(planarImageArray, 0, this.sourceAlpha, 0, Math.min(planarImageArray.length, n4));
        }
        this.sourceROI = null;
        if (rOIArray != null) {
            this.sourceROI = new ROI[n4];
            System.arraycopy(rOIArray, 0, this.sourceROI, 0, Math.min(rOIArray.length, n4));
        }
        boolean bl = this.isAlphaBitmask = mosaicType != MosaicDescriptor.MOSAIC_TYPE_BLEND || planarImageArray == null || planarImageArray.length < n4;
        if (!this.isAlphaBitmask) {
            n3 = 0;
            while (n3 < n4) {
                if (planarImageArray[n3] == null) {
                    this.isAlphaBitmask = true;
                    break;
                }
                ++n3;
            }
        }
        this.sourceThreshold = new double[n4][this.numBands];
        if (object == null) {
            object = new double[][]{{1.0}};
        }
        n3 = 0;
        while (n3 < n4) {
            if (n3 < ((double[][])object).length && object[n3] != null) {
                if (object[n3].length < this.numBands) {
                    Arrays.fill(this.sourceThreshold[n3], object[n3][0]);
                } else {
                    System.arraycopy(object[n3], 0, this.sourceThreshold[n3], 0, this.numBands);
                }
            } else {
                this.sourceThreshold[n3] = this.sourceThreshold[0];
            }
            ++n3;
        }
        this.threshold = new int[n4][this.numBands];
        int n5 = 0;
        while (n5 < n4) {
            n2 = 0;
            while (n2 < this.numBands) {
                this.threshold[n5][n2] = (int)this.sourceThreshold[n5][n2];
                ++n2;
            }
            ++n5;
        }
        this.backgroundValues = new double[this.numBands];
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        if (dArray.length < this.numBands) {
            Arrays.fill(this.backgroundValues, dArray[0]);
        } else {
            System.arraycopy(dArray, 0, this.backgroundValues, 0, this.numBands);
        }
        this.background = new int[this.backgroundValues.length];
        n2 = this.sampleModel.getDataType();
        int n6 = 0;
        while (n6 < this.background.length) {
            switch (n2) {
                case 0: {
                    this.background[n6] = ImageUtil.clampRoundByte(this.backgroundValues[n6]);
                    break;
                }
                case 1: {
                    this.background[n6] = ImageUtil.clampRoundUShort(this.backgroundValues[n6]);
                    break;
                }
                case 2: {
                    this.background[n6] = ImageUtil.clampRoundShort(this.backgroundValues[n6]);
                    break;
                }
                case 3: {
                    this.background[n6] = ImageUtil.clampRoundInt(this.backgroundValues[n6]);
                    break;
                }
            }
            ++n6;
        }
        switch (n2) {
            case 0: {
                d2 = 0.0;
                break;
            }
            case 1: {
                d2 = 0.0;
                break;
            }
            case 2: {
                d2 = -32768.0;
                break;
            }
            case 3: {
                d2 = -2.147483648E9;
                break;
            }
            case 4: {
                d2 = -3.4028234663852886E38;
                break;
            }
            default: {
                d2 = -1.7976931348623157E308;
            }
        }
        BorderExtender borderExtender = this.sourceExtender = d2 == 0.0 ? BorderExtender.createInstance(0) : new BorderExtenderConstant(new double[]{d2});
        if (planarImageArray != null || rOIArray != null) {
            this.zeroExtender = BorderExtender.createInstance(0);
        }
        if (rOIArray != null) {
            this.roiImage = new PlanarImage[n4];
            int n7 = 0;
            while (n7 < rOIArray.length) {
                if (rOIArray[n7] != null) {
                    this.roiImage[n7] = rOIArray[n7].getAsImage();
                }
                ++n7;
            }
        }
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getSourceImage(n2).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getBounds());
    }

    public Raster computeTile(int n2, int n3) {
        Object object;
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n2), this.tileYToY(n3)));
        Rectangle rectangle = this.getTileRect(n2, n3);
        int n4 = this.getNumSources();
        Raster[] rasterArray = new Raster[n4];
        Raster[] rasterArray2 = this.sourceAlpha != null ? new Raster[n4] : null;
        Raster[] rasterArray3 = this.sourceROI != null ? new Raster[n4] : null;
        int n5 = 0;
        while (n5 < n4) {
            PlanarImage planarImage = this.getSourceImage(n5);
            object = this.mapDestRect(rectangle, n5);
            Raster raster = rasterArray[n5] = object != null && ((Rectangle)object).isEmpty() ? null : planarImage.getExtendedData(rectangle, this.sourceExtender);
            if (rasterArray[n5] != null) {
                if (this.sourceAlpha != null && this.sourceAlpha[n5] != null) {
                    rasterArray2[n5] = this.sourceAlpha[n5].getExtendedData(rectangle, this.zeroExtender);
                }
                if (this.sourceROI != null && this.sourceROI[n5] != null) {
                    rasterArray3[n5] = this.roiImage[n5].getExtendedData(rectangle, this.zeroExtender);
                }
            }
            ++n5;
        }
        this.computeRect(rasterArray, writableRaster, rectangle, rasterArray2, rasterArray3);
        int n6 = 0;
        while (n6 < n4) {
            PlanarImage planarImage;
            object = rasterArray[n6];
            if (object != null && (planarImage = this.getSourceImage(n6)).overlapsMultipleTiles(((Raster)object).getBounds())) {
                this.recycleTile((Raster)object);
            }
            ++n6;
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.computeRect(rasterArray, writableRaster, rectangle, null, null);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        Object object;
        int n2 = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (rasterArray[n3] != null) {
                arrayList.add(rasterArray[n3]);
            }
            ++n3;
        }
        int n4 = arrayList.size();
        if (n4 == 0) {
            ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            return;
        }
        SampleModel[] sampleModelArray = new SampleModel[n4];
        int n5 = 0;
        while (n5 < n4) {
            sampleModelArray[n5] = ((Raster)arrayList.get(n5)).getSampleModel();
            ++n5;
        }
        int n6 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterAccessor[] rasterAccessorArray = new RasterAccessor[n2];
        int n7 = 0;
        while (n7 < n2) {
            if (rasterArray[n7] != null) {
                object = new RasterFormatTag(rasterArray[n7].getSampleModel(), n6);
                rasterAccessorArray[n7] = new RasterAccessor(rasterArray[n7], rectangle, (RasterFormatTag)object, null);
            }
            ++n7;
        }
        object = new RasterAccessor(writableRaster, rectangle, new RasterFormatTag(writableRaster.getSampleModel(), n6), null);
        RasterAccessor[] rasterAccessorArray2 = new RasterAccessor[n2];
        if (rasterArray2 != null) {
            int n8 = 0;
            while (n8 < n2) {
                if (rasterArray2[n8] != null) {
                    SampleModel sampleModel = rasterArray2[n8].getSampleModel();
                    int n9 = RasterAccessor.findCompatibleTag(null, sampleModel);
                    RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel, n9);
                    rasterAccessorArray2[n8] = new RasterAccessor(rasterArray2[n8], rectangle, rasterFormatTag, this.sourceAlpha[n8].getColorModel());
                }
                ++n8;
            }
        }
        switch (((RasterAccessor)object).getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
            }
        }
        ((RasterAccessor)object).copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        byte[][][] byArrayArray = new byte[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                byArrayArray[n3] = rasterAccessorArray[n3].getByteDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        byte[][][] byArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            nArrayArray2 = new int[n2][];
            byArrayArray2 = new byte[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray4[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray5[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray2[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    byArrayArray2[n14] = rasterAccessorArray2[n14].getByteDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray6 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray6[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray6[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray6[n15] = 2;
            }
            ++n15;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        byte[][] byArrayArray3 = new byte[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        byte[][] byArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            byArrayArray4 = new byte[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23 = 0;
            while (n23 < n2) {
                if (rasterAccessorArray[n23] != null) {
                    byArrayArray3[n23] = byArrayArray[n23][n16];
                    nArray7[n23] = nArrayArray[n23][n16];
                }
                if (nArray6[n23] == 1) {
                    byArrayArray4[n23] = byArrayArray2[n23][0];
                    nArray9[n23] = nArrayArray2[n23][0];
                }
                ++n23;
            }
            byte[] byArray2 = byArray[n16];
            int n24 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n25 = n21;
                            nArray7[n25] = nArray7[n25] + nArray[n21];
                        }
                        if (rasterAccessorArray2[n21] != null) {
                            nArray10[n21] = nArray9[n21];
                            int n26 = n21;
                            nArray9[n26] = nArray9[n26] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        boolean bl2 = false;
                        int n27 = 0;
                        while (n27 < n2) {
                            if (rasterAccessorArray[n27] != null) {
                                n18 = byArrayArray3[n27][nArray8[n27]];
                                int n28 = n27;
                                nArray8[n28] = nArray8[n28] + nArray2[n27];
                                switch (nArray6[n27]) {
                                    case 1: {
                                        bl2 = byArrayArray4[n27][nArray10[n27]] != 0;
                                        int n29 = n27;
                                        nArray10[n29] = nArray10[n29] + nArray5[n27];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n27].getSample(n19, n22, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n18 & 0xFF) >= this.sourceThreshold[n27][n16];
                                    }
                                }
                                if (bl2) {
                                    byArray2[n20] = n18;
                                    n17 = n27 + 1;
                                    while (n17 < n2) {
                                        if (rasterAccessorArray[n17] != null) {
                                            int n30 = n17;
                                            nArray8[n30] = nArray8[n30] + nArray2[n17];
                                        }
                                        if (rasterAccessorArray2[n17] != null) {
                                            int n31 = n17;
                                            nArray10[n31] = nArray10[n31] + nArray5[n17];
                                        }
                                        ++n17;
                                    }
                                    break;
                                }
                            }
                            ++n27;
                        }
                        if (!bl2) {
                            byArray2[n20] = (byte)this.background[n16];
                        }
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            } else {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n32 = n21;
                            nArray7[n32] = nArray7[n32] + nArray[n21];
                        }
                        if (nArray6[n21] == 1) {
                            nArray10[n21] = nArray9[n21];
                            int n33 = n21;
                            nArray9[n33] = nArray9[n33] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n18 = 0;
                        while (n18 < n2) {
                            if (rasterAccessorArray[n18] != null) {
                                n17 = byArrayArray3[n18][nArray8[n18]];
                                int n34 = n18;
                                nArray8[n34] = nArray8[n34] + nArray2[n18];
                                float f4 = 0.0f;
                                switch (nArray6[n18]) {
                                    case 1: {
                                        f4 = byArrayArray4[n18][nArray10[n18]] & 0xFF;
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 255.0f);
                                        int n35 = n18;
                                        nArray10[n35] = nArray10[n35] + nArray5[n18];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n18].getSample(n19, n22, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)(n17 & 0xFF) >= this.sourceThreshold[n18][n16] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)(n17 & 0xFF);
                                f3 += f4;
                            }
                            ++n18;
                        }
                        byArray2[n20] = (double)f3 == 0.0 ? (byte)this.background[n16] : ImageUtil.clampRoundByte(f2 / f3);
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            }
            ++n16;
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        short[][][] sArrayArray = new short[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                sArrayArray[n3] = rasterAccessorArray[n3].getShortDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            nArrayArray2 = new int[n2][];
            sArrayArray2 = new short[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray4[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray5[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray2[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    sArrayArray2[n14] = rasterAccessorArray2[n14].getShortDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray6 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray6[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray6[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray6[n15] = 2;
            }
            ++n15;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        short[][] sArrayArray3 = new short[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            sArrayArray4 = new short[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23 = 0;
            while (n23 < n2) {
                if (rasterAccessorArray[n23] != null) {
                    sArrayArray3[n23] = sArrayArray[n23][n16];
                    nArray7[n23] = nArrayArray[n23][n16];
                }
                if (nArray6[n23] == 1) {
                    sArrayArray4[n23] = sArrayArray2[n23][0];
                    nArray9[n23] = nArrayArray2[n23][0];
                }
                ++n23;
            }
            short[] sArray2 = sArray[n16];
            int n24 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n25 = n21;
                            nArray7[n25] = nArray7[n25] + nArray[n21];
                        }
                        if (rasterAccessorArray2[n21] != null) {
                            nArray10[n21] = nArray9[n21];
                            int n26 = n21;
                            nArray9[n26] = nArray9[n26] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        boolean bl2 = false;
                        int n27 = 0;
                        while (n27 < n2) {
                            if (rasterAccessorArray[n27] != null) {
                                n18 = sArrayArray3[n27][nArray8[n27]];
                                int n28 = n27;
                                nArray8[n28] = nArray8[n28] + nArray2[n27];
                                switch (nArray6[n27]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n27][nArray10[n27]] != 0;
                                        int n29 = n27;
                                        nArray10[n29] = nArray10[n29] + nArray5[n27];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n27].getSample(n19, n22, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n18 & 0xFFFF) >= this.sourceThreshold[n27][n16];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n20] = n18;
                                    n17 = n27 + 1;
                                    while (n17 < n2) {
                                        if (rasterAccessorArray[n17] != null) {
                                            int n30 = n17;
                                            nArray8[n30] = nArray8[n30] + nArray2[n17];
                                        }
                                        if (rasterAccessorArray2[n17] != null) {
                                            int n31 = n17;
                                            nArray10[n31] = nArray10[n31] + nArray5[n17];
                                        }
                                        ++n17;
                                    }
                                    break;
                                }
                            }
                            ++n27;
                        }
                        if (!bl2) {
                            sArray2[n20] = (short)this.background[n16];
                        }
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            } else {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n32 = n21;
                            nArray7[n32] = nArray7[n32] + nArray[n21];
                        }
                        if (nArray6[n21] == 1) {
                            nArray10[n21] = nArray9[n21];
                            int n33 = n21;
                            nArray9[n33] = nArray9[n33] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n18 = 0;
                        while (n18 < n2) {
                            if (rasterAccessorArray[n18] != null) {
                                n17 = sArrayArray3[n18][nArray8[n18]];
                                int n34 = n18;
                                nArray8[n34] = nArray8[n34] + nArray2[n18];
                                float f4 = 0.0f;
                                switch (nArray6[n18]) {
                                    case 1: {
                                        f4 = sArrayArray4[n18][nArray10[n18]] & 0xFFFF;
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 65535.0f);
                                        int n35 = n18;
                                        nArray10[n35] = nArray10[n35] + nArray5[n18];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n18].getSample(n19, n22, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)(n17 & 0xFFFF) >= this.sourceThreshold[n18][n16] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)(n17 & 0xFFFF);
                                f3 += f4;
                            }
                            ++n18;
                        }
                        sArray2[n20] = (double)f3 == 0.0 ? (short)this.background[n16] : ImageUtil.clampRoundUShort(f2 / f3);
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            }
            ++n16;
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        short[][][] sArrayArray = new short[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                sArrayArray[n3] = rasterAccessorArray[n3].getShortDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            nArrayArray2 = new int[n2][];
            sArrayArray2 = new short[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray4[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray5[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray2[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    sArrayArray2[n14] = rasterAccessorArray2[n14].getShortDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray6 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray6[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray6[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray6[n15] = 2;
            }
            ++n15;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        short[][] sArrayArray3 = new short[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            sArrayArray4 = new short[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23 = 0;
            while (n23 < n2) {
                if (rasterAccessorArray[n23] != null) {
                    sArrayArray3[n23] = sArrayArray[n23][n16];
                    nArray7[n23] = nArrayArray[n23][n16];
                }
                if (nArray6[n23] == 1) {
                    sArrayArray4[n23] = sArrayArray2[n23][0];
                    nArray9[n23] = nArrayArray2[n23][0];
                }
                ++n23;
            }
            short[] sArray2 = sArray[n16];
            int n24 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n25 = n21;
                            nArray7[n25] = nArray7[n25] + nArray[n21];
                        }
                        if (rasterAccessorArray2[n21] != null) {
                            nArray10[n21] = nArray9[n21];
                            int n26 = n21;
                            nArray9[n26] = nArray9[n26] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        boolean bl2 = false;
                        int n27 = 0;
                        while (n27 < n2) {
                            if (rasterAccessorArray[n27] != null) {
                                n18 = sArrayArray3[n27][nArray8[n27]];
                                int n28 = n27;
                                nArray8[n28] = nArray8[n28] + nArray2[n27];
                                switch (nArray6[n27]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n27][nArray10[n27]] != 0;
                                        int n29 = n27;
                                        nArray10[n29] = nArray10[n29] + nArray5[n27];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n27].getSample(n19, n22, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n18 >= this.sourceThreshold[n27][n16];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n20] = n18;
                                    n17 = n27 + 1;
                                    while (n17 < n2) {
                                        if (rasterAccessorArray[n17] != null) {
                                            int n30 = n17;
                                            nArray8[n30] = nArray8[n30] + nArray2[n17];
                                        }
                                        if (rasterAccessorArray2[n17] != null) {
                                            int n31 = n17;
                                            nArray10[n31] = nArray10[n31] + nArray5[n17];
                                        }
                                        ++n17;
                                    }
                                    break;
                                }
                            }
                            ++n27;
                        }
                        if (!bl2) {
                            sArray2[n20] = (short)this.background[n16];
                        }
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            } else {
                n22 = n5;
                while (n22 < n9) {
                    n21 = 0;
                    while (n21 < n2) {
                        if (rasterAccessorArray[n21] != null) {
                            nArray8[n21] = nArray7[n21];
                            int n32 = n21;
                            nArray7[n32] = nArray7[n32] + nArray[n21];
                        }
                        if (nArray6[n21] == 1) {
                            nArray10[n21] = nArray9[n21];
                            int n33 = n21;
                            nArray9[n33] = nArray9[n33] + nArray4[n21];
                        }
                        ++n21;
                    }
                    n20 = n24;
                    n24 += n11;
                    n19 = n4;
                    while (n19 < n8) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n18 = 0;
                        while (n18 < n2) {
                            if (rasterAccessorArray[n18] != null) {
                                n17 = sArrayArray3[n18][nArray8[n18]];
                                int n34 = n18;
                                nArray8[n34] = nArray8[n34] + nArray2[n18];
                                float f4 = 0.0f;
                                switch (nArray6[n18]) {
                                    case 1: {
                                        f4 = sArrayArray4[n18][nArray10[n18]];
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 32767.0f);
                                        int n35 = n18;
                                        nArray10[n35] = nArray10[n35] + nArray5[n18];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n18].getSample(n19, n22, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)n17 >= this.sourceThreshold[n18][n16] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)n17;
                                f3 += f4;
                            }
                            ++n18;
                        }
                        sArray2[n20] = (double)f3 == 0.0 ? (short)this.background[n16] : ImageUtil.clampRoundShort(f2 / f3);
                        n20 += n12;
                        ++n19;
                    }
                    ++n22;
                }
            }
            ++n16;
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        int[][][] nArrayArray2 = new int[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                nArrayArray2[n3] = rasterAccessorArray[n3].getIntDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int[][] nArrayArray3 = null;
        int[][][] nArrayArray4 = null;
        if (bl) {
            nArray5 = new int[n2];
            nArray6 = new int[n2];
            nArrayArray3 = new int[n2][];
            nArrayArray4 = new int[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray5[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray6[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray3[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    nArrayArray4[n14] = rasterAccessorArray2[n14].getIntDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray7 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray7[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray7[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray7[n15] = 2;
            }
            ++n15;
        }
        int[] nArray8 = new int[n2];
        int[] nArray9 = new int[n2];
        int[][] nArrayArray5 = new int[n2][];
        int[] nArray10 = null;
        int[] nArray11 = null;
        int[][] nArrayArray6 = null;
        if (bl) {
            nArray10 = new int[n2];
            nArray11 = new int[n2];
            nArrayArray6 = new int[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21 = 0;
            while (n21 < n2) {
                if (rasterAccessorArray[n21] != null) {
                    nArrayArray5[n21] = nArrayArray2[n21][n16];
                    nArray8[n21] = nArrayArray[n21][n16];
                }
                if (nArray7[n21] == 1) {
                    nArrayArray6[n21] = nArrayArray4[n21][0];
                    nArray10[n21] = nArrayArray3[n21][0];
                }
                ++n21;
            }
            int[] nArray12 = nArray4[n16];
            int n22 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n20 = n5;
                while (n20 < n9) {
                    n19 = 0;
                    while (n19 < n2) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray9[n19] = nArray8[n19];
                            int n23 = n19;
                            nArray8[n23] = nArray8[n23] + nArray[n19];
                        }
                        if (rasterAccessorArray2[n19] != null) {
                            nArray11[n19] = nArray10[n19];
                            int n24 = n19;
                            nArray10[n24] = nArray10[n24] + nArray5[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n11;
                    n17 = n4;
                    while (n17 < n8) {
                        boolean bl2 = false;
                        int n25 = 0;
                        while (n25 < n2) {
                            if (rasterAccessorArray[n25] != null) {
                                int n26 = nArrayArray5[n25][nArray9[n25]];
                                int n27 = n25;
                                nArray9[n27] = nArray9[n27] + nArray2[n25];
                                switch (nArray7[n25]) {
                                    case 1: {
                                        bl2 = nArrayArray6[n25][nArray11[n25]] != 0;
                                        int n28 = n25;
                                        nArray11[n28] = nArray11[n28] + nArray6[n25];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n25].getSample(n17, n20, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n26 >= this.sourceThreshold[n25][n16];
                                    }
                                }
                                if (bl2) {
                                    nArray12[n18] = n26;
                                    int n29 = n25 + 1;
                                    while (n29 < n2) {
                                        if (rasterAccessorArray[n29] != null) {
                                            int n30 = n29;
                                            nArray9[n30] = nArray9[n30] + nArray2[n29];
                                        }
                                        if (rasterAccessorArray2[n29] != null) {
                                            int n31 = n29;
                                            nArray11[n31] = nArray11[n31] + nArray6[n29];
                                        }
                                        ++n29;
                                    }
                                    break;
                                }
                            }
                            ++n25;
                        }
                        if (!bl2) {
                            nArray12[n18] = this.background[n16];
                        }
                        n18 += n12;
                        ++n17;
                    }
                    ++n20;
                }
            } else {
                n20 = n5;
                while (n20 < n9) {
                    n19 = 0;
                    while (n19 < n2) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray9[n19] = nArray8[n19];
                            int n32 = n19;
                            nArray8[n32] = nArray8[n32] + nArray[n19];
                        }
                        if (nArray7[n19] == 1) {
                            nArray11[n19] = nArray10[n19];
                            int n33 = n19;
                            nArray10[n33] = nArray10[n33] + nArray5[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n11;
                    n17 = n4;
                    while (n17 < n8) {
                        double d2 = 0.0;
                        double d3 = 0.0;
                        int n34 = 0;
                        while (n34 < n2) {
                            if (rasterAccessorArray[n34] != null) {
                                int n35 = nArrayArray5[n34][nArray9[n34]];
                                int n36 = n34;
                                nArray9[n36] = nArray9[n36] + nArray2[n34];
                                double d4 = 0.0;
                                switch (nArray7[n34]) {
                                    case 1: {
                                        d4 = nArrayArray6[n34][nArray11[n34]];
                                        d4 = d4 > 0.0 && this.isAlphaBitmask ? 1.0 : (d4 /= 2.147483647E9);
                                        int n37 = n34;
                                        nArray11[n37] = nArray11[n37] + nArray6[n34];
                                        break;
                                    }
                                    case 2: {
                                        d4 = rasterArray[n34].getSample(n17, n20, 0) > 0 ? 1.0 : 0.0;
                                        break;
                                    }
                                    default: {
                                        d4 = (double)n35 >= this.sourceThreshold[n34][n16] ? 1.0 : 0.0;
                                    }
                                }
                                d2 += d4 * (double)n35;
                                d3 += d4;
                            }
                            ++n34;
                        }
                        nArray12[n18] = d3 == 0.0 ? this.background[n16] : ImageUtil.clampRoundInt(d2 / d3);
                        n18 += n12;
                        ++n17;
                    }
                    ++n20;
                }
            }
            ++n16;
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        float[][][] fArrayArray = new float[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                fArrayArray[n3] = rasterAccessorArray[n3].getFloatDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        float[][][] fArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            nArrayArray2 = new int[n2][];
            fArrayArray2 = new float[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray4[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray5[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray2[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    fArrayArray2[n14] = rasterAccessorArray2[n14].getFloatDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray6 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray6[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray6[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray6[n15] = 2;
            }
            ++n15;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        float[][] fArrayArray3 = new float[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        float[][] fArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            fArrayArray4 = new float[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21 = 0;
            while (n21 < n2) {
                if (rasterAccessorArray[n21] != null) {
                    fArrayArray3[n21] = fArrayArray[n21][n16];
                    nArray7[n21] = nArrayArray[n21][n16];
                }
                if (nArray6[n21] == 1) {
                    fArrayArray4[n21] = fArrayArray2[n21][0];
                    nArray9[n21] = nArrayArray2[n21][0];
                }
                ++n21;
            }
            float[] fArray2 = fArray[n16];
            int n22 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n20 = n5;
                while (n20 < n9) {
                    n19 = 0;
                    while (n19 < n2) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray8[n19] = nArray7[n19];
                            int n23 = n19;
                            nArray7[n23] = nArray7[n23] + nArray[n19];
                        }
                        if (rasterAccessorArray2[n19] != null) {
                            nArray10[n19] = nArray9[n19];
                            int n24 = n19;
                            nArray9[n24] = nArray9[n24] + nArray4[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n11;
                    n17 = n4;
                    while (n17 < n8) {
                        boolean bl2 = false;
                        int n25 = 0;
                        while (n25 < n2) {
                            if (rasterAccessorArray[n25] != null) {
                                float f2 = fArrayArray3[n25][nArray8[n25]];
                                int n26 = n25;
                                nArray8[n26] = nArray8[n26] + nArray2[n25];
                                switch (nArray6[n25]) {
                                    case 1: {
                                        bl2 = fArrayArray4[n25][nArray10[n25]] != 0.0f;
                                        int n27 = n25;
                                        nArray10[n27] = nArray10[n27] + nArray5[n25];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n25].getSample(n17, n20, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)f2 >= this.sourceThreshold[n25][n16];
                                    }
                                }
                                if (bl2) {
                                    fArray2[n18] = f2;
                                    int n28 = n25 + 1;
                                    while (n28 < n2) {
                                        if (rasterAccessorArray[n28] != null) {
                                            int n29 = n28;
                                            nArray8[n29] = nArray8[n29] + nArray2[n28];
                                        }
                                        if (rasterAccessorArray2[n28] != null) {
                                            int n30 = n28;
                                            nArray10[n30] = nArray10[n30] + nArray5[n28];
                                        }
                                        ++n28;
                                    }
                                    break;
                                }
                            }
                            ++n25;
                        }
                        if (!bl2) {
                            fArray2[n18] = (float)this.backgroundValues[n16];
                        }
                        n18 += n12;
                        ++n17;
                    }
                    ++n20;
                }
            } else {
                n20 = n5;
                while (n20 < n9) {
                    n19 = 0;
                    while (n19 < n2) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray8[n19] = nArray7[n19];
                            int n31 = n19;
                            nArray7[n31] = nArray7[n31] + nArray[n19];
                        }
                        if (nArray6[n19] == 1) {
                            nArray10[n19] = nArray9[n19];
                            int n32 = n19;
                            nArray9[n32] = nArray9[n32] + nArray4[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n11;
                    n17 = n4;
                    while (n17 < n8) {
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        int n33 = 0;
                        while (n33 < n2) {
                            if (rasterAccessorArray[n33] != null) {
                                float f5 = fArrayArray3[n33][nArray8[n33]];
                                int n34 = n33;
                                nArray8[n34] = nArray8[n34] + nArray2[n33];
                                float f6 = 0.0f;
                                switch (nArray6[n33]) {
                                    case 1: {
                                        f6 = fArrayArray4[n33][nArray10[n33]];
                                        if (f6 > 0.0f && this.isAlphaBitmask) {
                                            f6 = 1.0f;
                                        }
                                        int n35 = n33;
                                        nArray10[n35] = nArray10[n35] + nArray5[n33];
                                        break;
                                    }
                                    case 2: {
                                        f6 = rasterArray[n33].getSample(n17, n20, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f6 = (double)f5 >= this.sourceThreshold[n33][n16] ? 1.0f : 0.0f;
                                    }
                                }
                                f3 += f6 * f5;
                                f4 += f6;
                            }
                            ++n33;
                        }
                        fArray2[n18] = (double)f4 == 0.0 ? (float)this.backgroundValues[n16] : f3 / f4;
                        n18 += n12;
                        ++n17;
                    }
                    ++n20;
                }
            }
            ++n16;
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        double[][][] dArrayArray = new double[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            if (rasterAccessorArray[n3] != null) {
                nArray[n3] = rasterAccessorArray[n3].getScanlineStride();
                nArray2[n3] = rasterAccessorArray[n3].getPixelStride();
                nArrayArray[n3] = rasterAccessorArray[n3].getBandOffsets();
                dArrayArray[n3] = rasterAccessorArray[n3].getDoubleDataArrays();
            }
            ++n3;
        }
        int n4 = rasterAccessor.getX();
        int n5 = rasterAccessor.getY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = n4 + n6;
        int n9 = n5 + n7;
        int n10 = rasterAccessor.getNumBands();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        int n13 = 0;
        while (n13 < n2) {
            if (rasterAccessorArray2[n13] != null) {
                bl = true;
                break;
            }
            ++n13;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        double[][][] dArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            nArrayArray2 = new int[n2][];
            dArrayArray2 = new double[n2][][];
            int n14 = 0;
            while (n14 < n2) {
                if (rasterAccessorArray2[n14] != null) {
                    nArray4[n14] = rasterAccessorArray2[n14].getScanlineStride();
                    nArray5[n14] = rasterAccessorArray2[n14].getPixelStride();
                    nArrayArray2[n14] = rasterAccessorArray2[n14].getBandOffsets();
                    dArrayArray2[n14] = rasterAccessorArray2[n14].getDoubleDataArrays();
                }
                ++n14;
            }
        }
        int[] nArray6 = new int[n2];
        int n15 = 0;
        while (n15 < n2) {
            nArray6[n15] = 3;
            if (rasterAccessorArray2[n15] != null) {
                nArray6[n15] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n15] != null) {
                nArray6[n15] = 2;
            }
            ++n15;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        double[][] dArrayArray3 = new double[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        double[][] dArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            dArrayArray4 = new double[n2][];
        }
        int n16 = 0;
        while (n16 < n10) {
            int n17;
            double d2;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22 = 0;
            while (n22 < n2) {
                if (rasterAccessorArray[n22] != null) {
                    dArrayArray3[n22] = dArrayArray[n22][n16];
                    nArray7[n22] = nArrayArray[n22][n16];
                }
                if (nArray6[n22] == 1) {
                    dArrayArray4[n22] = dArrayArray2[n22][0];
                    nArray9[n22] = nArrayArray2[n22][0];
                }
                ++n22;
            }
            double[] dArray2 = dArray[n16];
            int n23 = nArray3[n16];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n21 = n5;
                while (n21 < n9) {
                    n20 = 0;
                    while (n20 < n2) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n24 = n20;
                            nArray7[n24] = nArray7[n24] + nArray[n20];
                        }
                        if (rasterAccessorArray2[n20] != null) {
                            nArray10[n20] = nArray9[n20];
                            int n25 = n20;
                            nArray9[n25] = nArray9[n25] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n11;
                    n18 = n4;
                    while (n18 < n8) {
                        boolean bl2 = false;
                        int n26 = 0;
                        while (n26 < n2) {
                            if (rasterAccessorArray[n26] != null) {
                                d2 = dArrayArray3[n26][nArray8[n26]];
                                int n27 = n26;
                                nArray8[n27] = nArray8[n27] + nArray2[n26];
                                switch (nArray6[n26]) {
                                    case 1: {
                                        bl2 = dArrayArray4[n26][nArray10[n26]] != 0.0;
                                        int n28 = n26;
                                        nArray10[n28] = nArray10[n28] + nArray5[n26];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n26].getSample(n18, n21, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = d2 >= this.sourceThreshold[n26][n16];
                                    }
                                }
                                if (bl2) {
                                    dArray2[n19] = d2;
                                    n17 = n26 + 1;
                                    while (n17 < n2) {
                                        if (rasterAccessorArray[n17] != null) {
                                            int n29 = n17;
                                            nArray8[n29] = nArray8[n29] + nArray2[n17];
                                        }
                                        if (rasterAccessorArray2[n17] != null) {
                                            int n30 = n17;
                                            nArray10[n30] = nArray10[n30] + nArray5[n17];
                                        }
                                        ++n17;
                                    }
                                    break;
                                }
                            }
                            ++n26;
                        }
                        if (!bl2) {
                            dArray2[n19] = this.backgroundValues[n16];
                        }
                        n19 += n12;
                        ++n18;
                    }
                    ++n21;
                }
            } else {
                n21 = n5;
                while (n21 < n9) {
                    n20 = 0;
                    while (n20 < n2) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n31 = n20;
                            nArray7[n31] = nArray7[n31] + nArray[n20];
                        }
                        if (nArray6[n20] == 1) {
                            nArray10[n20] = nArray9[n20];
                            int n32 = n20;
                            nArray9[n32] = nArray9[n32] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n11;
                    n18 = n4;
                    while (n18 < n8) {
                        double d3 = 0.0;
                        d2 = 0.0;
                        n17 = 0;
                        while (n17 < n2) {
                            if (rasterAccessorArray[n17] != null) {
                                double d4 = dArrayArray3[n17][nArray8[n17]];
                                int n33 = n17;
                                nArray8[n33] = nArray8[n33] + nArray2[n17];
                                double d5 = 0.0;
                                switch (nArray6[n17]) {
                                    case 1: {
                                        d5 = dArrayArray4[n17][nArray10[n17]];
                                        if (d5 > 0.0 && this.isAlphaBitmask) {
                                            d5 = 1.0;
                                        }
                                        int n34 = n17;
                                        nArray10[n34] = nArray10[n34] + nArray5[n17];
                                        break;
                                    }
                                    case 2: {
                                        d5 = rasterArray[n17].getSample(n18, n21, 0) > 0 ? 1.0 : 0.0;
                                        break;
                                    }
                                    default: {
                                        d5 = d4 >= this.sourceThreshold[n17][n16] ? 1.0 : 0.0;
                                    }
                                }
                                d3 += d5 * d4;
                                d2 += d5;
                            }
                            ++n17;
                        }
                        dArray2[n19] = d2 == 0.0 ? this.backgroundValues[n16] : d3 / d2;
                        n19 += n12;
                        ++n18;
                    }
                    ++n21;
                }
            }
            ++n16;
        }
    }
}

