/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.MedianFilterPlusOpImage;
import com.sun.media.jai.opimage.MedianFilterSeparableOpImage;
import com.sun.media.jai.opimage.MedianFilterSquareOpImage;
import com.sun.media.jai.opimage.MedianFilterXOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MedianFilterDescriptor;
import javax.media.jai.operator.MedianFilterShape;

public class MedianFilterRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        MedianFilterShape medianFilterShape = (MedianFilterShape)parameterBlock.getObjectParameter(0);
        int n2 = parameterBlock.getIntParameter(1);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE)) {
            return new MedianFilterSquareOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n2);
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_PLUS)) {
            return new MedianFilterPlusOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n2);
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_X)) {
            return new MedianFilterXOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n2);
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE_SEPARABLE)) {
            return new MedianFilterSeparableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n2);
        }
        return null;
    }
}

