/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MedianFilterShape;

abstract class MedianFilterOpImage
extends AreaOpImage {
    protected MedianFilterShape maskType;
    protected int maskSize;

    public MedianFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MedianFilterShape medianFilterShape, int n2) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n2 - 1) / 2, (n2 - 1) / 2, n2 / 2, n2 / 2);
        this.maskType = medianFilterShape;
        this.maskSize = n2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, this.maskSize);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected int medianFilter(int[] nArray) {
        if (nArray.length == 3) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (n2 < n3) {
                if (n3 < n4) {
                    return n3;
                }
                if (n4 > n2) {
                    return n4;
                }
                return n2;
            }
            if (n2 < n4) {
                return n2;
            }
            if (n3 < n4) {
                return n4;
            }
            return n3;
        }
        int n5 = 0;
        int n6 = nArray.length - 1;
        int n7 = nArray.length / 2;
        while (true) {
            int n8 = n5;
            int n9 = n6;
            int n10 = nArray[(n5 + n6) / 2];
            while (true) {
                if (nArray[n5] < n10) {
                    ++n5;
                    continue;
                }
                while (n10 < nArray[n6]) {
                    --n6;
                }
                if (n5 <= n6) {
                    int n11 = nArray[n5];
                    nArray[n5] = nArray[n6];
                    nArray[n6] = n11;
                    ++n5;
                    --n6;
                }
                if (n5 > n6) break;
            }
            if (n8 < n6 && n6 >= n7) {
                n5 = n8;
                continue;
            }
            if (n5 >= n9 || n5 > n7) break;
            n6 = n9;
        }
        return nArray[n7];
    }

    protected float medianFilterFloat(float[] fArray) {
        if (fArray.length == 3) {
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            if (f2 < f3) {
                if (f3 < f4) {
                    return f3;
                }
                if (f4 > f2) {
                    return f4;
                }
                return f2;
            }
            if (f2 < f4) {
                return f2;
            }
            if (f3 < f4) {
                return f4;
            }
            return f3;
        }
        int n2 = 0;
        int n3 = fArray.length - 1;
        int n4 = fArray.length / 2;
        while (true) {
            int n5 = n2;
            int n6 = n3;
            float f5 = fArray[(n2 + n3) / 2];
            while (true) {
                if (fArray[n2] < f5) {
                    ++n2;
                    continue;
                }
                while (f5 < fArray[n3]) {
                    --n3;
                }
                if (n2 <= n3) {
                    float f6 = fArray[n2];
                    fArray[n2] = fArray[n3];
                    fArray[n3] = f6;
                    ++n2;
                    --n3;
                }
                if (n2 > n3) break;
            }
            if (n5 < n3 && n3 >= n4) {
                n2 = n5;
                continue;
            }
            if (n2 >= n6 || n2 > n4) break;
            n3 = n6;
        }
        return fArray[n4];
    }

    protected double medianFilterDouble(double[] dArray) {
        if (dArray.length == 3) {
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray[2];
            if (d2 < d3) {
                if (d3 < d4) {
                    return d3;
                }
                if (d4 > d2) {
                    return d4;
                }
                return d2;
            }
            if (d2 < d4) {
                return d2;
            }
            if (d3 < d4) {
                return d4;
            }
            return d3;
        }
        int n2 = 0;
        int n3 = dArray.length - 1;
        int n4 = dArray.length / 2;
        while (true) {
            int n5 = n2;
            int n6 = n3;
            double d5 = dArray[(n2 + n3) / 2];
            while (true) {
                if (dArray[n2] < d5) {
                    ++n2;
                    continue;
                }
                while (d5 < dArray[n3]) {
                    --n3;
                }
                if (n2 <= n3) {
                    double d6 = dArray[n2];
                    dArray[n2] = dArray[n3];
                    dArray[n3] = d6;
                    ++n2;
                    --n3;
                }
                if (n2 > n3) break;
            }
            if (n5 < n3 && n3 >= n4) {
                n2 = n5;
                continue;
            }
            if (n2 >= n6 || n2 > n4) break;
            n3 = n6;
        }
        return dArray[n4];
    }
}

