/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import com.sun.media.jai.opimage.Cube;
import com.sun.media.jai.opimage.HistogramHash;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;

public class MedianCutOpImage
extends ColorQuantizerOpImage {
    private int histogramSize;
    private int[] counts;
    private int[] colors;
    private Cube[] partition;
    private int bits = 8;
    private int mask;
    HistogramHash histogram;

    public MedianCutOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, int n3, ROI rOI, int n4, int n5) {
        super(renderedImage, map, imageLayout, n2, rOI, n4, n5);
        this.colorMap = null;
        this.histogramSize = n3;
    }

    protected synchronized void train() {
        int n2;
        PlanarImage planarImage = this.getSourceImage(0);
        if (this.roi == null) {
            this.roi = new ROIShape(planarImage.getBounds());
        }
        int n3 = planarImage.getMinTileX();
        int n4 = planarImage.getMaxTileX();
        int n5 = planarImage.getMinTileY();
        int n6 = planarImage.getMaxTileY();
        int n7 = planarImage.getMinX();
        int n8 = planarImage.getMinY();
        this.histogram = new HistogramHash(this.histogramSize);
        block0: do {
            this.histogram.init();
            n2 = this.bits;
            this.mask = 255 << 8 - this.bits & 0xFF;
            this.mask = this.mask | this.mask << 8 | this.mask << 16;
            int n9 = n5;
            while (n9 <= n6) {
                int n10 = n3;
                while (n10 <= n4) {
                    block7: {
                        Rectangle rectangle;
                        block8: {
                            rectangle = planarImage.getTileRect(n10, n9);
                            if (!this.roi.intersects(rectangle)) break block7;
                            if (!this.checkForSkippedTiles || rectangle.x < n7 || rectangle.y < n8) break block8;
                            int n11 = (this.xPeriod - (rectangle.x - n7) % this.xPeriod) % this.xPeriod;
                            int n12 = (this.yPeriod - (rectangle.y - n8) % this.yPeriod) % this.yPeriod;
                            if (n11 >= rectangle.width || n12 >= rectangle.height) break block7;
                        }
                        this.computeHistogram(planarImage.getData(rectangle));
                        if (this.histogram.isFull()) break;
                    }
                    ++n10;
                }
                if (this.histogram.isFull()) continue block0;
                ++n9;
            }
        } while (n2 != this.bits);
        this.counts = this.histogram.getCounts();
        this.colors = this.histogram.getColors();
        this.medianCut(this.maxColorNum);
        this.setProperty("LUT", this.colorMap);
    }

    private void computeHistogram(Raster raster) {
        LinkedList linkedList;
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.isInitialized = true;
        }
        Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n4 = rectangle2.x;
            int n5 = rectangle2.y;
            rectangle2.x = ColorQuantizerOpImage.startPosition(n4, n2, this.xPeriod);
            rectangle2.y = ColorQuantizerOpImage.startPosition(n5, n3, this.yPeriod);
            rectangle2.width = n4 + rectangle2.width - rectangle2.x;
            rectangle2.height = n5 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, rectangle2, this.srcSampleType, false);
            switch (unpackedImageData.type) {
                case 0: {
                    this.computeHistogramByte(unpackedImageData);
                }
            }
        }
    }

    private void computeHistogramByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = rectangle.height * n2;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = n7 + rectangle.width * n3;
            int n9 = n7;
            while (n9 < n8) {
                int n10 = (byArray2[n9 + unpackedImageData.bandOffsets[0]] & 0xFF) << 16 | (byArray3[n9 + unpackedImageData.bandOffsets[1]] & 0xFF) << 8 | byArray4[n9 + unpackedImageData.bandOffsets[2]] & 0xFF;
                if (!this.histogram.insert(n10 & this.mask)) {
                    --this.bits;
                    return;
                }
                n9 += n5;
            }
            n7 += n4;
        }
    }

    public void medianCut(int n2) {
        this.partition = new Cube[n2];
        int n3 = 0;
        Cube cube = new Cube();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.histogramSize) {
            if (this.counts[n5] != 0) {
                ++n4;
                cube.count += this.counts[n5];
            }
            ++n5;
        }
        cube.lower = 0;
        cube.upper = n4 - 1;
        cube.level = 0;
        this.shrinkCube(cube);
        this.partition[n3++] = cube;
        while (n3 < n2) {
            int n6 = 255;
            int n7 = -1;
            int n8 = 0;
            while (n8 < n3) {
                if (this.partition[n8].lower != this.partition[n8].upper && this.partition[n8].level < n6) {
                    n6 = this.partition[n8].level;
                    n7 = n8;
                }
                ++n8;
            }
            if (n7 == -1) break;
            cube = this.partition[n7];
            n6 = cube.level;
            int n9 = 77 * (cube.rmax - cube.rmin);
            int n10 = 150 * (cube.gmax - cube.gmin);
            int n11 = 29 * (cube.bmax - cube.bmin);
            int n12 = 0;
            if (n9 >= n10 && n9 >= n11) {
                n12 = 0xFF0000;
            }
            if (n10 >= n9 && n10 >= n11) {
                n12 = 65280;
            }
            if (n11 >= n9 && n11 >= n10) {
                n12 = 255;
            }
            this.quickSort(this.colors, cube.lower, cube.upper, n12);
            int n13 = 0;
            int n14 = cube.lower;
            while (n14 <= cube.upper - 1) {
                if (n13 >= cube.count / 2) break;
                n13 += this.counts[n14];
                ++n14;
            }
            Cube cube2 = new Cube();
            cube2.lower = cube.lower;
            cube2.upper = n14 - 1;
            cube2.count = n13;
            cube2.level = cube.level + 1;
            this.shrinkCube(cube2);
            this.partition[n7] = cube2;
            Cube cube3 = new Cube();
            cube3.lower = n14;
            cube3.upper = cube.upper;
            cube3.count = cube.count - n13;
            cube3.level = cube.level + 1;
            this.shrinkCube(cube3);
            this.partition[n3++] = cube3;
        }
        this.createLUT(n3);
    }

    private void shrinkCube(Cube cube) {
        int n2 = 255;
        int n3 = 0;
        int n4 = 255;
        int n5 = 0;
        int n6 = 255;
        int n7 = 0;
        int n8 = cube.lower;
        while (n8 <= cube.upper) {
            int n9 = this.colors[n8];
            int n10 = n9 >> 16;
            int n11 = n9 >> 8 & 0xFF;
            int n12 = n9 & 0xFF;
            if (n10 > n3) {
                n3 = n10;
            } else if (n10 < n2) {
                n2 = n10;
            }
            if (n11 > n5) {
                n5 = n11;
            } else if (n11 < n4) {
                n4 = n11;
            }
            if (n12 > n7) {
                n7 = n12;
            } else if (n12 < n6) {
                n6 = n12;
            }
            ++n8;
        }
        cube.rmin = n2;
        cube.rmax = n3;
        cube.gmin = n4;
        cube.gmax = n5;
        cube.bmin = n6;
        cube.bmax = n7;
    }

    private void createLUT(int n2) {
        if (this.colorMap == null) {
            this.colorMap = new LookupTableJAI(new byte[3][n2]);
        }
        byte[] byArray = this.colorMap.getByteData(0);
        byte[] byArray2 = this.colorMap.getByteData(1);
        byte[] byArray3 = this.colorMap.getByteData(2);
        float f2 = 255.0f / (float)(this.mask & 0xFF);
        int n3 = 0;
        while (n3 < n2) {
            Cube cube = this.partition[n3];
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n4 = cube.lower;
            while (n4 <= cube.upper) {
                int n5 = this.colors[n4];
                int n6 = n5 >> 16;
                f3 += (float)n6 * (float)this.counts[n4];
                int n7 = n5 >> 8 & 0xFF;
                f4 += (float)n7 * (float)this.counts[n4];
                int n8 = n5 & 0xFF;
                f5 += (float)n8 * (float)this.counts[n4];
                ++n4;
            }
            byArray[n3] = (byte)(f3 / (float)cube.count * f2);
            byArray2[n3] = (byte)(f4 / (float)cube.count * f2);
            byArray3[n3] = (byte)(f5 / (float)cube.count * f2);
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(int[] var1_1, int var2_2, int var3_3, int var4_4) {
        block5: {
            var5_5 = var2_2;
            var6_6 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var7_7 = var1_1[(var2_2 + var3_3) / 2] & var4_4;
            ** GOTO lbl21
            {
                ++var5_5;
                do {
                    if (var5_5 < var3_3 && (var1_1[var5_5] & var4_4) < var7_7) continue block0;
                    while (var6_6 > var2_2 && (var1_1[var6_6] & var4_4) > var7_7) {
                        --var6_6;
                    }
                    if (var5_5 > var6_6) continue;
                    var8_8 = var1_1[var5_5];
                    var1_1[var5_5] = var1_1[var6_6];
                    var1_1[var6_6] = var8_8;
                    var8_8 = this.counts[var5_5];
                    this.counts[var5_5] = this.counts[var6_6];
                    this.counts[var6_6] = var8_8;
                    ++var5_5;
                    --var6_6;
lbl21:
                    // 3 sources

                } while (var5_5 <= var6_6);
            }
            if (var2_2 < var6_6) {
                this.quickSort(var1_1, var2_2, var6_6, var4_4);
            }
            if (var5_5 < var3_3) {
                this.quickSort(var1_1, var5_5, var3_3, var4_4);
            }
        }
    }
}

