/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class MeanOpImage
extends StatisticsOpImage {
    private boolean isInitialized = false;
    private double[] totalPixelValue;
    private int totalPixelCount;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n2, int n3) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n2), this.tileYToY(n3), this.tileWidth, this.tileHeight);
    }

    public MeanOpImage(RenderedImage renderedImage, ROI rOI, int n2, int n3, int n4, int n5) {
        super(renderedImage, rOI, n2, n3, n4, n5);
    }

    protected String[] getStatisticsNames() {
        return new String[]{"mean"};
    }

    protected Object createStatistics(String string) {
        Object object = string.equalsIgnoreCase("mean") ? (Object)new double[this.sampleModel.getNumBands()] : Image.UndefinedProperty;
        return object;
    }

    private final int startPosition(int n2, int n3, int n4) {
        int n5 = (n2 - n3) % n4;
        if (n5 == 0) {
            return n2;
        }
        return n2 + (n4 - n5);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        int n2;
        Object object2;
        LinkedList linkedList;
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.totalPixelValue = new double[this.srcPA.numBands];
            this.totalPixelCount = 0;
            this.isInitialized = true;
        }
        Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            object2 = rectangle.intersection((Rectangle)listIterator.next());
            n2 = ((Rectangle)object2).x;
            int n3 = ((Rectangle)object2).y;
            ((Rectangle)object2).x = this.startPosition(n2, this.xStart, this.xPeriod);
            ((Rectangle)object2).y = this.startPosition(n3, this.yStart, this.yPeriod);
            ((Rectangle)object2).width = n2 + ((Rectangle)object2).width - ((Rectangle)object2).x;
            ((Rectangle)object2).height = n3 + ((Rectangle)object2).height - ((Rectangle)object2).y;
            if (((Rectangle)object2).isEmpty()) continue;
            UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)object2, this.srcSampleType, false);
            switch (unpackedImageData.type) {
                case 0: {
                    this.accumulateStatisticsByte(unpackedImageData);
                    break;
                }
                case 1: {
                    this.accumulateStatisticsUShort(unpackedImageData);
                    break;
                }
                case 2: {
                    this.accumulateStatisticsShort(unpackedImageData);
                    break;
                }
                case 3: {
                    this.accumulateStatisticsInt(unpackedImageData);
                    break;
                }
                case 4: {
                    this.accumulateStatisticsFloat(unpackedImageData);
                    break;
                }
                case 5: {
                    this.accumulateStatisticsDouble(unpackedImageData);
                }
            }
        }
        if (string.equalsIgnoreCase("mean")) {
            object2 = (double[])object;
            if (this.totalPixelCount != 0) {
                n2 = 0;
                while (n2 < this.srcPA.numBands) {
                    object2[n2] = this.totalPixelValue[n2] / (double)this.totalPixelCount;
                    ++n2;
                }
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            byte[] byArray2 = byArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + (double)(byArray2[n10] & 0xFF);
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            short[] sArray2 = sArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + (double)(sArray2[n10] & 0xFFFF);
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            short[] sArray2 = sArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + (double)sArray2[n10];
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            int[] nArray2 = nArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + (double)nArray2[n10];
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            float[] fArray2 = fArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + (double)fArray2[n10];
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        int n6 = 0;
        while (n6 < this.srcPA.numBands) {
            double[] dArray2 = dArray[n6];
            int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
            int n8 = unpackedImageData.bandOffsets[n6];
            while (n8 < n7) {
                int n9 = n8 + rectangle.width * n3;
                int n10 = n8;
                while (n10 < n9) {
                    int n11 = n6;
                    this.totalPixelValue[n11] = this.totalPixelValue[n11] + dArray2[n10];
                    n10 += n5;
                }
                n8 += n4;
            }
            ++n6;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }
}

