/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;

final class LookupOpImage
extends ColormapOpImage {
    protected LookupTableJAI table;

    public LookupOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, imageLayout, map, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            int n4 = this.table.getNumBands() < 3 ? 0 : n2;
            int n5 = 0;
            while (n5 < n3) {
                int n6 = this.table.lookup(n4, byArray2[n5] & 0xFF);
                byArray2[n5] = ImageUtil.clampByte(n6);
                ++n5;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.table.lookup(rasterArray[0], writableRaster, rectangle);
    }
}

