/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class IIPResolutionOpImage
extends OpImage {
    private static final int TILE_SIZE = 64;
    private static final int TILE_BLOCK_WIDTH = 8;
    private static final int TILE_BLOCK_HEIGHT = 2;
    private static final char BLANK = ' ';
    private static final char COLON = ':';
    private static final char SLASH = '/';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int CS_COLORLESS = 0;
    private static final int CS_MONOCHROME = 1;
    private static final int CS_PHOTOYCC = 2;
    private static final int CS_NIFRGB = 3;
    private static final int CS_PLANE_ALPHA = 32766;
    private static final int TILE_UNCOMPRESSED = 0;
    private static final int TILE_SINGLE_COLOR = 1;
    private static final int TILE_JPEG = 2;
    private static final int TILE_INVALID = -1;
    private static ImagingListener listener = JAI.getDefaultInstance().getImagingListener();
    private String URLString;
    private int resolution;
    private int subImage;
    private int colorSpaceType;
    private boolean hasAlpha;
    private boolean isAlphaPremultilpied;
    private int minTileX;
    private int minTileY;
    private int numXTiles;
    private JPEGDecodeParam[] decodeParamCache = new JPEGDecodeParam[255];
    private boolean arePropertiesInitialized = false;
    private int tileBlockWidth = 8;
    private int tileBlockHeight = 2;
    private RenderingHints renderHints;
    static /* synthetic */ Class class$com$sun$media$jai$opimage$IIPResolutionOpImage;

    /*
     * Unable to fully structure code
     */
    private static final void YCbCrToNIFRGB(Raster var0) {
        block2: {
            var1_1 = ((DataBufferByte)var0.getDataBuffer()).getData();
            var2_2 = 0;
            var3_3 = var1_1.length;
            var4_4 = 255;
            var5_5 = 65280;
            if (var0.getSampleModel().getNumBands() != 3) ** GOTO lbl35
            while (var2_2 < var3_3) {
                var6_6 = var1_1[var2_2] & 255;
                var7_8 = var1_1[var2_2 + 1] & 255;
                var8_10 = var1_1[var2_2 + 2] & 255;
                var9_12 = (int)(var6_6 + 1.402f * var8_10 - 178.255f);
                var10_14 = (int)(var6_6 - 0.34414f * var7_8 - 0.71414f * var8_10 + 135.4307f);
                var11_16 = (int)(var6_6 + 1.772f * var7_8 - 225.43f);
                var12_18 = var9_12 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var9_12 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
                var12_18 = var10_14 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var10_14 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
                var12_18 = var11_16 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var11_16 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var6_7 = var1_1[var2_2] & 255;
                var7_9 = var1_1[var2_2 + 1] & 255;
                var8_11 = var1_1[var2_2 + 2] & 255;
                var9_13 = (int)(-var6_7 - 1.402f * var8_11 - 433.255f);
                var10_15 = (int)(-var6_7 + 0.34414f * var7_9 + 0.71414f * var8_11 + 119.5693f);
                var11_17 = (int)(-var6_7 - 1.772f * var7_9 - 480.43f);
                var12_19 = var9_13 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var9_13 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                var12_19 = var10_15 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var10_15 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                var12_19 = var11_17 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var11_17 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                ++var2_2;
lbl35:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
    }

    private static InputStream postCommands(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string + "&OBJ=iip,1.0");
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append("&" + stringArray[n2]);
                ++n2;
            }
        }
        InputStream inputStream = null;
        try {
            URL uRL = new URL(stringBuffer.toString());
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            String string2 = JaiI18N.getString("IIPResolution4") + stringBuffer.toString();
            listener.errorOccurred(string2, new ImagingException(string2, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
        }
        return inputStream;
    }

    private static String getLabel(InputStream inputStream) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(16);
        try {
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                char c2 = (char)(0xFF & n2);
                if (c2 != '/' && c2 != ':') {
                    stringBuffer.append(c2);
                    bl = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("IIPResolution5");
            listener.errorOccurred(string, new ImagingException(string, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
        }
        return bl ? stringBuffer.toString().toLowerCase() : null;
    }

    private static int getLength(InputStream inputStream) {
        return Integer.valueOf(IIPResolutionOpImage.getLabel(inputStream));
    }

    private static InputStream checkError(String string, InputStream inputStream, boolean bl) {
        if (string.equals("error")) {
            int n2 = Integer.valueOf(IIPResolutionOpImage.getLabel(inputStream));
            byte[] byArray = new byte[n2];
            try {
                inputStream.read(byArray);
            }
            catch (Exception exception) {
                String string2 = JaiI18N.getString("IIPResolution6");
                listener.errorOccurred(string2, new ImagingException(string2, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
            }
            String string3 = new String(byArray);
            if (bl) {
                IIPResolutionOpImage.throwIIPException(string3);
            } else {
                IIPResolutionOpImage.printIIPException(string3);
            }
        } else if (string.startsWith("iip")) {
            String string4 = IIPResolutionOpImage.getDataAsString(inputStream, false);
        }
        return inputStream;
    }

    private static byte[] getDataAsByteArray(InputStream inputStream) {
        int n2 = IIPResolutionOpImage.getLength(inputStream);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray);
            inputStream.read();
            inputStream.read();
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("IIPResolution7");
            listener.errorOccurred(string, new ImagingException(string, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
        }
        return byArray;
    }

    private static String getDataAsString(InputStream inputStream, boolean bl) {
        String string = null;
        if (bl) {
            try {
                int n2 = IIPResolutionOpImage.getLength(inputStream);
                byte[] byArray = new byte[n2];
                inputStream.read(byArray);
                inputStream.read();
                inputStream.read();
                string = new String(byArray);
            }
            catch (Exception exception) {
                String string2 = JaiI18N.getString("IIPResolution7");
                listener.errorOccurred(string2, new ImagingException(string2, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(16);
            try {
                int n3;
                while ((n3 = inputStream.read()) != -1) {
                    char c2 = (char)(0xFF & n3);
                    if (c2 == '\r') {
                        inputStream.read();
                        break;
                    }
                    stringBuffer.append(c2);
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                String string3 = JaiI18N.getString("IIPResolution7");
                listener.errorOccurred(string3, new ImagingException(string3, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
            }
        }
        return string;
    }

    private static void flushData(InputStream inputStream, boolean bl) {
        if (bl) {
            try {
                int n2 = IIPResolutionOpImage.getLength(inputStream);
                long l2 = inputStream.skip(n2);
                if (l2 == (long)n2) {
                    inputStream.read();
                    inputStream.read();
                }
            }
            catch (Exception exception) {
                String string = JaiI18N.getString("IIPResolution8");
                listener.errorOccurred(string, new ImagingException(string, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
            }
        } else {
            try {
                int n3;
                while ((n3 = inputStream.read()) != -1) {
                    if ((char)(0xFF & n3) != '\r') continue;
                    inputStream.read();
                    break;
                }
            }
            catch (Exception exception) {
                String string = JaiI18N.getString("IIPResolution8");
                listener.errorOccurred(string, new ImagingException(string, exception), class$com$sun$media$jai$opimage$IIPResolutionOpImage == null ? (class$com$sun$media$jai$opimage$IIPResolutionOpImage = IIPResolutionOpImage.class$("com.sun.media.jai.opimage.IIPResolutionOpImage")) : class$com$sun$media$jai$opimage$IIPResolutionOpImage, false);
            }
        }
    }

    private static int[] stringToIntArray(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        int n3 = string.indexOf(32, 0);
        do {
            vector.add(Integer.valueOf(string.substring(n2, n3)));
        } while ((n3 = string.indexOf(32, n2 = n3 + 1)) != -1);
        vector.add(Integer.valueOf(string.substring(n2)));
        int n4 = vector.size();
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = (Integer)vector.get(n5);
            ++n5;
        }
        return nArray;
    }

    private static float[] stringToFloatArray(String string) {
        Vector<Float> vector = new Vector<Float>();
        int n2 = 0;
        int n3 = string.indexOf(32, 0);
        do {
            vector.add(Float.valueOf(string.substring(n2, n3)));
        } while ((n3 = string.indexOf(32, n2 = n3 + 1)) != -1);
        vector.add(Float.valueOf(string.substring(n2)));
        int n4 = vector.size();
        float[] fArray = new float[n4];
        int n5 = 0;
        while (n5 < n4) {
            fArray[n5] = ((Float)vector.get(n5)).floatValue();
            ++n5;
        }
        return fArray;
    }

    private static String formatIIPErrorMessage(String string) {
        return new String(JaiI18N.getString("IIPResolutionOpImage0") + " " + string);
    }

    private static void throwIIPException(String string) {
        throw new RuntimeException(IIPResolutionOpImage.formatIIPErrorMessage(string));
    }

    private static void printIIPException(String string) {
        System.err.println(IIPResolutionOpImage.formatIIPErrorMessage(string));
    }

    private static void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ImageLayout layoutHelper(String string, int n2, int n3) {
        int n4;
        Object object;
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileGridXOffset(0);
        imageLayout.setTileGridYOffset(0);
        imageLayout.setTileWidth(64);
        imageLayout.setTileHeight(64);
        imageLayout.setMinX(0);
        imageLayout.setMinY(0);
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        String[] stringArray = new String[]{"OBJ=Max-size", "OBJ=Resolution-number"};
        InputStream inputStream = IIPResolutionOpImage.postCommands(string, stringArray);
        String string2 = null;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            String string3;
            if (string2.equals("max-size")) {
                string3 = IIPResolutionOpImage.getDataAsString(inputStream, false);
                int[] nArray = IIPResolutionOpImage.stringToIntArray(string3);
                n5 = nArray[0];
                n6 = nArray[1];
                continue;
            }
            if (string2.equals("resolution-number")) {
                string3 = IIPResolutionOpImage.getDataAsString(inputStream, false);
                n7 = Integer.valueOf(string3);
                if (n2 < 0) {
                    n8 = 0;
                    continue;
                }
                if (n2 >= n7) {
                    n8 = n7 - 1;
                    continue;
                }
                n8 = n2;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        IIPResolutionOpImage.closeStream(inputStream);
        int n9 = n5;
        int n10 = n6;
        int n11 = n7 - 1;
        while (n11 > n8) {
            n9 = (n9 + 1) / 2;
            n10 = (n10 + 1) / 2;
            --n11;
        }
        imageLayout.setWidth(n9);
        imageLayout.setHeight(n10);
        boolean bl = false;
        boolean bl2 = false;
        stringArray = new String[]{"OBJ=Colorspace," + n8 + "," + n3};
        inputStream = IIPResolutionOpImage.postCommands(string, stringArray);
        int n12 = 0;
        int n13 = 0;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.startsWith("colorspace")) {
                object = IIPResolutionOpImage.stringToIntArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                n13 = (int)object[3];
                switch (object[2]) {
                    case 1: {
                        n12 = 1003;
                        break;
                    }
                    case 2: {
                        n12 = 1002;
                        break;
                    }
                    case 3: {
                        n12 = 1000;
                        break;
                    }
                    default: {
                        n12 = n13 < 3 ? 1003 : 1000;
                    }
                }
                n4 = 1;
                while (n4 <= n13) {
                    if (object[3 + n4] == 32766) {
                        bl = true;
                    }
                    ++n4;
                }
                bl2 = object[1] == true;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        IIPResolutionOpImage.closeStream(inputStream);
        object = ColorSpace.getInstance(n12);
        n4 = DataBuffer.getDataTypeSize(0);
        int[] nArray = new int[n13];
        int n14 = 0;
        while (n14 < n13) {
            nArray[n14] = n4;
            ++n14;
        }
        int n15 = bl ? 3 : 1;
        ComponentColorModel componentColorModel = new ComponentColorModel((ColorSpace)object, nArray, bl, bl2, n15, 0);
        imageLayout.setColorModel(componentColorModel);
        int[] nArray2 = new int[n13];
        int n16 = 0;
        while (n16 < n13) {
            nArray2[n16] = n16;
            ++n16;
        }
        imageLayout.setSampleModel(RasterFactory.createPixelInterleavedSampleModel(0, 64, 64, n13, n13 * 64, nArray2));
        return imageLayout;
    }

    public IIPResolutionOpImage(Map map, String string, int n2, int n3) {
        super(null, IIPResolutionOpImage.layoutHelper(string, n2, n3), map, false);
        Object object;
        this.renderHints = (RenderingHints)map;
        this.URLString = string;
        this.subImage = n3;
        String[] stringArray = new String[]{"OBJ=Resolution-number"};
        InputStream inputStream = this.postCommands(stringArray);
        String string2 = null;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.equals("resolution-number")) {
                object = IIPResolutionOpImage.getDataAsString(inputStream, false);
                int n4 = Integer.valueOf((String)object);
                if (n2 < 0) {
                    this.resolution = 0;
                    continue;
                }
                if (n2 >= n4) {
                    this.resolution = n4 - 1;
                    continue;
                }
                this.resolution = n2;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        this.endResponse(inputStream);
        object = this.colorModel.getColorSpace();
        this.colorSpaceType = ((ColorSpace)object).isCS_sRGB() ? 3 : (object.equals(ColorSpace.getInstance(1003)) ? 1 : 2);
        this.hasAlpha = this.colorModel.hasAlpha();
        this.isAlphaPremultilpied = this.colorModel.isAlphaPremultiplied();
        this.minTileX = this.getMinTileX();
        this.minTileY = this.getMinTileY();
        this.numXTiles = this.getNumXTiles();
    }

    private InputStream postCommands(String[] stringArray) {
        return IIPResolutionOpImage.postCommands(this.URLString, stringArray);
    }

    private void endResponse(InputStream inputStream) {
        IIPResolutionOpImage.closeStream(inputStream);
    }

    public Raster computeTile(int n2, int n3) {
        Raster raster = null;
        if ((n2 - this.minTileX) % this.tileBlockWidth == 0 && (n3 - this.minTileY) % this.tileBlockHeight == 0) {
            int n4;
            int n5 = n2 + this.tileBlockWidth - 1;
            if (n5 > this.getMaxTileX()) {
                n5 = this.getMaxTileX();
            }
            if ((n4 = n3 + this.tileBlockHeight - 1) > this.getMaxTileY()) {
                n4 = this.getMaxTileY();
            }
            raster = this.getTileBlock(n2, n3, n5, n4);
        } else {
            raster = this.getTileFromCache(n2, n3);
            if (raster == null) {
                raster = this.getTileBlock(n2, n3, n2, n3);
            }
        }
        return raster;
    }

    private Point getTileXY(String string, Point point) {
        int n2 = string.indexOf(",", string.indexOf(",") + 1) + 1;
        int n3 = string.lastIndexOf(",");
        int n4 = Integer.valueOf(string.substring(n2, n3));
        int n5 = (n4 + this.minTileX) % this.numXTiles;
        int n6 = (n4 + this.minTileX - n5) / this.numXTiles + this.minTileY;
        if (point == null) {
            point = new Point(n5, n6);
        } else {
            point.setLocation(n5, n6);
        }
        return point;
    }

    private Raster getTileBlock(int n2, int n3, int n4, int n5) {
        int n6 = (n3 - this.minTileY) * this.numXTiles + n2 - this.minTileX;
        int n7 = (n5 - this.minTileY) * this.numXTiles + n4 - this.minTileX;
        String string = null;
        string = n6 == n7 ? new String("til=" + this.resolution + "," + n6 + "," + this.subImage) : new String("til=" + this.resolution + "," + n6 + "-" + n7 + "," + this.subImage);
        InputStream inputStream = this.postCommands(new String[]{string});
        int n8 = -1;
        int n9 = -1;
        byte[] byArray = null;
        String string2 = null;
        Raster raster = null;
        Point point = new Point();
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.startsWith("tile")) {
                int n10;
                int n11 = IIPResolutionOpImage.getLength(inputStream);
                byte[] byArray2 = new byte[8];
                try {
                    inputStream.read(byArray2);
                }
                catch (Exception exception) {
                    IIPResolutionOpImage.throwIIPException(JaiI18N.getString("IIPResolutionOpImage1"));
                }
                n8 = byArray2[3] << 24 | byArray2[2] << 16 | byArray2[1] << 8 | byArray2[0];
                n9 = byArray2[7] << 24 | byArray2[6] << 16 | byArray2[5] << 8 | byArray2[4];
                if ((n11 -= 8) != 0) {
                    byArray = new byte[n11];
                    try {
                        int n12 = 0;
                        n10 = 0;
                        while ((n10 += (n12 = inputStream.read(byArray, n10, n11 - n10))) < n11 && n12 != -1) {
                        }
                        if (n12 != -1) {
                            inputStream.read();
                            inputStream.read();
                        }
                    }
                    catch (Exception exception) {
                        IIPResolutionOpImage.throwIIPException(JaiI18N.getString("IIPResolutionOpImage2"));
                    }
                }
                this.getTileXY(string2, point);
                int n13 = (int)point.getX();
                n10 = (int)point.getY();
                int n14 = this.tileXToX(n13);
                int n15 = this.tileYToY(n10);
                Raster raster2 = null;
                switch (n8) {
                    case 0: {
                        raster2 = this.getUncompressedTile(n14, n15, byArray);
                        break;
                    }
                    case 1: {
                        raster2 = this.getSingleColorTile(n14, n15, n9);
                        break;
                    }
                    case 2: {
                        raster2 = this.getJPEGTile(n14, n15, n9, byArray);
                        break;
                    }
                    default: {
                        raster2 = this.createWritableRaster(this.sampleModel, new Point(n14, n15));
                    }
                }
                if (n13 == n2 && n10 == n3) {
                    raster = raster2;
                    continue;
                }
                this.addTileToCache(n13, n10, raster2);
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        this.endResponse(inputStream);
        return raster;
    }

    private Raster getUncompressedTile(int n2, int n3, byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        return Raster.createRaster(this.sampleModel, dataBufferByte, new Point(n2, n3));
    }

    private Raster getSingleColorTile(int n2, int n3, int n4) {
        byte by = (byte)(n4 & 0xFF);
        byte by2 = (byte)(n4 >> 8 & 0xFF);
        byte by3 = (byte)(n4 >> 16 & 0xFF);
        byte by4 = (byte)(n4 >> 24 & 0xFF);
        int n5 = this.sampleModel.getNumBands();
        int n6 = this.tileWidth * this.tileHeight * n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        switch (n5) {
            case 1: {
                while (n7 < n6) {
                    byArray[n7++] = by;
                }
                break;
            }
            case 2: {
                while (n7 < n6) {
                    byArray[n7++] = by;
                    byArray[n7++] = by4;
                }
                break;
            }
            case 3: {
                while (n7 < n6) {
                    byArray[n7++] = by;
                    byArray[n7++] = by2;
                    byArray[n7++] = by3;
                }
            }
            default: {
                while (n7 < n6) {
                    byArray[n7++] = by;
                    byArray[n7++] = by2;
                    byArray[n7++] = by3;
                    byArray[n7++] = by4;
                }
                break block0;
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        return Raster.createRaster(this.sampleModel, dataBufferByte, new Point(n2, n3));
    }

    private Raster getJPEGTile(int n2, int n3, int n4, byte[] byArray) {
        int n5 = n4 >> 24 & 0xFF;
        boolean bl = (n4 & 0xFF0000) != 0;
        JPEGDecodeParam jPEGDecodeParam = null;
        if (n5 != 0) {
            jPEGDecodeParam = this.getJPEGDecodeParam(n5);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        Raster raster = null;
        try {
            raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(n2, n3);
        }
        catch (Exception exception) {
            ImagingListener imagingListener = ImageUtil.getImagingListener(this.renderHints);
            imagingListener.errorOccurred(JaiI18N.getString("IIPResolutionOpImage3"), new ImagingException(exception), this, false);
        }
        IIPResolutionOpImage.closeStream(byteArrayInputStream);
        if (this.colorSpaceType == 3 && bl) {
            IIPResolutionOpImage.YCbCrToNIFRGB(raster);
        }
        return raster;
    }

    private synchronized JPEGDecodeParam getJPEGDecodeParam(int n2) {
        JPEGDecodeParam jPEGDecodeParam = this.decodeParamCache[n2 - 1];
        if (jPEGDecodeParam == null) {
            String string = new String("OBJ=Comp-group,2," + n2);
            InputStream inputStream = this.postCommands(new String[]{string});
            String string2 = null;
            while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
                if (string2.startsWith("comp-group")) {
                    byte[] byArray = IIPResolutionOpImage.getDataAsByteArray(inputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                    try {
                        jPEGImageDecoder.decodeAsRaster();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jPEGDecodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                    continue;
                }
                IIPResolutionOpImage.checkError(string2, inputStream, true);
            }
            this.endResponse(inputStream);
            if (jPEGDecodeParam != null) {
                this.decodeParamCache[n2 - 1] = jPEGDecodeParam;
            }
        }
        return jPEGDecodeParam;
    }

    private synchronized void initializeIIPProperties() {
        if (!this.arePropertiesInitialized) {
            String[] stringArray = new String[]{"OBJ=IIP", "OBJ=Basic-info", "OBJ=View-info", "OBJ=Summary-info", "OBJ=Copyright"};
            InputStream inputStream = this.postCommands(stringArray);
            String string = null;
            while ((string = IIPResolutionOpImage.getLabel(inputStream)) != null) {
                float[] fArray;
                String string2 = string;
                Object object = null;
                if (string.equals("error")) {
                    IIPResolutionOpImage.flushData(inputStream, true);
                } else if (string.startsWith("colorspace") || string.equals("max-size")) {
                    if (string.startsWith("colorspace")) {
                        string2 = "colorspace";
                    }
                    object = IIPResolutionOpImage.stringToIntArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("resolution-number")) {
                    object = Integer.valueOf(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("aspect-ratio") || string.equals("contrast-adjust") || string.equals("filtering-value")) {
                    object = Float.valueOf(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("affine-transform")) {
                    fArray = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                    object = new AffineTransform(fArray[0], fArray[1], fArray[3], fArray[4], fArray[5], fArray[7]);
                } else if (string.equals("color-twist")) {
                    object = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("roi")) {
                    string2 = "roi-iip";
                    fArray = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                    object = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
                } else if (string.equals("copyright") || string.equals("title") || string.equals("subject") || string.equals("author") || string.equals("keywords") || string.equals("comment") || string.equals("last-author") || string.equals("rev-number") || string.equals("app-name")) {
                    object = IIPResolutionOpImage.getDataAsString(inputStream, true);
                } else if (string.equals("iip") || string.equals("iip-server") || string.equals("edit-time") || string.equals("last-printed") || string.equals("create-dtm") || string.equals("last-save-dtm")) {
                    object = IIPResolutionOpImage.getDataAsString(inputStream, false);
                } else {
                    IIPResolutionOpImage.flushData(inputStream, false);
                }
                if (string2 == null || object == null) continue;
                this.setProperty(string2, object);
            }
            this.endResponse(inputStream);
            this.arePropertiesInitialized = true;
        }
    }

    public String[] getPropertyNames() {
        this.initializeIIPProperties();
        return super.getPropertyNames();
    }

    public Object getProperty(String string) {
        this.initializeIIPProperties();
        return super.getProperty(string);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("AreaOpImage0"));
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("AreaOpImage0"));
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

