/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.OpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class FilteredSubsampleOpImage
extends GeometricOpImage {
    protected int scaleX;
    protected int scaleY;
    protected int hParity;
    protected int vParity;
    protected float[] hKernel;
    protected float[] vKernel;

    private static float[] convolveFullKernels(float[] fArray, float[] fArray2) {
        int n2 = fArray.length;
        int n3 = fArray2.length;
        float[] fArray3 = new float[n2 + n3 - 1];
        int n4 = 0;
        while (n4 < fArray3.length) {
            int n5 = Math.max(0, n4 - n3 + 1);
            while (n5 <= Math.min(n4, n2 - 1)) {
                int n6 = n4;
                fArray3[n6] = fArray3[n6] + fArray[n5] * fArray2[n4 - n5];
                ++n5;
            }
            ++n4;
        }
        return fArray3;
    }

    private static float[] convolveSymmetricKernels(int n2, int n3, float[] fArray, float[] fArray2) {
        int n4 = fArray.length;
        int n5 = fArray2.length;
        int n6 = 2 * n4 - n2;
        int n7 = 2 * n5 - n3;
        int n8 = n6 + n7 - 1;
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n7];
        float[] fArray5 = new float[(n8 + 1) / 2];
        int n9 = 0;
        while (n9 < n6) {
            fArray3[n9] = fArray[Math.abs(n9 - n4 + (n2 - 1) * (n9 / n4) + 1)];
            ++n9;
        }
        int n10 = 0;
        while (n10 < n7) {
            fArray4[n10] = fArray2[Math.abs(n10 - n5 + (n3 - 1) * (n10 / n5) + 1)];
            ++n10;
        }
        float[] fArray6 = FilteredSubsampleOpImage.convolveFullKernels(fArray3, fArray4);
        int n11 = fArray6.length % 2;
        int n12 = 0;
        while (n12 < fArray5.length) {
            fArray5[n12] = fArray6[n8 - fArray5.length - n12 - 1 + n11];
            ++n12;
        }
        return fArray5;
    }

    private static float[] combineFilters(int n2, int n3, float[] fArray) {
        if (n2 % 2 == 1) {
            return (float[])fArray.clone();
        }
        int n4 = 1;
        int n5 = 0;
        switch (n3) {
            case 0: {
                return (float[])fArray.clone();
            }
            case 1: {
                float[] fArray2 = new float[]{0.5f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n4, n5, fArray, fArray2);
            }
            case 2: {
                float[] fArray3 = new float[]{0.5625f, -0.0625f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n4, n5, fArray, fArray3);
            }
            case 3: {
                float[] fArray4 = new float[]{0.625f, -0.125f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n4, n5, fArray, fArray4);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample0"));
    }

    private static int filterParity(int n2, int n3) {
        if (n2 % 2 == 1 || n3 == 0) {
            return 1;
        }
        return 0;
    }

    private static final ImageLayout layoutHelper(RenderedImage renderedImage, Interpolation interpolation, int n2, int n3, int n4, ImageLayout imageLayout) {
        ImageLayout imageLayout2;
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample1"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample2"));
        }
        Rectangle rectangle = FilteredSubsampleOpImage.forwardMapRect(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), n2, n3);
        ImageLayout imageLayout3 = imageLayout2 = imageLayout == null ? new ImageLayout(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : (ImageLayout)imageLayout.clone();
        if (imageLayout != null) {
            imageLayout2.setWidth(rectangle.width);
            imageLayout2.setHeight(rectangle.height);
            imageLayout2.setMinX(rectangle.x);
            imageLayout2.setMinY(rectangle.y);
        }
        return imageLayout2;
    }

    public FilteredSubsampleOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, int n2, int n3, float[] fArray, Interpolation interpolation) {
        super(OpImage.vectorize(renderedImage), FilteredSubsampleOpImage.layoutHelper(renderedImage, interpolation, n2, n3, fArray.length, imageLayout), map, true, borderExtender, interpolation, null);
        int n4;
        if (interpolation instanceof InterpolationNearest) {
            n4 = 0;
        } else if (interpolation instanceof InterpolationBilinear) {
            n4 = 1;
        } else if (interpolation instanceof InterpolationBicubic) {
            n4 = 2;
        } else if (interpolation instanceof InterpolationBicubic2) {
            n4 = 3;
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample3"));
        }
        this.hParity = FilteredSubsampleOpImage.filterParity(n2, n4);
        this.vParity = FilteredSubsampleOpImage.filterParity(n3, n4);
        this.hKernel = FilteredSubsampleOpImage.combineFilters(n2, n4, fArray);
        this.vKernel = FilteredSubsampleOpImage.combineFilters(n3, n4, fArray);
        this.scaleX = n2;
        this.scaleY = n3;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * (double)this.scaleX, point2D.getY() * (double)this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / (double)this.scaleX, point2D.getY() / (double)this.scaleY);
        return point2D2;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n3 = rectangle.x + this.hKernel.length - this.hParity - this.scaleX / 2;
        int n4 = rectangle.y + this.vKernel.length - this.vParity - this.scaleY / 2;
        int n5 = rectangle.width - 2 * this.hKernel.length + this.hParity + 1;
        int n6 = rectangle.height - 2 * this.vKernel.length + this.vParity + 1;
        return FilteredSubsampleOpImage.forwardMapRect(n3, n4, n5, n6, this.scaleX, this.scaleY);
    }

    private static final Rectangle forwardMapRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = 1.0f / (float)n6;
        float f3 = 1.0f / (float)n7;
        n2 = Math.round((float)n2 * f2);
        n3 = Math.round((float)n3 * f3);
        return new Rectangle(n2, n3, Math.round((float)(n2 + n4) * f2) - n2, Math.round((float)(n3 + n5) * f3) - n3);
    }

    protected final Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        float f2 = 1.0f / (float)this.scaleX;
        float f3 = 1.0f / (float)this.scaleY;
        n3 = Math.round((float)n3 * f2);
        n4 = Math.round((float)n4 * f3);
        return new Rectangle(n3, n4, Math.round((float)(n3 + n5) * f2) - n3, Math.round((float)(n4 + n6) * f3) - n4);
    }

    protected final Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        return new Rectangle(n3 * this.scaleX, n4 * this.scaleY, (n3 + n5) * this.scaleX - n3, (n4 + n6) * this.scaleY - n4);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n3 = rectangle.x * this.scaleX - this.hKernel.length + this.hParity + this.scaleX / 2;
        int n4 = rectangle.y * this.scaleY - this.vKernel.length + this.vParity + this.scaleY / 2;
        int n5 = rectangle.width * this.scaleX + 2 * this.hKernel.length - this.hParity - 1;
        int n6 = rectangle.height * this.scaleY + 2 * this.vKernel.length - this.vParity - 1;
        return new Rectangle(n3, n4, n5, n6);
    }

    public void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample5"));
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    protected void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        float f2 = this.vKernel[0];
        float f3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            byte[] byArray3 = byArray[n13];
            byte[] byArray4 = byArray2[n13];
            int n14 = nArray2[n13];
            int n15 = nArray[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    float f4;
                    int n20 = n18 * n7 + n16 * n8 + n14;
                    int n21 = n20 + n12;
                    int n22 = n20 + n11;
                    int n23 = n21 + n11;
                    float f5 = 0.0f;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = this.hKernel.length - 1;
                        while (n29 > this.hParity - 1) {
                            f4 = this.hKernel[n29] * this.vKernel[n24];
                            f5 += f4 * (float)((byArray4[n25] & 0xFF) + (byArray4[n26] & 0xFF) + (byArray4[n27] & 0xFF) + (byArray4[n28] & 0xFF));
                            n25 += n7;
                            n26 -= n7;
                            n27 += n7;
                            n28 -= n7;
                            --n29;
                        }
                        n20 += n8;
                        n21 += n8;
                        n22 -= n8;
                        n23 -= n8;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            f4 = f3 * this.vKernel[n19--];
                            f5 += f4 * (float)((byArray4[n30] & 0xFF) + (byArray4[n31] & 0xFF));
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            f4 = f2 * this.hKernel[n19--];
                            f5 += f4 * (float)((byArray4[n32] & 0xFF) + (byArray4[n33] & 0xFF));
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            f5 += f2 * f3 * (float)(byArray4[n32] & 0xFF);
                        }
                    }
                    if ((double)f5 < 0.0) {
                        f5 = 0.0f;
                    }
                    if ((double)f5 > 255.0) {
                        f5 = 255.0f;
                    }
                    byArray3[n17] = (byte)((double)f5 + 0.5);
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }

    protected void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        float f2 = this.vKernel[0];
        float f3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            short[] sArray3 = sArray[n13];
            short[] sArray4 = sArray2[n13];
            int n14 = nArray2[n13];
            int n15 = nArray[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    float f4;
                    int n20;
                    int n21 = n18 * n7 + n16 * n8 + n14;
                    int n22 = n21 + n12;
                    int n23 = n21 + n11;
                    int n24 = n22 + n11;
                    float f5 = 0.0f;
                    int n25 = this.vKernel.length - 1;
                    while (n25 > this.vParity - 1) {
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = n24;
                        n20 = this.hKernel.length - 1;
                        while (n20 > this.hParity - 1) {
                            f4 = this.hKernel[n20] * this.vKernel[n25];
                            f5 += f4 * (float)((sArray4[n26] & 0xFFFF) + (sArray4[n27] & 0xFFFF) + (sArray4[n28] & 0xFFFF) + (sArray4[n29] & 0xFFFF));
                            n26 += n7;
                            n27 -= n7;
                            n28 += n7;
                            n29 -= n7;
                            --n20;
                        }
                        n21 += n8;
                        n22 += n8;
                        n23 -= n8;
                        n24 -= n8;
                        --n25;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            f4 = f3 * this.vKernel[n19--];
                            f5 += f4 * (float)((sArray4[n30] & 0xFFFF) + (sArray4[n31] & 0xFFFF));
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            f4 = f2 * this.hKernel[n19--];
                            f5 += f4 * (float)((sArray4[n32] & 0xFFFF) + (sArray4[n33] & 0xFFFF));
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            f5 += f2 * f3 * (float)(sArray4[n32] & 0xFFFF);
                        }
                    }
                    sArray3[n17] = (short)((n20 = (int)((double)f5 + 0.5)) > 65535 ? -1 : (short)(n20 < 0 ? 0 : (short)n20));
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }

    protected void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        float f2 = this.vKernel[0];
        float f3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            short[] sArray3 = sArray[n13];
            short[] sArray4 = sArray2[n13];
            int n14 = nArray2[n13];
            int n15 = nArray[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    float f4;
                    int n20 = n18 * n7 + n16 * n8 + n14;
                    int n21 = n20 + n12;
                    int n22 = n20 + n11;
                    int n23 = n21 + n11;
                    float f5 = 0.0f;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = this.hKernel.length - 1;
                        while (n29 > this.hParity - 1) {
                            f4 = this.hKernel[n29] * this.vKernel[n24];
                            f5 += f4 * (float)(sArray4[n25] + sArray4[n26] + sArray4[n27] + sArray4[n28]);
                            n25 += n7;
                            n26 -= n7;
                            n27 += n7;
                            n28 -= n7;
                            --n29;
                        }
                        n20 += n8;
                        n21 += n8;
                        n22 -= n8;
                        n23 -= n8;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            f4 = f3 * this.vKernel[n19--];
                            f5 += f4 * (float)(sArray4[n30] + sArray4[n31]);
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            f4 = f2 * this.hKernel[n19--];
                            f5 += f4 * (float)(sArray4[n32] + sArray4[n33]);
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            f5 += f2 * f3 * (float)sArray4[n32];
                        }
                    }
                    sArray3[n17] = ImageUtil.clampShort((int)((double)f5 + 0.5));
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }

    protected void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        double d2 = this.vKernel[0];
        double d3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            int[] nArray5 = nArray[n13];
            int[] nArray6 = nArray3[n13];
            int n14 = nArray4[n13];
            int n15 = nArray2[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    double d4;
                    int n20 = n18 * n7 + n16 * n8 + n14;
                    int n21 = n20 + n12;
                    int n22 = n20 + n11;
                    int n23 = n21 + n11;
                    double d5 = 0.0;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = this.hKernel.length - 1;
                        while (n29 > this.hParity - 1) {
                            d4 = this.hKernel[n29] * this.vKernel[n24];
                            d5 += d4 * (double)((long)nArray6[n25] + (long)nArray6[n26] + (long)nArray6[n27] + (long)nArray6[n28]);
                            n25 += n7;
                            n26 -= n7;
                            n27 += n7;
                            n28 -= n7;
                            --n29;
                        }
                        n20 += n8;
                        n21 += n8;
                        n22 -= n8;
                        n23 -= n8;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            d4 = d3 * (double)this.vKernel[n19--];
                            d5 += d4 * (double)((long)nArray6[n30] + (long)nArray6[n31]);
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            d4 = d2 * (double)this.hKernel[n19--];
                            d5 += d4 * (double)((long)nArray6[n32] + (long)nArray6[n33]);
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            d5 += d2 * d3 * (double)nArray6[n32];
                        }
                    }
                    nArray5[n17] = ImageUtil.clampInt((int)(d5 + 0.5));
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }

    protected void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        double d2 = this.vKernel[0];
        double d3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            float[] fArray3 = fArray[n13];
            float[] fArray4 = fArray2[n13];
            int n14 = nArray2[n13];
            int n15 = nArray[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    double d4;
                    int n20 = n18 * n7 + n16 * n8 + n14;
                    int n21 = n20 + n12;
                    int n22 = n20 + n11;
                    int n23 = n21 + n11;
                    double d5 = 0.0;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = this.hKernel.length - 1;
                        while (n29 > this.hParity - 1) {
                            d4 = this.hKernel[n29] * this.vKernel[n24];
                            d5 += d4 * ((double)fArray4[n25] + (double)fArray4[n26] + (double)fArray4[n27] + (double)fArray4[n28]);
                            n25 += n7;
                            n26 -= n7;
                            n27 += n7;
                            n28 -= n7;
                            --n29;
                        }
                        n20 += n8;
                        n21 += n8;
                        n22 -= n8;
                        n23 -= n8;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            d4 = d3 * (double)this.vKernel[n19--];
                            d5 += d4 * ((double)fArray4[n30] + (double)fArray4[n31]);
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            d4 = d2 * (double)this.hKernel[n19--];
                            d5 += d4 * ((double)fArray4[n32] + (double)fArray4[n33]);
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            d5 += d2 * d3 * (double)fArray4[n32];
                        }
                    }
                    fArray3[n17] = ImageUtil.clampFloat(d5);
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }

    protected void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 2 * this.hKernel.length - this.hParity;
        int n10 = 2 * this.vKernel.length - this.vParity;
        int n11 = (n10 - 1) * n8;
        int n12 = (n9 - 1) * n7;
        double d2 = this.vKernel[0];
        double d3 = this.hKernel[0];
        int n13 = 0;
        while (n13 < n4) {
            double[] dArray3 = dArray[n13];
            double[] dArray4 = dArray2[n13];
            int n14 = nArray2[n13];
            int n15 = nArray[n13];
            int n16 = 0;
            while (n16 < this.scaleY * n3) {
                int n17 = n15;
                int n18 = 0;
                while (n18 < this.scaleX * n2) {
                    int n19;
                    double d4;
                    int n20 = n18 * n7 + n16 * n8 + n14;
                    int n21 = n20 + n12;
                    int n22 = n20 + n11;
                    int n23 = n21 + n11;
                    double d5 = 0.0;
                    int n24 = this.vKernel.length - 1;
                    while (n24 > this.vParity - 1) {
                        int n25 = n20;
                        int n26 = n21;
                        int n27 = n22;
                        int n28 = n23;
                        int n29 = this.hKernel.length - 1;
                        while (n29 > this.hParity - 1) {
                            d4 = this.hKernel[n29] * this.vKernel[n24];
                            d5 += d4 * (dArray4[n25] + dArray4[n26] + dArray4[n27] + dArray4[n28]);
                            n25 += n7;
                            n26 -= n7;
                            n27 += n7;
                            n28 -= n7;
                            --n29;
                        }
                        n20 += n8;
                        n21 += n8;
                        n22 -= n8;
                        n23 -= n8;
                        --n24;
                    }
                    if (this.hParity == 1) {
                        int n30 = (n18 + this.hKernel.length - 1) * n7 + n16 * n8 + n14;
                        int n31 = n30 + n11;
                        n19 = this.vKernel.length - 1;
                        while (n30 < n31) {
                            d4 = d3 * (double)this.vKernel[n19--];
                            d5 += d4 * (dArray4[n30] + dArray4[n31]);
                            n30 += n8;
                            n31 -= n8;
                        }
                    }
                    if (this.vParity == 1) {
                        int n32 = n18 * n7 + (n16 + this.vKernel.length - 1) * n8 + n14;
                        int n33 = n32 + n12;
                        n19 = this.hKernel.length - 1;
                        while (n32 < n33) {
                            d4 = d2 * (double)this.hKernel[n19--];
                            d5 += d4 * (dArray4[n32] + dArray4[n33]);
                            n32 += n7;
                            n33 -= n7;
                        }
                        if (this.hParity == 1) {
                            d5 += d2 * d3 * dArray4[n32];
                        }
                    }
                    dArray3[n17] = d5;
                    n17 += n5;
                    n18 += this.scaleX;
                }
                n15 += n6;
                n16 += this.scaleY;
            }
            ++n13;
        }
    }
}

