/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class ExtremaOpImage
extends StatisticsOpImage {
    protected double[][] extrema = null;
    protected ArrayList[] minLocations;
    protected ArrayList[] maxLocations;
    protected int[] minCounts;
    protected int[] maxCounts;
    protected boolean saveLocations;
    protected int maxRuns;
    protected int numMinLocations = 0;
    protected int numMaxLocations = 0;
    private boolean isInitialized = false;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n2, int n3) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n2), this.tileYToY(n3), this.tileWidth, this.tileHeight);
    }

    public ExtremaOpImage(RenderedImage renderedImage, ROI rOI, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(renderedImage, rOI, n2, n3, n4, n5);
        this.saveLocations = bl;
        this.maxRuns = n6;
    }

    public Object getProperty(String string) {
        int n2 = this.sampleModel.getNumBands();
        if (this.extrema == null) {
            return super.getProperty(string);
        }
        if (string.equalsIgnoreCase("extrema")) {
            double[][] dArray = new double[2][n2];
            int n3 = 0;
            while (n3 < n2) {
                dArray[0][n3] = this.extrema[0][n3];
                dArray[1][n3] = this.extrema[1][n3];
                ++n3;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("minimum")) {
            double[] dArray = new double[n2];
            int n4 = 0;
            while (n4 < n2) {
                dArray[n4] = this.extrema[0][n4];
                ++n4;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("maximum")) {
            double[] dArray = new double[n2];
            int n5 = 0;
            while (n5 < n2) {
                dArray[n5] = this.extrema[1][n5];
                ++n5;
            }
            return dArray;
        }
        if (this.saveLocations && string.equalsIgnoreCase("minLocations")) {
            return this.minLocations;
        }
        if (this.saveLocations && string.equalsIgnoreCase("maxLocations")) {
            return this.maxLocations;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"extrema", "maximum", "minimum", "maxLocations", "minLocations"};
    }

    protected Object createStatistics(String string) {
        int n2 = this.sampleModel.getNumBands();
        Object object = null;
        object = string.equalsIgnoreCase("extrema") ? new double[2][n2] : (string.equalsIgnoreCase("minimum") || string.equalsIgnoreCase("maximum") ? (Object)new double[n2] : (this.saveLocations && (string.equalsIgnoreCase("minLocations") || string.equalsIgnoreCase("maxLocations")) ? (Object)new ArrayList[n2] : (Object)Image.UndefinedProperty));
        return object;
    }

    private final int startPosition(int n2, int n3, int n4) {
        int n5 = (n2 - n3) % n4;
        return n5 == 0 ? n2 : n2 + (n4 - n5);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        block19: {
            int n2;
            ArrayList[] arrayListArray;
            block22: {
                block21: {
                    block20: {
                        block18: {
                            LinkedList linkedList;
                            if (!this.isInitialized) {
                                this.srcPA = new PixelAccessor(this.getSourceImage(0));
                                this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
                                this.isInitialized = true;
                            }
                            Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
                            if (this.roi == null) {
                                linkedList = new LinkedList();
                                linkedList.addLast(rectangle);
                            } else {
                                linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                                if (linkedList == null) {
                                    return;
                                }
                            }
                            ListIterator listIterator = linkedList.listIterator(0);
                            while (listIterator.hasNext()) {
                                arrayListArray = rectangle.intersection((Rectangle)listIterator.next());
                                n2 = arrayListArray.x;
                                int n3 = arrayListArray.y;
                                arrayListArray.x = this.startPosition(n2, this.xStart, this.xPeriod);
                                arrayListArray.y = this.startPosition(n3, this.yStart, this.yPeriod);
                                arrayListArray.width = n2 + arrayListArray.width - arrayListArray.x;
                                arrayListArray.height = n3 + arrayListArray.height - arrayListArray.y;
                                if (arrayListArray.isEmpty()) continue;
                                this.initializeState(raster);
                                UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)arrayListArray, this.srcSampleType, false);
                                switch (unpackedImageData.type) {
                                    case 0: {
                                        this.accumulateStatisticsByte(unpackedImageData);
                                        break;
                                    }
                                    case 1: {
                                        this.accumulateStatisticsUShort(unpackedImageData);
                                        break;
                                    }
                                    case 2: {
                                        this.accumulateStatisticsShort(unpackedImageData);
                                        break;
                                    }
                                    case 3: {
                                        this.accumulateStatisticsInt(unpackedImageData);
                                        break;
                                    }
                                    case 4: {
                                        this.accumulateStatisticsFloat(unpackedImageData);
                                        break;
                                    }
                                    case 5: {
                                        this.accumulateStatisticsDouble(unpackedImageData);
                                    }
                                }
                            }
                            if (!string.equalsIgnoreCase("extrema")) break block18;
                            arrayListArray = (ArrayList[])((double[][])object);
                            n2 = 0;
                            while (n2 < this.srcPA.numBands) {
                                arrayListArray[0][n2] = this.extrema[0][n2];
                                arrayListArray[1][n2] = (ArrayList)this.extrema[1][n2];
                                ++n2;
                            }
                            break block19;
                        }
                        if (!string.equalsIgnoreCase("minimum")) break block20;
                        arrayListArray = (ArrayList[])((double[])object);
                        n2 = 0;
                        while (n2 < this.srcPA.numBands) {
                            arrayListArray[n2] = (ArrayList)this.extrema[0][n2];
                            ++n2;
                        }
                        break block19;
                    }
                    if (!string.equalsIgnoreCase("maximum")) break block21;
                    arrayListArray = (ArrayList[])((double[])object);
                    n2 = 0;
                    while (n2 < this.srcPA.numBands) {
                        arrayListArray[n2] = (ArrayList)this.extrema[1][n2];
                        ++n2;
                    }
                    break block19;
                }
                if (!string.equalsIgnoreCase("minLocations")) break block22;
                arrayListArray = (ArrayList[])object;
                n2 = 0;
                while (n2 < this.srcPA.numBands) {
                    arrayListArray[n2] = this.minLocations[n2];
                    ++n2;
                }
                break block19;
            }
            if (!string.equalsIgnoreCase("maxLocations")) break block19;
            arrayListArray = (ArrayList[])object;
            n2 = 0;
            while (n2 < this.srcPA.numBands) {
                arrayListArray[n2] = this.maxLocations[n2];
                ++n2;
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                int n7 = (int)this.extrema[0][n6];
                int n8 = (int)this.extrema[1][n6];
                byte[] byArray2 = byArray[n6];
                int n9 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n10 = unpackedImageData.bandOffsets[n6];
                while (n10 < n9) {
                    int n11 = n10 + rectangle.width * n3;
                    int n12 = n10;
                    while (n12 < n11) {
                        int n13 = byArray2[n12] & 0xFF;
                        if (n13 < n7) {
                            n7 = n13;
                        } else if (n13 > n8) {
                            n8 = n13;
                        }
                        n12 += n5;
                    }
                    n10 += n4;
                }
                this.extrema[0][n6] = n7;
                this.extrema[1][n6] = n8;
                ++n6;
            }
        } else {
            int n14 = 0;
            while (n14 < this.srcPA.numBands) {
                int n15 = (int)this.extrema[0][n14];
                int n16 = (int)this.extrema[1][n14];
                ArrayList arrayList = this.minLocations[n14];
                ArrayList arrayList2 = this.maxLocations[n14];
                int n17 = this.minCounts[n14];
                int n18 = this.maxCounts[n14];
                byte[] byArray3 = byArray[n14];
                int n19 = unpackedImageData.bandOffsets[n14] + rectangle.height * n2;
                int n20 = unpackedImageData.bandOffsets[n14];
                int n21 = rectangle.y;
                while (n20 < n19) {
                    int n22 = n20 + rectangle.width * n3;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = n20;
                    int n28 = rectangle.x;
                    while (n27 < n22) {
                        int n29 = byArray3[n27] & 0xFF;
                        if (n29 < n15) {
                            n15 = n29;
                            n23 = n28;
                            n25 = 1;
                            arrayList.clear();
                            n17 = 0;
                        } else if (n29 > n16) {
                            n16 = n29;
                            n24 = n28;
                            n26 = 1;
                            arrayList2.clear();
                            n18 = 0;
                        } else {
                            if (n29 == n15) {
                                if (n25 == 0) {
                                    n23 = n28;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList.add(new int[]{n23, n21, n25});
                                ++n17;
                                n25 = 0;
                            }
                            if (n29 == n16) {
                                if (n26 == 0) {
                                    n24 = n28;
                                }
                                ++n26;
                            } else if (n26 > 0 && n18 < this.maxRuns) {
                                arrayList2.add(new int[]{n24, n21, n26});
                                ++n18;
                                n26 = 0;
                            }
                        }
                        n27 += n5;
                        n28 += this.xPeriod;
                    }
                    if (n26 > 0 && n18 < this.maxRuns) {
                        arrayList2.add(new int[]{n24, n21, n26});
                        ++n18;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList.add(new int[]{n23, n21, n25});
                        ++n17;
                    }
                    n20 += n4;
                    n21 += this.yPeriod;
                }
                this.extrema[0][n14] = n15;
                this.extrema[1][n14] = n16;
                this.minCounts[n14] = n17;
                this.maxCounts[n14] = n18;
                ++n14;
            }
        }
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                int n7 = (int)this.extrema[0][n6];
                int n8 = (int)this.extrema[1][n6];
                short[] sArray2 = sArray[n6];
                int n9 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n10 = unpackedImageData.bandOffsets[n6];
                while (n10 < n9) {
                    int n11 = n10 + rectangle.width * n3;
                    int n12 = n10;
                    while (n12 < n11) {
                        int n13 = sArray2[n12] & 0xFFFF;
                        if (n13 < n7) {
                            n7 = n13;
                        } else if (n13 > n8) {
                            n8 = n13;
                        }
                        n12 += n5;
                    }
                    n10 += n4;
                }
                this.extrema[0][n6] = n7;
                this.extrema[1][n6] = n8;
                ++n6;
            }
        } else {
            int n14 = 0;
            while (n14 < this.srcPA.numBands) {
                int n15 = (int)this.extrema[0][n14];
                int n16 = (int)this.extrema[1][n14];
                ArrayList arrayList = this.minLocations[n14];
                ArrayList arrayList2 = this.maxLocations[n14];
                int n17 = this.minCounts[n14];
                int n18 = this.maxCounts[n14];
                short[] sArray3 = sArray[n14];
                int n19 = unpackedImageData.bandOffsets[n14] + rectangle.height * n2;
                int n20 = unpackedImageData.bandOffsets[n14];
                int n21 = rectangle.y;
                while (n20 < n19) {
                    int n22 = n20 + rectangle.width * n3;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = n20;
                    int n28 = rectangle.x;
                    while (n27 < n22) {
                        int n29 = sArray3[n27] & 0xFFFF;
                        if (n29 < n15) {
                            n15 = n29;
                            n23 = n28;
                            n25 = 1;
                            arrayList.clear();
                            n17 = 0;
                        } else if (n29 > n16) {
                            n16 = n29;
                            n24 = n28;
                            n26 = 1;
                            arrayList2.clear();
                            n18 = 0;
                        } else {
                            if (n29 == n15) {
                                if (n25 == 0) {
                                    n23 = n28;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList.add(new int[]{n23, n21, n25});
                                ++n17;
                                n25 = 0;
                            }
                            if (n29 == n16) {
                                if (n26 == 0) {
                                    n24 = n28;
                                }
                                ++n26;
                            } else if (n26 > 0 && n18 < this.maxRuns) {
                                arrayList2.add(new int[]{n24, n21, n26});
                                ++n18;
                                n26 = 0;
                            }
                        }
                        n27 += n5;
                        n28 += this.xPeriod;
                    }
                    if (n26 > 0 && n18 < this.maxRuns) {
                        arrayList2.add(new int[]{n24, n21, n26});
                        ++n18;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList.add(new int[]{n23, n21, n25});
                        ++n17;
                    }
                    n20 += n4;
                    n21 += this.yPeriod;
                }
                this.extrema[0][n14] = n15;
                this.extrema[1][n14] = n16;
                this.minCounts[n14] = n17;
                this.maxCounts[n14] = n18;
                ++n14;
            }
        }
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                int n7 = (int)this.extrema[0][n6];
                int n8 = (int)this.extrema[1][n6];
                short[] sArray2 = sArray[n6];
                int n9 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n10 = unpackedImageData.bandOffsets[n6];
                while (n10 < n9) {
                    int n11 = n10 + rectangle.width * n3;
                    int n12 = n10;
                    while (n12 < n11) {
                        int n13 = sArray2[n12];
                        if (n13 < n7) {
                            n7 = n13;
                        } else if (n13 > n8) {
                            n8 = n13;
                        }
                        n12 += n5;
                    }
                    n10 += n4;
                }
                this.extrema[0][n6] = n7;
                this.extrema[1][n6] = n8;
                ++n6;
            }
        } else {
            int n14 = 0;
            while (n14 < this.srcPA.numBands) {
                int n15 = (int)this.extrema[0][n14];
                int n16 = (int)this.extrema[1][n14];
                ArrayList arrayList = this.minLocations[n14];
                ArrayList arrayList2 = this.maxLocations[n14];
                int n17 = this.minCounts[n14];
                int n18 = this.maxCounts[n14];
                short[] sArray3 = sArray[n14];
                int n19 = unpackedImageData.bandOffsets[n14] + rectangle.height * n2;
                int n20 = unpackedImageData.bandOffsets[n14];
                int n21 = rectangle.y;
                while (n20 < n19) {
                    int n22 = n20 + rectangle.width * n3;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = n20;
                    int n28 = rectangle.x;
                    while (n27 < n22) {
                        int n29 = sArray3[n27];
                        if (n29 < n15) {
                            n15 = n29;
                            n23 = n28;
                            n25 = 1;
                            arrayList.clear();
                            n17 = 0;
                        } else if (n29 > n16) {
                            n16 = n29;
                            n24 = n28;
                            n26 = 1;
                            arrayList2.clear();
                            n18 = 0;
                        } else {
                            if (n29 == n15) {
                                if (n25 == 0) {
                                    n23 = n28;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList.add(new int[]{n23, n21, n25});
                                ++n17;
                                n25 = 0;
                            }
                            if (n29 == n16) {
                                if (n26 == 0) {
                                    n24 = n28;
                                }
                                ++n26;
                            } else if (n26 > 0 && n18 < this.maxRuns) {
                                arrayList2.add(new int[]{n24, n21, n26});
                                ++n18;
                                n26 = 0;
                            }
                        }
                        n27 += n5;
                        n28 += this.xPeriod;
                    }
                    if (n26 > 0 && n18 < this.maxRuns) {
                        arrayList2.add(new int[]{n24, n21, n26});
                        ++n18;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList.add(new int[]{n23, n21, n25});
                        ++n17;
                    }
                    n20 += n4;
                    n21 += this.yPeriod;
                }
                this.extrema[0][n14] = n15;
                this.extrema[1][n14] = n16;
                this.minCounts[n14] = n17;
                this.maxCounts[n14] = n18;
                ++n14;
            }
        }
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                int n7 = (int)this.extrema[0][n6];
                int n8 = (int)this.extrema[1][n6];
                int[] nArray2 = nArray[n6];
                int n9 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n10 = unpackedImageData.bandOffsets[n6];
                while (n10 < n9) {
                    int n11 = n10 + rectangle.width * n3;
                    int n12 = n10;
                    while (n12 < n11) {
                        int n13 = nArray2[n12];
                        if (n13 < n7) {
                            n7 = n13;
                        } else if (n13 > n8) {
                            n8 = n13;
                        }
                        n12 += n5;
                    }
                    n10 += n4;
                }
                this.extrema[0][n6] = n7;
                this.extrema[1][n6] = n8;
                ++n6;
            }
        } else {
            int n14 = 0;
            while (n14 < this.srcPA.numBands) {
                int n15 = (int)this.extrema[0][n14];
                int n16 = (int)this.extrema[1][n14];
                ArrayList arrayList = this.minLocations[n14];
                ArrayList arrayList2 = this.maxLocations[n14];
                int n17 = this.minCounts[n14];
                int n18 = this.maxCounts[n14];
                int[] nArray3 = nArray[n14];
                int n19 = unpackedImageData.bandOffsets[n14] + rectangle.height * n2;
                int n20 = unpackedImageData.bandOffsets[n14];
                int n21 = rectangle.y;
                while (n20 < n19) {
                    int n22 = n20 + rectangle.width * n3;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = n20;
                    int n28 = rectangle.x;
                    while (n27 < n22) {
                        int n29 = nArray3[n27];
                        if (n29 < n15) {
                            n15 = n29;
                            n23 = n28;
                            n25 = 1;
                            arrayList.clear();
                            n17 = 0;
                        } else if (n29 > n16) {
                            n16 = n29;
                            n24 = n28;
                            n26 = 1;
                            arrayList2.clear();
                            n18 = 0;
                        } else {
                            if (n29 == n15) {
                                if (n25 == 0) {
                                    n23 = n28;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList.add(new int[]{n23, n21, n25});
                                ++n17;
                                n25 = 0;
                            }
                            if (n29 == n16) {
                                if (n26 == 0) {
                                    n24 = n28;
                                }
                                ++n26;
                            } else if (n26 > 0 && n18 < this.maxRuns) {
                                arrayList2.add(new int[]{n24, n21, n26});
                                ++n18;
                                n26 = 0;
                            }
                        }
                        n27 += n5;
                        n28 += this.xPeriod;
                    }
                    if (n26 > 0 && n18 < this.maxRuns) {
                        arrayList2.add(new int[]{n24, n21, n26});
                        ++n18;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList.add(new int[]{n23, n21, n25});
                        ++n17;
                    }
                    n20 += n4;
                    n21 += this.yPeriod;
                }
                this.extrema[0][n14] = n15;
                this.extrema[1][n14] = n16;
                this.minCounts[n14] = n17;
                this.maxCounts[n14] = n18;
                ++n14;
            }
        }
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                float f2 = (float)this.extrema[0][n6];
                float f3 = (float)this.extrema[1][n6];
                float[] fArray2 = fArray[n6];
                int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n8 = unpackedImageData.bandOffsets[n6];
                while (n8 < n7) {
                    int n9 = n8 + rectangle.width * n3;
                    int n10 = n8;
                    while (n10 < n9) {
                        float f4 = fArray2[n10];
                        if (f4 < f2) {
                            f2 = f4;
                        } else if (f4 > f3) {
                            f3 = f4;
                        }
                        n10 += n5;
                    }
                    n8 += n4;
                }
                this.extrema[0][n6] = f2;
                this.extrema[1][n6] = f3;
                ++n6;
            }
        } else {
            int n11 = 0;
            while (n11 < this.srcPA.numBands) {
                float f5 = (float)this.extrema[0][n11];
                float f6 = (float)this.extrema[1][n11];
                ArrayList arrayList = this.minLocations[n11];
                ArrayList arrayList2 = this.maxLocations[n11];
                int n12 = this.minCounts[n11];
                int n13 = this.maxCounts[n11];
                float[] fArray3 = fArray[n11];
                int n14 = unpackedImageData.bandOffsets[n11] + rectangle.height * n2;
                int n15 = unpackedImageData.bandOffsets[n11];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n3;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        float f7 = fArray3[n22];
                        if (f7 < f5) {
                            f5 = f7;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (f7 > f6) {
                            f6 = f7;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (f7 == f5) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (f7 == f6) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n5;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n4;
                    n16 += this.yPeriod;
                }
                this.extrema[0][n11] = f5;
                this.extrema[1][n11] = f6;
                this.minCounts[n11] = n12;
                this.maxCounts[n11] = n13;
                ++n11;
            }
        }
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        int n4 = n2 * this.yPeriod;
        int n5 = n3 * this.xPeriod;
        if (!this.saveLocations) {
            int n6 = 0;
            while (n6 < this.srcPA.numBands) {
                double d2 = this.extrema[0][n6];
                double d3 = this.extrema[1][n6];
                double[] dArray2 = dArray[n6];
                int n7 = unpackedImageData.bandOffsets[n6] + rectangle.height * n2;
                int n8 = unpackedImageData.bandOffsets[n6];
                while (n8 < n7) {
                    int n9 = n8 + rectangle.width * n3;
                    int n10 = n8;
                    while (n10 < n9) {
                        double d4 = dArray2[n10];
                        if (d4 < d2) {
                            d2 = d4;
                        } else if (d4 > d3) {
                            d3 = d4;
                        }
                        n10 += n5;
                    }
                    n8 += n4;
                }
                this.extrema[0][n6] = d2;
                this.extrema[1][n6] = d3;
                ++n6;
            }
        } else {
            int n11 = 0;
            while (n11 < this.srcPA.numBands) {
                double d5 = this.extrema[0][n11];
                double d6 = this.extrema[1][n11];
                ArrayList arrayList = this.minLocations[n11];
                ArrayList arrayList2 = this.maxLocations[n11];
                int n12 = this.minCounts[n11];
                int n13 = this.maxCounts[n11];
                double[] dArray3 = dArray[n11];
                int n14 = unpackedImageData.bandOffsets[n11] + rectangle.height * n2;
                int n15 = unpackedImageData.bandOffsets[n11];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n3;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        double d7 = dArray3[n22];
                        if (d7 < d5) {
                            d5 = d7;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (d7 > d6) {
                            d6 = d7;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (d7 == d5) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (d7 == d6) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n5;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n4;
                    n16 += this.yPeriod;
                }
                this.extrema[0][n11] = d5;
                this.extrema[1][n11] = d6;
                this.minCounts[n11] = n12;
                this.maxCounts[n11] = n13;
                ++n11;
            }
        }
    }

    protected void initializeState(Raster raster) {
        if (this.extrema == null) {
            int n2 = this.sampleModel.getNumBands();
            this.extrema = new double[2][n2];
            Rectangle rectangle = raster.getBounds();
            if (this.roi != null) {
                LinkedList linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (linkedList == null) {
                    return;
                }
                ListIterator listIterator = linkedList.listIterator(0);
                if (listIterator.hasNext()) {
                    rectangle = rectangle.intersection((Rectangle)listIterator.next());
                }
            }
            rectangle.x = this.startPosition(rectangle.x, this.xStart, this.xPeriod);
            rectangle.y = this.startPosition(rectangle.y, this.yStart, this.yPeriod);
            raster.getPixel(rectangle.x, rectangle.y, this.extrema[0]);
            int n3 = 0;
            while (n3 < n2) {
                this.extrema[1][n3] = this.extrema[0][n3];
                ++n3;
            }
            if (this.saveLocations) {
                this.minLocations = new ArrayList[n2];
                this.maxLocations = new ArrayList[n2];
                this.minCounts = new int[n2];
                this.maxCounts = new int[n2];
                int n4 = 0;
                while (n4 < n2) {
                    this.minLocations[n4] = new ArrayList();
                    this.maxLocations[n4] = new ArrayList();
                    this.maxCounts[n4] = 0;
                    this.minCounts[n4] = 0;
                    ++n4;
                }
            }
        }
    }
}

