/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class DivideOpImage
extends PointOpImage {
    private byte[][] divideTableByte;
    private int s1bd = 1;
    private int s2bd = 1;

    public DivideOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        SampleModel sampleModel;
        int n2;
        int n3 = renderedImage.getSampleModel().getNumBands();
        int n4 = renderedImage2.getSampleModel().getNumBands();
        if (imageLayout != null && imageLayout.isValid(256) && (n2 = (sampleModel = imageLayout.getSampleModel(null)).getNumBands()) > 1 && (n3 > 1 && n4 == 1 || n3 == 1 && n4 > 1)) {
            n2 = Math.min(Math.max(n3, n4), n2);
            if (n2 != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n2);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
                }
            }
            this.s1bd = n3 == 1 ? 0 : 1;
            int n5 = this.s2bd = n4 == 1 ? 0 : 1;
        }
        if (this.sampleModel.getTransferType() == 0) {
            this.divideTableByte = new byte[256][256];
            int n6 = 0;
            while (n6 < 256) {
                byte[] byArray = this.divideTableByte[n6];
                byArray[0] = n6 > 0 ? -1 : 0;
                int n7 = 1;
                while (n7 < 256) {
                    byArray[n7] = ImageUtil.clampRoundByte((float)n6 / (float)n7);
                    ++n7;
                }
                ++n6;
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor3.getBinaryDataArray();
            System.arraycopy(rasterAccessor.getBinaryDataArray(), 0, byArray, 0, byArray.length);
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor3.getNumBands();
        int n7 = rasterAccessor3.getWidth();
        int n8 = rasterAccessor3.getHeight();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.byteLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getByteDataArrays(), n4, n5, nArray2, rasterAccessor2.getByteDataArrays(), n9, n10, nArray3, rasterAccessor3.getByteDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getShortDataArrays(), n4, n5, nArray2, rasterAccessor2.getShortDataArrays(), n9, n10, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getShortDataArrays(), n4, n5, nArray2, rasterAccessor2.getShortDataArrays(), n9, n10, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getIntDataArrays(), n4, n5, nArray2, rasterAccessor2.getIntDataArrays(), n9, n10, nArray3, rasterAccessor3.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getFloatDataArrays(), n4, n5, nArray2, rasterAccessor2.getFloatDataArrays(), n9, n10, nArray3, rasterAccessor3.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n6, n7, n8, n2, n3, nArray, rasterAccessor.getDoubleDataArrays(), n4, n5, nArray2, rasterAccessor2.getDoubleDataArrays(), n9, n10, nArray3, rasterAccessor3.getDoubleDataArrays());
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void byteLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, byte[][] byArray, int n7, int n8, int[] nArray2, byte[][] byArray2, int n9, int n10, int[] nArray3, byte[][] byArray3) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n2) {
            byte[] byArray4 = byArray[n12];
            byte[] byArray5 = byArray2[n13];
            byte[] byArray6 = byArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n4) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n5;
                n15 += n7;
                n16 += n9;
                int n21 = 0;
                while (n21 < n3) {
                    byArray6[n20] = this.divideTableByte[byArray4[n18] & 0xFF][byArray5[n19] & 0xFF];
                    n18 += n6;
                    n19 += n8;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void ushortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2, int n9, int n10, int[] nArray3, short[][] sArray3) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n2) {
            short[] sArray4 = sArray[n12];
            short[] sArray5 = sArray2[n13];
            short[] sArray6 = sArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n4) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n5;
                n15 += n7;
                n16 += n9;
                int n21 = 0;
                while (n21 < n3) {
                    float f2 = sArray4[n18] & 0xFFFF;
                    float f3 = sArray5[n19] & 0xFFFF;
                    sArray6[n20] = f2 == 0.0f ? 0 : (f3 == 0.0f ? -1 : ImageUtil.clampRoundUShort(f2 / f3));
                    n18 += n6;
                    n19 += n8;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void shortLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, short[][] sArray, int n7, int n8, int[] nArray2, short[][] sArray2, int n9, int n10, int[] nArray3, short[][] sArray3) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n2) {
            short[] sArray4 = sArray[n12];
            short[] sArray5 = sArray2[n13];
            short[] sArray6 = sArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n4) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n5;
                n15 += n7;
                n16 += n9;
                int n21 = 0;
                while (n21 < n3) {
                    float f2 = sArray4[n18];
                    float f3 = sArray5[n19];
                    sArray6[n20] = f2 == 0.0f ? 0 : (f3 == 0.0f ? (f2 < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : ImageUtil.clampRoundShort(f2 / f3));
                    n18 += n6;
                    n19 += n8;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void intLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[][] nArray2, int n7, int n8, int[] nArray3, int[][] nArray4, int n9, int n10, int[] nArray5, int[][] nArray6) {
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n11 < n2) {
                    int[] nArray7 = nArray2[n12];
                    int[] nArray8 = nArray4[n13];
                    int[] nArray9 = nArray6[n11];
                    int n14 = nArray[n12];
                    int n15 = nArray3[n13];
                    int n16 = nArray5[n11];
                    int n17 = 0;
                    while (n17 < n4) {
                        int n18 = n14;
                        int n19 = n15;
                        int n20 = n16;
                        n14 += n5;
                        n15 += n7;
                        n16 += n9;
                        int n21 = 0;
                        while (n21 < n3) {
                            float f2 = nArray7[n18] & 0xFF;
                            float f3 = nArray8[n19] & 0xFF;
                            nArray9[n20] = f2 == 0.0f ? 0 : (f3 == 0.0f ? 255 : (int)ImageUtil.clampRoundByte(f2 / f3));
                            n18 += n6;
                            n19 += n8;
                            n20 += n10;
                            ++n21;
                        }
                        ++n17;
                    }
                    ++n11;
                    n12 += this.s1bd;
                    n13 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n22 = 0;
                int n23 = 0;
                int n24 = 0;
                while (n22 < n2) {
                    int[] nArray10 = nArray2[n23];
                    int[] nArray11 = nArray4[n24];
                    int[] nArray12 = nArray6[n22];
                    int n25 = nArray[n23];
                    int n26 = nArray3[n24];
                    int n27 = nArray5[n22];
                    int n28 = 0;
                    while (n28 < n4) {
                        int n29 = n25;
                        int n30 = n26;
                        int n31 = n27;
                        n25 += n5;
                        n26 += n7;
                        n27 += n9;
                        int n32 = 0;
                        while (n32 < n3) {
                            float f4 = nArray10[n29] & 0xFFFF;
                            float f5 = nArray11[n30] & 0xFFFF;
                            nArray12[n31] = f4 == 0.0f ? 0 : (f5 == 0.0f ? -1 : (int)ImageUtil.clampRoundUShort(f4 / f5));
                            n29 += n6;
                            n30 += n8;
                            n31 += n10;
                            ++n32;
                        }
                        ++n28;
                    }
                    ++n22;
                    n23 += this.s1bd;
                    n24 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n33 = 0;
                int n34 = 0;
                int n35 = 0;
                while (n33 < n2) {
                    int[] nArray13 = nArray2[n34];
                    int[] nArray14 = nArray4[n35];
                    int[] nArray15 = nArray6[n33];
                    int n36 = nArray[n34];
                    int n37 = nArray3[n35];
                    int n38 = nArray5[n33];
                    int n39 = 0;
                    while (n39 < n4) {
                        int n40 = n36;
                        int n41 = n37;
                        int n42 = n38;
                        n36 += n5;
                        n37 += n7;
                        n38 += n9;
                        int n43 = 0;
                        while (n43 < n3) {
                            float f6 = nArray13[n40];
                            float f7 = nArray14[n41];
                            nArray15[n42] = f6 == 0.0f ? 0 : (f7 == 0.0f ? (f6 < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : (int)ImageUtil.clampRoundShort(f6 / f7));
                            n40 += n6;
                            n41 += n8;
                            n42 += n10;
                            ++n43;
                        }
                        ++n39;
                    }
                    ++n33;
                    n34 += this.s1bd;
                    n35 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n44 = 0;
                int n45 = 0;
                int n46 = 0;
                while (n44 < n2) {
                    int[] nArray16 = nArray2[n45];
                    int[] nArray17 = nArray4[n46];
                    int[] nArray18 = nArray6[n44];
                    int n47 = nArray[n45];
                    int n48 = nArray3[n46];
                    int n49 = nArray5[n44];
                    int n50 = 0;
                    while (n50 < n4) {
                        int n51 = n47;
                        int n52 = n48;
                        int n53 = n49;
                        n47 += n5;
                        n48 += n7;
                        n49 += n9;
                        int n54 = 0;
                        while (n54 < n3) {
                            float f8 = nArray16[n51];
                            float f9 = nArray17[n52];
                            nArray18[n53] = f8 == 0.0f ? 0 : (f9 == 0.0f ? (f8 < 0.0f ? Integer.MIN_VALUE : Integer.MAX_VALUE) : ImageUtil.clampRoundInt(f8 / f9));
                            n51 += n6;
                            n52 += n8;
                            n53 += n10;
                            ++n54;
                        }
                        ++n50;
                    }
                    ++n44;
                    n45 += this.s1bd;
                    n46 += this.s2bd;
                }
                break;
            }
        }
    }

    private void floatLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, float[][] fArray, int n7, int n8, int[] nArray2, float[][] fArray2, int n9, int n10, int[] nArray3, float[][] fArray3) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n2) {
            float[] fArray4 = fArray[n12];
            float[] fArray5 = fArray2[n13];
            float[] fArray6 = fArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n4) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n5;
                n15 += n7;
                n16 += n9;
                int n21 = 0;
                while (n21 < n3) {
                    fArray6[n20] = fArray4[n18] / fArray5[n19];
                    n18 += n6;
                    n19 += n8;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void doubleLoop(int n2, int n3, int n4, int n5, int n6, int[] nArray, double[][] dArray, int n7, int n8, int[] nArray2, double[][] dArray2, int n9, int n10, int[] nArray3, double[][] dArray3) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n2) {
            double[] dArray4 = dArray[n12];
            double[] dArray5 = dArray2[n13];
            double[] dArray6 = dArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n4) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n5;
                n15 += n7;
                n16 += n9;
                int n21 = 0;
                while (n21 < n3) {
                    dArray6[n20] = dArray4[n18] / dArray5[n19];
                    n18 += n6;
                    n19 += n8;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }
}

