/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

final class DilateBinaryOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private int[] kdataPack;
    private int kwPack;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
            }
        }
        return map2;
    }

    public DilateBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, DilateBinaryOpImage.configHelper(map), true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kwPack = (this.kw + 31) / 32;
        this.kdataPack = this.packKernel(kernelJAI);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData2 = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int[] nArray = new int[this.kwPack * this.kh];
        int n2 = rectangle.height;
        int n3 = rectangle.width;
        int n4 = packedImageData.offset;
        int n5 = packedImageData2.offset;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            byte by;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = 0;
            while (n13 < nArray.length) {
                nArray[n13] = 0;
                ++n13;
            }
            int n14 = 0;
            while (n14 < this.kw - 1) {
                DilateBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n12 = this.kwPack - 1;
                n11 = packedImageData.bitOffset + n14;
                n10 = n11 >> 3;
                n11 = 7 - (n11 & 7);
                n9 = 0;
                n8 = n4;
                while (n9 < this.kh) {
                    by = packedImageData.data[n8 + n10];
                    n7 = by >> n11 & 1;
                    int n15 = n12;
                    nArray[n15] = nArray[n15] | n7;
                    n12 += this.kwPack;
                    ++n9;
                    n8 += packedImageData.lineStride;
                }
                ++n14;
            }
            n12 = 0;
            while (n12 < n3) {
                DilateBinaryOpImage.bitShiftMatrixLeft(nArray, this.kh, this.kwPack);
                n11 = this.kwPack - 1;
                n10 = packedImageData.bitOffset + n12 + this.kw - 1;
                n9 = n10 >> 3;
                n10 = 7 - (n10 & 7);
                n8 = 0;
                int n16 = n4;
                while (n8 < this.kh) {
                    by = packedImageData.data[n16 + n9];
                    n7 = by >> n10 & 1;
                    int n17 = n11;
                    nArray[n17] = nArray[n17] | n7;
                    n11 += this.kwPack;
                    ++n8;
                    n16 += packedImageData.lineStride;
                }
                int n18 = 0;
                while (n18 < nArray.length) {
                    if ((nArray[n18] & this.kdataPack[n18]) != 0) {
                        int n19 = packedImageData2.bitOffset + n12;
                        int n20 = 7 - (n19 & 7);
                        int n21 = (n19 >> 3) + n5;
                        int n22 = packedImageData2.data[n21];
                        packedImageData2.data[n21] = (byte)(n22 |= 1 << n20);
                        break;
                    }
                    ++n18;
                }
                ++n12;
            }
            n4 += packedImageData.lineStride;
            n5 += packedImageData2.lineStride;
            ++n6;
        }
        pixelAccessor.setPackedPixels(packedImageData2);
    }

    private final int[] packKernel(KernelJAI kernelJAI) {
        int n2 = kernelJAI.getWidth();
        int n3 = kernelJAI.getHeight();
        int n4 = (31 + n2) / 32;
        int[] nArray = new int[n4 * n3];
        float[] fArray = kernelJAI.getKernelData();
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5;
            int n7 = n4 - 1;
            DilateBinaryOpImage.bitShiftMatrixLeft(nArray, n3, n4);
            int n8 = 0;
            while (n8 < n3) {
                if (fArray[n6] > 0.9f) {
                    int n9 = n7;
                    nArray[n9] = nArray[n9] | 1;
                }
                ++n8;
                n7 += n4;
                n6 += n3;
            }
            ++n5;
        }
        return nArray;
    }

    private static final void bitShiftMatrixLeft(int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n3 - 1) {
                nArray[n4] = nArray[n4] << 1 | nArray[n4 + 1] >>> 31;
                ++n4;
                ++n6;
            }
            int n7 = n4++;
            nArray[n7] = nArray[n7] << 1;
            ++n5;
        }
    }
}

