/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public final class CopyOpImage
extends PointOpImage {
    public CopyOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            rasterAccessor2.copyBinaryDataToRaster();
        } else {
            switch (rasterAccessor2.getDataType()) {
                case 0: {
                    this.byteLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 1: 
                case 2: {
                    this.shortLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 3: {
                    this.intLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 4: {
                    this.floatLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 5: {
                    this.doubleLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage1"));
                }
            }
            if (rasterAccessor2.isDataCopy()) {
                rasterAccessor2.clampDataArrays();
                rasterAccessor2.copyDataToRaster();
            }
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    byArray3[n14] = byArray4[n13];
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    sArray3[n14] = sArray4[n13];
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray[n9];
            int[] nArray6 = nArray3[n9];
            int n10 = nArray4[n9];
            int n11 = nArray2[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    nArray5[n14] = nArray6[n13];
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    fArray3[n14] = fArray4[n13];
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray2[n9];
            int n11 = nArray[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                int n15 = 0;
                while (n15 < n2) {
                    dArray3[n14] = dArray4[n13];
                    n13 += n7;
                    n14 += n5;
                    ++n15;
                }
                n10 += n8;
                n11 += n6;
                ++n12;
            }
            ++n9;
        }
    }
}

