/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;

    public ConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            byte[] byArray3 = byArray[n11];
            byte[] byArray4 = byArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    int n18;
                    float f2 = 0.5f;
                    int n19 = 0;
                    int n20 = n15;
                    int n21 = 0;
                    while (n21 < n6) {
                        n18 = n20;
                        int n22 = 0;
                        while (n22 < n5) {
                            f2 += (float)(byArray4[n18] & 0xFF) * fArray[n19 + n22];
                            n18 += n9;
                            ++n22;
                        }
                        n19 += n5;
                        n20 += n10;
                        ++n21;
                    }
                    n18 = (int)f2;
                    if (n18 < 0) {
                        n18 = 0;
                    } else if (n18 > 255) {
                        n18 = 255;
                    }
                    byArray3[n16] = (byte)n18;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    int n18;
                    float f2 = 0.5f;
                    int n19 = 0;
                    int n20 = n15;
                    int n21 = 0;
                    while (n21 < n6) {
                        n18 = n20;
                        int n22 = 0;
                        while (n22 < n5) {
                            f2 += (float)sArray4[n18] * fArray[n19 + n22];
                            n18 += n9;
                            ++n22;
                        }
                        n19 += n5;
                        n20 += n10;
                        ++n21;
                    }
                    n18 = (int)f2;
                    if (n18 < Short.MIN_VALUE) {
                        n18 = Short.MIN_VALUE;
                    } else if (n18 > Short.MAX_VALUE) {
                        n18 = Short.MAX_VALUE;
                    }
                    sArray3[n16] = (short)n18;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    int n18;
                    float f2 = 0.5f;
                    int n19 = 0;
                    int n20 = n15;
                    int n21 = 0;
                    while (n21 < n6) {
                        n18 = n20;
                        int n22 = 0;
                        while (n22 < n5) {
                            f2 += (float)(sArray4[n18] & 0xFFFF) * fArray[n19 + n22];
                            n18 += n9;
                            ++n22;
                        }
                        n19 += n5;
                        n20 += n10;
                        ++n21;
                    }
                    n18 = (int)f2;
                    if (n18 < 0) {
                        n18 = 0;
                    } else if (n18 > 65535) {
                        n18 = 65535;
                    }
                    sArray3[n16] = (short)n18;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            int[] nArray5 = nArray[n11];
            int[] nArray6 = nArray3[n11];
            int n12 = nArray4[n11];
            int n13 = nArray2[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    float f2 = 0.5f;
                    int n18 = 0;
                    int n19 = n15;
                    int n20 = 0;
                    while (n20 < n6) {
                        int n21 = n19;
                        int n22 = 0;
                        while (n22 < n5) {
                            f2 += (float)nArray6[n21] * fArray[n18 + n22];
                            n21 += n9;
                            ++n22;
                        }
                        n18 += n5;
                        n19 += n10;
                        ++n20;
                    }
                    nArray5[n16] = (int)f2;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            float[] fArray4 = fArray2[n11];
            float[] fArray5 = fArray3[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    float f2 = 0.0f;
                    int n18 = 0;
                    int n19 = n15;
                    int n20 = 0;
                    while (n20 < n6) {
                        int n21 = n19;
                        int n22 = 0;
                        while (n22 < n5) {
                            f2 += fArray5[n21] * fArray[n18 + n22];
                            n21 += n9;
                            ++n22;
                        }
                        n18 += n5;
                        n19 += n10;
                        ++n20;
                    }
                    fArray4[n16] = f2;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n5 = this.kernel.getWidth();
        int n6 = this.kernel.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = 0;
        while (n11 < n4) {
            double[] dArray3 = dArray[n11];
            double[] dArray4 = dArray2[n11];
            int n12 = nArray2[n11];
            int n13 = nArray[n11];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n12;
                int n16 = n13;
                int n17 = 0;
                while (n17 < n2) {
                    double d2 = 0.5;
                    int n18 = 0;
                    int n19 = n15;
                    int n20 = 0;
                    while (n20 < n6) {
                        int n21 = n19;
                        int n22 = 0;
                        while (n22 < n5) {
                            d2 += dArray4[n21] * (double)fArray[n18 + n22];
                            n21 += n9;
                            ++n22;
                        }
                        n18 += n5;
                        n19 += n10;
                        ++n20;
                    }
                    dArray3[n16] = d2;
                    n15 += n9;
                    n16 += n7;
                    ++n17;
                }
                n12 += n10;
                n13 += n8;
                ++n14;
            }
            ++n11;
        }
    }
}

