/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class CompositeOpImage
extends PointOpImage {
    protected RenderedImage source1Alpha;
    protected RenderedImage source2Alpha;
    protected boolean alphaPremultiplied;
    private int aOffset;
    private int cOffset;
    private byte maxValueByte;
    private short maxValueShort;
    private int maxValue;
    private float invMaxValue;

    public CompositeOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, RenderedImage renderedImage3, RenderedImage renderedImage4, boolean bl, boolean bl2) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.source1Alpha = renderedImage3;
        this.source2Alpha = renderedImage4;
        this.alphaPremultiplied = bl;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        int n3 = sampleModel.getNumBands() + 1;
        if (this.sampleModel.getTransferType() != n2 || this.sampleModel.getNumBands() != n3) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n2, this.tileWidth, this.tileHeight, n3);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.aOffset = bl2 ? 0 : n3 - 1;
        this.cOffset = bl2 ? 1 : 0;
        switch (n2) {
            case 0: {
                this.maxValue = 255;
                this.maxValueByte = (byte)-1;
                break;
            }
            case 1: {
                this.maxValue = 65535;
                this.maxValueShort = (short)-1;
                break;
            }
            case 2: {
                this.maxValue = Short.MAX_VALUE;
                this.maxValueShort = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxValue = Integer.MAX_VALUE;
                break;
            }
        }
        this.invMaxValue = 1.0f / (float)this.maxValue;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RenderedImage[] renderedImageArray = this.source2Alpha == null ? new RenderedImage[3] : new RenderedImage[4];
        renderedImageArray[0] = this.getSourceImage(0);
        renderedImageArray[1] = this.getSourceImage(1);
        renderedImageArray[2] = this.source1Alpha;
        Raster raster = this.source1Alpha.getData(rectangle);
        Raster raster2 = null;
        if (this.source2Alpha != null) {
            renderedImageArray[3] = this.source2Alpha;
            raster2 = this.source2Alpha.getData(rectangle);
        }
        RasterFormatTag[] rasterFormatTagArray = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(raster, rectangle, rasterFormatTagArray[2], this.source1Alpha.getColorModel());
        RasterAccessor rasterAccessor4 = null;
        RasterAccessor rasterAccessor5 = null;
        if (this.source2Alpha != null) {
            rasterAccessor4 = new RasterAccessor(raster2, rectangle, rasterFormatTagArray[3], this.source2Alpha.getColorModel());
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[4], this.getColorModel());
        } else {
            rasterAccessor4 = null;
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[3], this.getColorModel());
        }
        switch (rasterAccessor5.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
            }
        }
        rasterAccessor5.copyDataToRaster();
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        byte[] byArray4 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            byArray4 = rasterAccessor4.getByteDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        float f2 = 1.0f - (float)(byArray3[n25 + n11] & 0xFF) * this.invMaxValue;
                        byArray5[this.aOffset][n26 + nArray3[this.aOffset]] = this.maxValueByte;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            byArray5[n29][n26 + nArray3[n29]] = (byte)((float)(byArray[n28][n23 + nArray[n28]] & 0xFF) + (float)(byArray2[n28][n24 + nArray2[n28]] & 0xFF) * f2);
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        int n37 = byArray3[n33 + n11] & 0xFF;
                        float f3 = 1.0f - (float)n37 * this.invMaxValue;
                        byArray5[this.aOffset][n35 + nArray3[this.aOffset]] = (byte)((float)n37 + (float)(byArray4[n34 + n14] & 0xFF) * f3);
                        int n38 = 0;
                        while (n38 < n4) {
                            int n39 = n38 + this.cOffset;
                            byArray5[n39][n35 + nArray3[n39]] = (byte)((float)(byArray[n38][n31 + nArray[n38]] & 0xFF) + (float)(byArray2[n38][n32 + nArray2[n38]] & 0xFF) * f3);
                            ++n38;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n40 = 0;
            while (n40 < n3) {
                int n41 = n17;
                int n42 = n18;
                int n43 = n19;
                int n44 = n21;
                int n45 = 0;
                while (n45 < n2) {
                    float f4 = (float)(byArray3[n43 + n11] & 0xFF) * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    byArray5[this.aOffset][n44 + nArray3[this.aOffset]] = this.maxValueByte;
                    int n46 = 0;
                    while (n46 < n4) {
                        int n47 = n46 + this.cOffset;
                        byArray5[n47][n44 + nArray3[n47]] = (byte)((float)(byArray[n46][n41 + nArray[n46]] & 0xFF) * f4 + (float)(byArray2[n46][n42 + nArray2[n46]] & 0xFF) * f5);
                        ++n46;
                    }
                    n41 += n6;
                    n42 += n8;
                    n43 += n10;
                    n44 += n16;
                    ++n45;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n40;
            }
        } else {
            int n48 = 0;
            while (n48 < n3) {
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = n21;
                int n54 = 0;
                while (n54 < n2) {
                    float f6;
                    float f7;
                    int n55 = byArray3[n51 + n11] & 0xFF;
                    float f8 = (1.0f - (float)n55 * this.invMaxValue) * (float)(byArray4[n52 + n14] & 0xFF);
                    float f9 = (float)n55 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n55 / f9;
                        f6 = f8 / f9;
                    }
                    byArray5[this.aOffset][n53 + nArray3[this.aOffset]] = (byte)f9;
                    int n56 = 0;
                    while (n56 < n4) {
                        int n57 = n56 + this.cOffset;
                        byArray5[n57][n53 + nArray3[n57]] = (byte)((float)(byArray[n56][n49 + nArray[n56]] & 0xFF) * f7 + (float)(byArray2[n56][n50 + nArray2[n56]] & 0xFF) * f6);
                        ++n56;
                    }
                    n49 += n6;
                    n50 += n8;
                    n51 += n10;
                    n52 += n13;
                    n53 += n16;
                    ++n54;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n48;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        float f2 = 1.0f - (float)(sArray3[n25 + n11] & 0xFFFF) * this.invMaxValue;
                        sArray5[this.aOffset][n26 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            sArray5[n29][n26 + nArray3[n29]] = (short)((float)(sArray[n28][n23 + nArray[n28]] & 0xFFFF) + (float)(sArray2[n28][n24 + nArray2[n28]] & 0xFFFF) * f2);
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        int n37 = sArray3[n33 + n11] & 0xFFFF;
                        float f3 = 1.0f - (float)n37 * this.invMaxValue;
                        sArray5[this.aOffset][n35 + nArray3[this.aOffset]] = (short)((float)n37 + (float)(sArray4[n34 + n14] & 0xFFFF) * f3);
                        int n38 = 0;
                        while (n38 < n4) {
                            int n39 = n38 + this.cOffset;
                            sArray5[n39][n35 + nArray3[n39]] = (short)((float)(sArray[n38][n31 + nArray[n38]] & 0xFFFF) + (float)(sArray2[n38][n32 + nArray2[n38]] & 0xFFFF) * f3);
                            ++n38;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n40 = 0;
            while (n40 < n3) {
                int n41 = n17;
                int n42 = n18;
                int n43 = n19;
                int n44 = n21;
                int n45 = 0;
                while (n45 < n2) {
                    float f4 = (float)(sArray3[n43 + n11] & 0xFFFF) * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    sArray5[this.aOffset][n44 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n46 = 0;
                    while (n46 < n4) {
                        int n47 = n46 + this.cOffset;
                        sArray5[n47][n44 + nArray3[n47]] = (short)((float)(sArray[n46][n41 + nArray[n46]] & 0xFFFF) * f4 + (float)(sArray2[n46][n42 + nArray2[n46]] & 0xFFFF) * f5);
                        ++n46;
                    }
                    n41 += n6;
                    n42 += n8;
                    n43 += n10;
                    n44 += n16;
                    ++n45;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n40;
            }
        } else {
            int n48 = 0;
            while (n48 < n3) {
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = n21;
                int n54 = 0;
                while (n54 < n2) {
                    float f6;
                    float f7;
                    int n55 = sArray3[n51 + n11] & 0xFFFF;
                    float f8 = (1.0f - (float)n55 * this.invMaxValue) * (float)(sArray4[n52 + n14] & 0xFFFF);
                    float f9 = (float)n55 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n55 / f9;
                        f6 = f8 / f9;
                    }
                    sArray5[this.aOffset][n53 + nArray3[this.aOffset]] = (short)f9;
                    int n56 = 0;
                    while (n56 < n4) {
                        int n57 = n56 + this.cOffset;
                        sArray5[n57][n53 + nArray3[n57]] = (short)((float)(sArray[n56][n49 + nArray[n56]] & 0xFFFF) * f7 + (float)(sArray2[n56][n50 + nArray2[n56]] & 0xFFFF) * f6);
                        ++n56;
                    }
                    n49 += n6;
                    n50 += n8;
                    n51 += n10;
                    n52 += n13;
                    n53 += n16;
                    ++n54;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n48;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        float f2 = 1.0f - (float)sArray3[n25 + n11] * this.invMaxValue;
                        sArray5[this.aOffset][n26 + nArray3[this.aOffset]] = this.maxValueShort;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            sArray5[n29][n26 + nArray3[n29]] = (short)((float)sArray[n28][n23 + nArray[n28]] + (float)sArray2[n28][n24 + nArray2[n28]] * f2);
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        short s2 = sArray3[n33 + n11];
                        float f3 = 1.0f - (float)s2 * this.invMaxValue;
                        sArray5[this.aOffset][n35 + nArray3[this.aOffset]] = (short)((float)s2 + (float)sArray4[n34 + n14] * f3);
                        int n37 = 0;
                        while (n37 < n4) {
                            int n38 = n37 + this.cOffset;
                            sArray5[n38][n35 + nArray3[n38]] = (short)((float)sArray[n37][n31 + nArray[n37]] + (float)sArray2[n37][n32 + nArray2[n37]] * f3);
                            ++n37;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n3) {
                int n40 = n17;
                int n41 = n18;
                int n42 = n19;
                int n43 = n21;
                int n44 = 0;
                while (n44 < n2) {
                    float f4 = (float)sArray3[n42 + n11] * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    sArray5[this.aOffset][n43 + nArray3[this.aOffset]] = this.maxValueShort;
                    int n45 = 0;
                    while (n45 < n4) {
                        int n46 = n45 + this.cOffset;
                        sArray5[n46][n43 + nArray3[n46]] = (short)((float)sArray[n45][n40 + nArray[n45]] * f4 + (float)sArray2[n45][n41 + nArray2[n45]] * f5);
                        ++n45;
                    }
                    n40 += n6;
                    n41 += n8;
                    n42 += n10;
                    n43 += n16;
                    ++n44;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n3) {
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = n21;
                int n53 = 0;
                while (n53 < n2) {
                    float f6;
                    float f7;
                    short s3 = sArray3[n50 + n11];
                    float f8 = (1.0f - (float)s3 * this.invMaxValue) * (float)sArray4[n51 + n14];
                    float f9 = (float)s3 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)s3 / f9;
                        f6 = f8 / f9;
                    }
                    sArray5[this.aOffset][n52 + nArray3[this.aOffset]] = (short)f9;
                    int n54 = 0;
                    while (n54 < n4) {
                        int n55 = n54 + this.cOffset;
                        sArray5[n55][n52 + nArray3[n55]] = (short)((float)sArray[n54][n48 + nArray[n54]] * f7 + (float)sArray2[n54][n49 + nArray2[n54]] * f6);
                        ++n54;
                    }
                    n48 += n6;
                    n49 += n8;
                    n50 += n10;
                    n51 += n13;
                    n52 += n16;
                    ++n53;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n47;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        int[][] nArray = rasterAccessor.getIntDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        int[] nArray6 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            nArray6 = rasterAccessor4.getIntDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        int[][] nArray7 = rasterAccessor5.getIntDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray8 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        float f2 = 1.0f - (float)nArray5[n25 + n11] * this.invMaxValue;
                        nArray7[this.aOffset][n26 + nArray8[this.aOffset]] = this.maxValue;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            nArray7[n29][n26 + nArray8[n29]] = (int)((float)nArray[n28][n23 + nArray2[n28]] + (float)nArray3[n28][n24 + nArray4[n28]] * f2);
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        int n37 = nArray5[n33 + n11];
                        float f3 = 1.0f - (float)n37 * this.invMaxValue;
                        nArray7[this.aOffset][n35 + nArray8[this.aOffset]] = (int)((float)n37 + (float)nArray6[n34 + n14] * f3);
                        int n38 = 0;
                        while (n38 < n4) {
                            int n39 = n38 + this.cOffset;
                            nArray7[n39][n35 + nArray8[n39]] = (int)((float)nArray[n38][n31 + nArray2[n38]] + (float)nArray3[n38][n32 + nArray4[n38]] * f3);
                            ++n38;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n40 = 0;
            while (n40 < n3) {
                int n41 = n17;
                int n42 = n18;
                int n43 = n19;
                int n44 = n21;
                int n45 = 0;
                while (n45 < n2) {
                    float f4 = (float)nArray5[n43 + n11] * this.invMaxValue;
                    float f5 = 1.0f - f4;
                    nArray7[this.aOffset][n44 + nArray8[this.aOffset]] = this.maxValue;
                    int n46 = 0;
                    while (n46 < n4) {
                        int n47 = n46 + this.cOffset;
                        nArray7[n47][n44 + nArray8[n47]] = (int)((float)nArray[n46][n41 + nArray2[n46]] * f4 + (float)nArray3[n46][n42 + nArray4[n46]] * f5);
                        ++n46;
                    }
                    n41 += n6;
                    n42 += n8;
                    n43 += n10;
                    n44 += n16;
                    ++n45;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n40;
            }
        } else {
            int n48 = 0;
            while (n48 < n3) {
                int n49 = n17;
                int n50 = n18;
                int n51 = n19;
                int n52 = n20;
                int n53 = n21;
                int n54 = 0;
                while (n54 < n2) {
                    float f6;
                    float f7;
                    int n55 = nArray5[n51 + n11];
                    float f8 = (1.0f - (float)n55 * this.invMaxValue) * (float)nArray6[n52 + n14];
                    float f9 = (float)n55 + f8;
                    if (f9 == 0.0f) {
                        f7 = 0.0f;
                        f6 = 0.0f;
                    } else {
                        f7 = (float)n55 / f9;
                        f6 = f8 / f9;
                    }
                    nArray7[this.aOffset][n53 + nArray8[this.aOffset]] = (int)f9;
                    int n56 = 0;
                    while (n56 < n4) {
                        int n57 = n56 + this.cOffset;
                        nArray7[n57][n53 + nArray8[n57]] = (int)((float)nArray[n56][n49 + nArray2[n56]] * f7 + (float)nArray3[n56][n50 + nArray4[n56]] * f6);
                        ++n56;
                    }
                    n49 += n6;
                    n50 += n8;
                    n51 += n10;
                    n52 += n13;
                    n53 += n16;
                    ++n54;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n48;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        float[] fArray4 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            fArray4 = rasterAccessor4.getFloatDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        float f2 = 2.938736E-39f;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        float f3 = 1.0f - fArray3[n25 + n11] * f2;
                        fArray5[this.aOffset][n26 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            fArray5[n29][n26 + nArray3[n29]] = fArray[n28][n23 + nArray[n28]] + fArray2[n28][n24 + nArray2[n28]] * f3;
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        float f4 = fArray3[n33 + n11];
                        float f5 = 1.0f - f4 * f2;
                        fArray5[this.aOffset][n35 + nArray3[this.aOffset]] = f4 + fArray4[n34 + n14] * f5;
                        int n37 = 0;
                        while (n37 < n4) {
                            int n38 = n37 + this.cOffset;
                            fArray5[n38][n35 + nArray3[n38]] = fArray[n37][n31 + nArray[n37]] + fArray2[n37][n32 + nArray2[n37]] * f5;
                            ++n37;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n3) {
                int n40 = n17;
                int n41 = n18;
                int n42 = n19;
                int n43 = n21;
                int n44 = 0;
                while (n44 < n2) {
                    float f6 = fArray3[n42 + n11] * f2;
                    float f7 = 1.0f - f6;
                    fArray5[this.aOffset][n43 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                    int n45 = 0;
                    while (n45 < n4) {
                        int n46 = n45 + this.cOffset;
                        fArray5[n46][n43 + nArray3[n46]] = fArray[n45][n40 + nArray[n45]] * f6 + fArray2[n45][n41 + nArray2[n45]] * f7;
                        ++n45;
                    }
                    n40 += n6;
                    n41 += n8;
                    n42 += n10;
                    n43 += n16;
                    ++n44;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n3) {
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = n21;
                int n53 = 0;
                while (n53 < n2) {
                    float f8;
                    float f9;
                    float f10 = fArray3[n50 + n11];
                    float f11 = (1.0f - f10 * f2) * fArray4[n51 + n14];
                    float f12 = f10 + f11;
                    if (f12 == 0.0f) {
                        f9 = 0.0f;
                        f8 = 0.0f;
                    } else {
                        f9 = f10 / f12;
                        f8 = f11 / f12;
                    }
                    fArray5[this.aOffset][n52 + nArray3[this.aOffset]] = f12;
                    int n54 = 0;
                    while (n54 < n4) {
                        int n55 = n54 + this.cOffset;
                        fArray5[n55][n52 + nArray3[n55]] = fArray[n54][n48 + nArray[n54]] * f9 + fArray2[n54][n49 + nArray2[n54]] * f8;
                        ++n54;
                    }
                    n48 += n6;
                    n49 += n8;
                    n50 += n10;
                    n51 += n13;
                    n52 += n16;
                    ++n53;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n47;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n2 = rasterAccessor5.getWidth();
        int n3 = rasterAccessor5.getHeight();
        int n4 = rasterAccessor.getNumBands();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n5 = rasterAccessor.getScanlineStride();
        int n6 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int n11 = rasterAccessor3.getBandOffset(0);
        double[] dArray4 = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (rasterAccessor4 != null) {
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
            n12 = rasterAccessor4.getScanlineStride();
            n13 = rasterAccessor4.getPixelStride();
            n14 = rasterAccessor4.getBandOffset(0);
        }
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n15 = rasterAccessor5.getScanlineStride();
        int n16 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        double d2 = 5.562684646268003E-309;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                int n22 = 0;
                while (n22 < n3) {
                    int n23 = n17;
                    int n24 = n18;
                    int n25 = n19;
                    int n26 = n21;
                    int n27 = 0;
                    while (n27 < n2) {
                        double d3 = 1.0 - dArray3[n25 + n11] * d2;
                        dArray5[this.aOffset][n26 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                        int n28 = 0;
                        while (n28 < n4) {
                            int n29 = n28 + this.cOffset;
                            dArray5[n29][n26 + nArray3[n29]] = dArray[n28][n23 + nArray[n28]] + dArray2[n28][n24 + nArray2[n28]] * d3;
                            ++n28;
                        }
                        n23 += n6;
                        n24 += n8;
                        n25 += n10;
                        n26 += n16;
                        ++n27;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n21 += n15;
                    ++n22;
                }
            } else {
                int n30 = 0;
                while (n30 < n3) {
                    int n31 = n17;
                    int n32 = n18;
                    int n33 = n19;
                    int n34 = n20;
                    int n35 = n21;
                    int n36 = 0;
                    while (n36 < n2) {
                        double d4 = dArray3[n33 + n11];
                        double d5 = 1.0 - d4 * d2;
                        dArray5[this.aOffset][n35 + nArray3[this.aOffset]] = d4 + dArray4[n34 + n14] * d5;
                        int n37 = 0;
                        while (n37 < n4) {
                            int n38 = n37 + this.cOffset;
                            dArray5[n38][n35 + nArray3[n38]] = dArray[n37][n31 + nArray[n37]] + dArray2[n37][n32 + nArray2[n37]] * d5;
                            ++n37;
                        }
                        n31 += n6;
                        n32 += n8;
                        n33 += n10;
                        n34 += n13;
                        n35 += n16;
                        ++n36;
                    }
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    n20 += n12;
                    n21 += n15;
                    ++n30;
                }
            }
        } else if (rasterAccessor4 == null) {
            int n39 = 0;
            while (n39 < n3) {
                int n40 = n17;
                int n41 = n18;
                int n42 = n19;
                int n43 = n21;
                int n44 = 0;
                while (n44 < n2) {
                    double d6 = dArray3[n42 + n11] * d2;
                    double d7 = 1.0 - d6;
                    dArray5[this.aOffset][n43 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                    int n45 = 0;
                    while (n45 < n4) {
                        int n46 = n45 + this.cOffset;
                        dArray5[n46][n43 + nArray3[n46]] = dArray[n45][n40 + nArray[n45]] * d6 + dArray2[n45][n41 + nArray2[n45]] * d7;
                        ++n45;
                    }
                    n40 += n6;
                    n41 += n8;
                    n42 += n10;
                    n43 += n16;
                    ++n44;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n21 += n15;
                ++n39;
            }
        } else {
            int n47 = 0;
            while (n47 < n3) {
                int n48 = n17;
                int n49 = n18;
                int n50 = n19;
                int n51 = n20;
                int n52 = n21;
                int n53 = 0;
                while (n53 < n2) {
                    double d8;
                    double d9;
                    double d10 = dArray3[n50 + n11];
                    double d11 = (1.0 - d10 * d2) * dArray4[n51 + n14];
                    double d12 = d10 + d11;
                    if (d12 == 0.0) {
                        d9 = 0.0;
                        d8 = 0.0;
                    } else {
                        d9 = d10 / d12;
                        d8 = d11 / d12;
                    }
                    dArray5[this.aOffset][n52 + nArray3[this.aOffset]] = d12;
                    int n54 = 0;
                    while (n54 < n4) {
                        int n55 = n54 + this.cOffset;
                        dArray5[n55][n52 + nArray3[n55]] = dArray[n54][n48 + nArray[n54]] * d9 + dArray2[n54][n49 + nArray2[n54]] * d8;
                        ++n54;
                    }
                    n48 += n6;
                    n49 += n8;
                    n50 += n10;
                    n51 += n13;
                    n52 += n16;
                    ++n53;
                }
                n17 += n5;
                n18 += n7;
                n19 += n9;
                n20 += n12;
                n21 += n15;
                ++n47;
            }
        }
    }
}

