/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.MedianCutOpImage;
import com.sun.media.jai.opimage.NeuQuantOpImage;
import com.sun.media.jai.opimage.OctTreeOpImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.operator.ColorQuantizerDescriptor;
import javax.media.jai.operator.ColorQuantizerType;

public class ColorQuantizerRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        ImageLayout imageLayout = renderingHints == null ? null : (ImageLayout)renderingHints.get(JAI.KEY_IMAGE_LAYOUT);
        ColorQuantizerType colorQuantizerType = (ColorQuantizerType)parameterBlock.getObjectParameter(0);
        int n2 = parameterBlock.getIntParameter(1);
        int n3 = parameterBlock.getIntParameter(2);
        ROI rOI = (ROI)parameterBlock.getObjectParameter(3);
        int n4 = parameterBlock.getIntParameter(4);
        int n5 = parameterBlock.getIntParameter(5);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getNumBands() != 3 && sampleModel.getDataType() == 0) {
            throw new IllegalArgumentException("ColorQuantizerRIF0");
        }
        if (colorQuantizerType.equals(ColorQuantizerDescriptor.NEUQUANT)) {
            return new NeuQuantOpImage(renderedImage, renderingHints, imageLayout, n2, n3, rOI, n4, n5);
        }
        if (colorQuantizerType.equals(ColorQuantizerDescriptor.OCTTREE)) {
            return new OctTreeOpImage(renderedImage, renderingHints, imageLayout, n2, n3, rOI, n4, n5);
        }
        return new MedianCutOpImage(renderedImage, renderingHints, imageLayout, n2, n3, rOI, n4, n5);
    }
}

