/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

abstract class ColorQuantizerOpImage
extends PointOpImage {
    private static final int NBANDS = 3;
    private static final int NGRAYS = 256;
    protected PixelAccessor srcPA;
    protected int srcSampleType;
    protected boolean isInitialized = false;
    protected PixelAccessor destPA;
    protected LookupTableJAI colorMap;
    protected int maxColorNum;
    protected int xPeriod;
    protected int yPeriod;
    protected ROI roi;
    private int numBandsSource;
    protected boolean checkForSkippedTiles = false;

    static final int startPosition(int n2, int n3, int n4) {
        int n5 = (n2 - n3) % n4;
        return n5 == 0 ? n2 : n2 + (n4 - n5);
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        imageLayout2.setColorModel(null);
        return imageLayout2;
    }

    public ColorQuantizerOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, ColorQuantizerOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBandsSource = sampleModel.getNumBands();
        this.maxColorNum = n2;
        this.xPeriod = n3;
        this.yPeriod = n4;
        this.roi = rOI;
        this.checkForSkippedTiles = n3 > this.tileWidth || n4 > this.tileHeight;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.colorMap == null) {
            this.train();
        }
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.isInitialized = true;
        }
        UnpackedImageData unpackedImageData = this.srcPA.getPixels(rasterArray[0], rectangle, this.srcSampleType, false);
        Rectangle rectangle2 = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n2 = unpackedImageData.lineStride;
        int n3 = unpackedImageData.pixelStride;
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n4 = rectangle2.height * n2 + unpackedImageData.bandOffsets[0];
        if (this.destPA == null) {
            this.destPA = new PixelAccessor(this);
        }
        UnpackedImageData unpackedImageData2 = this.destPA.getPixels(writableRaster, rectangle, this.sampleModel.getDataType(), false);
        int n5 = unpackedImageData2.bandOffsets[0];
        int n6 = unpackedImageData2.lineStride;
        byte[] byArray5 = unpackedImageData2.getByteData(0);
        int[] nArray = new int[3];
        int n7 = unpackedImageData.bandOffsets[0];
        while (n7 < n4) {
            int n8 = n7 + rectangle2.width * n3 - unpackedImageData.bandOffsets[0];
            int n9 = n5;
            int n10 = n7 - unpackedImageData.bandOffsets[0];
            while (n10 < n8) {
                byArray5[n9] = this.findNearestEntry(byArray2[n10 + unpackedImageData.bandOffsets[0]] & 0xFF, byArray3[n10 + unpackedImageData.bandOffsets[1]] & 0xFF, byArray4[n10 + unpackedImageData.bandOffsets[2]] & 0xFF);
                n9 += unpackedImageData2.pixelStride;
                n10 += n3;
            }
            n5 += n6;
            n7 += n2;
        }
    }

    public Object getProperty(String string) {
        int n2 = this.sampleModel.getNumBands();
        if ("LUT".equals(string)) {
            if (this.colorMap == null) {
                this.train();
            }
            return this.colorMap;
        }
        return super.getProperty(string);
    }

    protected abstract void train();

    public ColorModel getColorModel() {
        if (this.colorMap == null) {
            this.train();
        }
        if (this.colorModel == null) {
            this.colorModel = new IndexColorModel(8, this.colorMap.getByteData(0).length, this.colorMap.getByteData(0), this.colorMap.getByteData(1), this.colorMap.getByteData(2));
        }
        return this.colorModel;
    }

    protected byte findNearestEntry(int n2, int n3, int n4) {
        byte[] byArray = this.colorMap.getByteData(0);
        byte[] byArray2 = this.colorMap.getByteData(1);
        byte[] byArray3 = this.colorMap.getByteData(2);
        int n5 = 0;
        int n6 = n2 - (byArray[0] & 0xFF);
        int n7 = n3 - (byArray2[0] & 0xFF);
        int n8 = n4 - (byArray3[0] & 0xFF);
        int n9 = n6 * n6 + n7 * n7 + n8 * n8;
        int n10 = 1;
        while (n10 < byArray.length) {
            n6 = n2 - (byArray[n10] & 0xFF);
            int n11 = n6 * n6;
            if (n11 <= n9 && (n11 += (n7 = n3 - (byArray2[n10] & 0xFF)) * n7) <= n9 && (n11 += (n8 = n4 - (byArray3[n10] & 0xFF)) * n8) < n9) {
                n9 = n11;
                n5 = n10;
            }
            ++n10;
        }
        return (byte)n5;
    }
}

