/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class BorderOpImage
extends OpImage {
    protected BorderExtender extender;

    public BorderOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, int n3, int n4, int n5, BorderExtender borderExtender) {
        super(OpImage.vectorize(renderedImage), BorderOpImage.layoutHelper(imageLayout, renderedImage, n2, n3, n4, n5), map, true);
        this.extender = borderExtender;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n2, int n3, int n4, int n5) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX() - n2);
        imageLayout2.setMinY(renderedImage.getMinY() - n4);
        imageLayout2.setWidth(renderedImage.getWidth() + n2 + n3);
        imageLayout2.setHeight(renderedImage.getHeight() + n4 + n5);
        if (!imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(imageLayout2.getMinX(null));
        }
        if (!imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(imageLayout2.getMinY(null));
        }
        imageLayout2.setSampleModel(renderedImage.getSampleModel());
        imageLayout2.setColorModel(renderedImage.getColorModel());
        return imageLayout2;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage0"));
        }
        return new Rectangle(rectangle);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage2"));
        }
        Rectangle rectangle2 = this.getSourceImage(0).getBounds();
        return rectangle.intersection(rectangle2);
    }

    public Raster computeTile(int n2, int n3) {
        WritableRaster writableRaster = this.createTile(n2, n3);
        this.getSourceImage(0).copyExtendedData(writableRaster, this.extender);
        return writableRaster;
    }
}

