/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.UnpackedImageData;

final class BinarizeOpImage
extends PointOpImage {
    private static byte[] byteTable = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static int[] bitsOn = null;
    private double threshold;

    public BinarizeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double d2) {
        super(renderedImage, BinarizeOpImage.layoutHelper(renderedImage, imageLayout, map), map, true);
        if (renderedImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("BinarizeOpImage0"));
        }
        this.threshold = d2;
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (!ImageUtil.isBinary(sampleModel)) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((colorModel = imageLayout2.getColorModel(null)) == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        switch (rasterArray[0].getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 2: {
                this.shortLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 1: {
                this.ushortLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("BinarizeOpImage1"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= 0.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 255.0) {
            return;
        }
        short s2 = (short)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 0, false);
        int n3 = unpackedImageData.bandOffsets[0];
        byte[] byArray = ((byte[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        int n6 = 0;
        while (n6 < rectangle.height) {
            int n7 = n5 + rectangle.width;
            int n8 = n5;
            int n9 = n3;
            while (n8 < n7) {
                if ((byArray[n9] & 0xFF) >= s2) {
                    int n10 = n2 + (n8 >> 3);
                    packedImageData.data[n10] = (byte)(packedImageData.data[n10] | byteTable[n8 % 8]);
                }
                ++n8;
                n9 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
            ++n6;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= -32768.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 32767.0) {
            return;
        }
        short s2 = (short)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 2, false);
        int n3 = unpackedImageData.bandOffsets[0];
        short[] sArray = ((short[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        int n6 = 0;
        while (n6 < rectangle.height) {
            int n7 = n5 + rectangle.width;
            int n8 = n5;
            int n9 = n3;
            while (n8 < n7) {
                if (sArray[n9] >= s2) {
                    int n10 = n2 + (n8 >> 3);
                    packedImageData.data[n10] = (byte)(packedImageData.data[n10] | byteTable[n8 % 8]);
                }
                ++n8;
                n9 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
            ++n6;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void ushortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= 0.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 65535.0) {
            return;
        }
        int n2 = (int)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n3 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 1, false);
        int n4 = unpackedImageData.bandOffsets[0];
        short[] sArray = ((short[][])unpackedImageData.data)[0];
        int n5 = unpackedImageData.pixelStride;
        int n6 = packedImageData.bitOffset;
        int n7 = 0;
        while (n7 < rectangle.height) {
            int n8 = n6 + rectangle.width;
            int n9 = n6;
            int n10 = n4;
            while (n9 < n8) {
                if ((sArray[n10] & 0xFFFF) >= n2) {
                    int n11 = n3 + (n9 >> 3);
                    packedImageData.data[n11] = (byte)(packedImageData.data[n11] | byteTable[n9 % 8]);
                }
                ++n9;
                n10 += n5;
            }
            n3 += packedImageData.lineStride;
            n4 += unpackedImageData.lineStride;
            ++n7;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= -2.147483648E9) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 2.147483647E9) {
            return;
        }
        int n2 = (int)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n3 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 3, false);
        int n4 = unpackedImageData.bandOffsets[0];
        int[] nArray = ((int[][])unpackedImageData.data)[0];
        int n5 = unpackedImageData.pixelStride;
        int n6 = packedImageData.bitOffset;
        int n7 = 0;
        while (n7 < rectangle.height) {
            int n8 = n6 + rectangle.width;
            int n9 = n6;
            int n10 = n4;
            while (n9 < n8) {
                if ((double)nArray[n10] >= this.threshold) {
                    int n11 = n3 + (n9 >> 3);
                    packedImageData.data[n11] = (byte)(packedImageData.data[n11] | byteTable[n9 % 8]);
                }
                ++n9;
                n10 += n5;
            }
            n3 += packedImageData.lineStride;
            n4 += unpackedImageData.lineStride;
            ++n7;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void floatLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 4, false);
        int n3 = unpackedImageData.bandOffsets[0];
        float[] fArray = ((float[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        int n6 = 0;
        while (n6 < rectangle.height) {
            int n7 = n5 + rectangle.width;
            int n8 = n5;
            int n9 = n3;
            while (n8 < n7) {
                if ((double)fArray[n9] > this.threshold) {
                    int n10 = n2 + (n8 >> 3);
                    packedImageData.data[n10] = (byte)(packedImageData.data[n10] | byteTable[n8 % 8]);
                }
                ++n8;
                n9 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
            ++n6;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void doubleLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 5, false);
        int n3 = unpackedImageData.bandOffsets[0];
        double[] dArray = ((double[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        int n6 = 0;
        while (n6 < rectangle.height) {
            int n7 = n5 + rectangle.width;
            int n8 = n5;
            int n9 = n3;
            while (n8 < n7) {
                if (dArray[n9] > this.threshold) {
                    int n10 = n2 + (n8 >> 3);
                    packedImageData.data[n10] = (byte)(packedImageData.data[n10] | byteTable[n8 % 8]);
                }
                ++n8;
                n9 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
            ++n6;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void setTo1(Raster raster, Rectangle rectangle) {
        BinarizeOpImage.initBitsOn();
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, rectangle, true, false);
        int n2 = packedImageData.offset;
        int n3 = 0;
        while (n3 < rectangle.height) {
            int n4 = packedImageData.bitOffset;
            int n5 = n4 + rectangle.width - 1;
            if (n5 < 8) {
                packedImageData.data[n2] = (byte)(packedImageData.data[n2] | bitsOn[n5]);
            } else {
                packedImageData.data[n2] = (byte)(packedImageData.data[n2] | bitsOn[7]);
                int n6 = n2 + 1;
                while (n6 <= n2 + (n5 - 7) / 8) {
                    packedImageData.data[n6] = -1;
                    ++n6;
                }
                int n7 = n5 % 8;
                if (n7 % 8 != 7) {
                    n5 = n2 + n5 / 8;
                    packedImageData.data[n5] = (byte)(packedImageData.data[n5] | bitsOn[n7]);
                }
            }
            n2 += packedImageData.lineStride;
            ++n3;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private static synchronized void initBitsOn() {
        if (bitsOn != null) {
            return;
        }
        bitsOn = new int[64];
        int n2 = 0;
        while (n2 < 8) {
            int n3 = n2;
            while (n3 < 8) {
                int n4 = 255 >> n2;
                int n5 = 255 << 7 - n3;
                BinarizeOpImage.bitsOn[n3 + (n2 << 3)] = n4 & n5;
                ++n3;
            }
            ++n2;
        }
    }
}

