/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.image.ColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PointOpImage;

final class BandSelectOpImage
extends PointOpImage {
    private boolean areDataCopied;
    private int[] bandIndices;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int[] nArray) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = nArray.length;
        SampleModel sampleModel2 = null;
        if (sampleModel instanceof SinglePixelPackedSampleModel && n2 < 3) {
            int[] nArray2;
            int n3 = sampleModel.getWidth();
            int n4 = sampleModel.getHeight();
            int n5 = sampleModel.getWidth() * n2;
            if (n2 == 1) {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = 0;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray2 = nArray4;
                nArray4[1] = 1;
            }
            sampleModel2 = new PixelInterleavedSampleModel(0, n3, n4, n2, n5, nArray2);
        } else {
            sampleModel2 = sampleModel.createSubsetSampleModel(nArray);
        }
        imageLayout2.setSampleModel(sampleModel2);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
            imageLayout2.unsetValid(512);
        }
        imageLayout2.setTileGridXOffset(renderedImage.getTileGridXOffset());
        imageLayout2.setTileGridYOffset(renderedImage.getTileGridYOffset());
        imageLayout2.setTileWidth(renderedImage.getTileWidth());
        imageLayout2.setTileHeight(renderedImage.getTileHeight());
        return imageLayout2;
    }

    public BandSelectOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int[] nArray) {
        super(OpImage.vectorize(renderedImage), BandSelectOpImage.layoutHelper(imageLayout, renderedImage, nArray), map, true);
        this.areDataCopied = renderedImage.getSampleModel() instanceof SinglePixelPackedSampleModel && nArray.length < 3;
        this.bandIndices = (int[])nArray.clone();
    }

    public boolean computesUniqueTiles() {
        return this.areDataCopied;
    }

    public Raster computeTile(int n2, int n3) {
        Raster raster = this.getSourceImage(0).getTile(n2, n3);
        if (this.areDataCopied) {
            raster = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), this.bandIndices);
            WritableRaster writableRaster = this.createTile(n2, n3);
            writableRaster.setRect(raster);
            return writableRaster;
        }
        return raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), this.bandIndices);
    }

    public Raster getTile(int n2, int n3) {
        return this.computeTile(n2, n3);
    }
}

