/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

class BandMergeOpImage
extends PointOpImage {
    ColorModel[] colorModels;

    public BandMergeOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(vector, BandMergeOpImage.layoutHelper(vector, imageLayout), map, true);
        this.permitInPlaceOperation();
        int n2 = vector.size();
        this.colorModels = new ColorModel[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.colorModels[n3] = ((RenderedImage)vector.get(n3)).getColorModel();
            ++n3;
        }
    }

    private static int totalNumBands(Vector vector) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n3);
            n2 = renderedImage.getColorModel() instanceof IndexColorModel ? (n2 += renderedImage.getColorModel().getNumComponents()) : (n2 += renderedImage.getSampleModel().getNumBands());
            ++n3;
        }
        return n2;
    }

    private static ImageLayout layoutHelper(Vector vector, ImageLayout imageLayout) {
        Object object;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n2 = vector.size();
        int n3 = BandMergeOpImage.totalNumBands(vector);
        int n4 = 0;
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        int n5 = 0;
        while (n5 < n2) {
            renderedImage = (RenderedImage)vector.get(n5);
            rectangle = rectangle.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
            int n6 = renderedImage.getSampleModel().getTransferType();
            n4 = n6 > n4 ? n6 : n4;
            ++n5;
        }
        SampleModel sampleModel = imageLayout2.getSampleModel((RenderedImage)vector.get(0));
        if (sampleModel.getNumBands() < n3) {
            object = new int[n3];
            int n7 = 0;
            while (n7 < n3) {
                object[n7] = n7;
                ++n7;
            }
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n4, rectangle.width, rectangle.height, n3);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((object = (Object)imageLayout2.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, (ColorModel)object)) {
            imageLayout2.unsetValid(512);
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = writableRaster.getTransferType();
        switch (n2) {
            case 0: {
                this.byteLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void byteLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            pixelAccessorArray[n3] = new PixelAccessor(rasterArray[n3].getSampleModel(), this.colorModels[n3]);
            nArray[n3] = this.colorModels[n3] instanceof IndexColorModel ? this.colorModels[n3].getNumComponents() : rasterArray[n3].getNumBands();
            ++n3;
        }
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n5, true);
        byte[][] byArray = (byte[][])unpackedImageData.data;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n2) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n6] instanceof IndexColorModel ? pixelAccessorArray[n6].getComponents(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType()) : pixelAccessorArray[n6].getPixels(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType(), false);
            int n8 = unpackedImageData2.pixelStride;
            int n9 = unpackedImageData2.lineStride;
            int n10 = unpackedImageData.pixelStride;
            int n11 = unpackedImageData.lineStride;
            int n12 = rectangle.width;
            int n13 = 0;
            while (n13 < nArray[n6]) {
                if (n7 >= n4) break;
                byte[] byArray2 = byArray[n7];
                byte[][] byArray3 = (byte[][])unpackedImageData2.data;
                byte[] byArray4 = byArray3[n13];
                int n14 = unpackedImageData2.bandOffsets[n13];
                int n15 = unpackedImageData.bandOffsets[n7];
                int n16 = 0;
                while (n16 < rectangle.height) {
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = n15;
                    while (n17 < n12) {
                        byArray2[n19] = byArray4[n18];
                        ++n17;
                        n18 += n8;
                        n19 += n10;
                    }
                    ++n16;
                    n14 += n9;
                    n15 += n11;
                }
                ++n13;
                ++n7;
            }
            ++n6;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void shortLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            pixelAccessorArray[n3] = new PixelAccessor(rasterArray[n3].getSampleModel(), this.colorModels[n3]);
            nArray[n3] = this.colorModels[n3] instanceof IndexColorModel ? this.colorModels[n3].getNumComponents() : rasterArray[n3].getNumBands();
            ++n3;
        }
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n5, true);
        short[][] sArray = (short[][])unpackedImageData.data;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n2) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n6] instanceof IndexColorModel ? pixelAccessorArray[n6].getComponents(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType()) : pixelAccessorArray[n6].getPixels(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType(), false);
            int n8 = unpackedImageData2.pixelStride;
            int n9 = unpackedImageData2.lineStride;
            int n10 = unpackedImageData.pixelStride;
            int n11 = unpackedImageData.lineStride;
            int n12 = rectangle.width;
            int n13 = 0;
            while (n13 < nArray[n6]) {
                if (n7 < n4) {
                    short[][] sArray2 = (short[][])unpackedImageData2.data;
                    int n14 = unpackedImageData2.bandOffsets[n13];
                    int n15 = unpackedImageData.bandOffsets[n7];
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = 0;
                        int n18 = n14;
                        int n19 = n15;
                        while (n17 < n12) {
                            sArray[n7][n19] = sArray2[n13][n18];
                            ++n17;
                            n18 += n8;
                            n19 += n10;
                        }
                        ++n16;
                        n14 += n9;
                        n15 += n11;
                    }
                }
                ++n13;
                ++n7;
            }
            ++n6;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void intLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            pixelAccessorArray[n3] = new PixelAccessor(rasterArray[n3].getSampleModel(), this.colorModels[n3]);
            nArray[n3] = this.colorModels[n3] instanceof IndexColorModel ? this.colorModels[n3].getNumComponents() : rasterArray[n3].getNumBands();
            ++n3;
        }
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n5, true);
        int[][] nArray2 = (int[][])unpackedImageData.data;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n2) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n6] instanceof IndexColorModel ? pixelAccessorArray[n6].getComponents(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType()) : pixelAccessorArray[n6].getPixels(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType(), false);
            int n8 = unpackedImageData2.pixelStride;
            int n9 = unpackedImageData2.lineStride;
            int n10 = unpackedImageData.pixelStride;
            int n11 = unpackedImageData.lineStride;
            int n12 = rectangle.width;
            int n13 = 0;
            while (n13 < nArray[n6]) {
                if (n7 < n4) {
                    int[][] nArray3 = (int[][])unpackedImageData2.data;
                    int n14 = unpackedImageData2.bandOffsets[n13];
                    int n15 = unpackedImageData.bandOffsets[n7];
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = 0;
                        int n18 = n14;
                        int n19 = n15;
                        while (n17 < n12) {
                            nArray2[n7][n19] = nArray3[n13][n18];
                            ++n17;
                            n18 += n8;
                            n19 += n10;
                        }
                        ++n16;
                        n14 += n9;
                        n15 += n11;
                    }
                }
                ++n13;
                ++n7;
            }
            ++n6;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void floatLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            pixelAccessorArray[n3] = new PixelAccessor(rasterArray[n3].getSampleModel(), this.colorModels[n3]);
            nArray[n3] = this.colorModels[n3] instanceof IndexColorModel ? this.colorModels[n3].getNumComponents() : rasterArray[n3].getNumBands();
            ++n3;
        }
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n5, true);
        float[][] fArray = (float[][])unpackedImageData.data;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n2) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n6] instanceof IndexColorModel ? pixelAccessorArray[n6].getComponents(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType()) : pixelAccessorArray[n6].getPixels(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType(), false);
            int n8 = unpackedImageData2.pixelStride;
            int n9 = unpackedImageData2.lineStride;
            int n10 = unpackedImageData.pixelStride;
            int n11 = unpackedImageData.lineStride;
            int n12 = rectangle.width;
            int n13 = 0;
            while (n13 < nArray[n6]) {
                if (n7 < n4) {
                    float[][] fArray2 = (float[][])unpackedImageData2.data;
                    int n14 = unpackedImageData2.bandOffsets[n13];
                    int n15 = unpackedImageData.bandOffsets[n7];
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = 0;
                        int n18 = n14;
                        int n19 = n15;
                        while (n17 < n12) {
                            fArray[n7][n19] = fArray2[n13][n18];
                            ++n17;
                            n18 += n8;
                            n19 += n10;
                        }
                        ++n16;
                        n14 += n9;
                        n15 += n11;
                    }
                }
                ++n13;
                ++n7;
            }
            ++n6;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void doubleLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        int n3 = 0;
        while (n3 < n2) {
            pixelAccessorArray[n3] = new PixelAccessor(rasterArray[n3].getSampleModel(), this.colorModels[n3]);
            nArray[n3] = this.colorModels[n3] instanceof IndexColorModel ? this.colorModels[n3].getNumComponents() : rasterArray[n3].getNumBands();
            ++n3;
        }
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n5, true);
        double[][] dArray = (double[][])unpackedImageData.data;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n2) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n6] instanceof IndexColorModel ? pixelAccessorArray[n6].getComponents(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType()) : pixelAccessorArray[n6].getPixels(rasterArray[n6], rectangle, rasterArray[n6].getSampleModel().getTransferType(), false);
            int n8 = unpackedImageData2.pixelStride;
            int n9 = unpackedImageData2.lineStride;
            int n10 = unpackedImageData.pixelStride;
            int n11 = unpackedImageData.lineStride;
            int n12 = rectangle.width;
            int n13 = 0;
            while (n13 < nArray[n6]) {
                if (n7 < n4) {
                    double[][] dArray2 = (double[][])unpackedImageData2.data;
                    int n14 = unpackedImageData2.bandOffsets[n13];
                    int n15 = unpackedImageData.bandOffsets[n7];
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = 0;
                        int n18 = n14;
                        int n19 = n15;
                        while (n17 < n12) {
                            dArray[n7][n19] = dArray2[n13][n18];
                            ++n17;
                            n18 += n8;
                            n19 += n10;
                        }
                        ++n16;
                        n14 += n9;
                        n15 += n11;
                    }
                }
                ++n13;
                ++n7;
            }
            ++n6;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }
}

