/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBilinearOpImage
extends AffineOpImage {
    public AffineBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n12];
        int n17 = 0;
        while (n17 < n12) {
            byArray3[n17] = (byte)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = n14;
        while (n18 < n16) {
            int n19 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            float f8 = f6 - (float)n20;
            float f9 = f7 - (float)n21;
            int n22 = (n21 - n3) * n11;
            int n23 = (n20 - n2) * n10;
            int n24 = n22 + n11;
            int n25 = n23 + n10;
            int n26 = n23 + n22;
            int n27 = n25 + n22;
            int n28 = n23 + n24;
            int n29 = n25 + n24;
            int n30 = n13;
            while (n30 < n15) {
                int n31;
                if ((float)n20 >= f2 && (float)n20 < f4 - 1.0f && (float)n21 >= f3 && (float)n21 < f5 - 1.0f) {
                    n31 = 0;
                    while (n31 < n12) {
                        byte[] byArray4 = byArray2[n31];
                        int n32 = nArray2[n31];
                        int n33 = byArray4[n26 + n32] & 0xFF;
                        int n34 = byArray4[n27 + n32] & 0xFF;
                        float f10 = (float)n33 + (float)(n34 - n33) * f8;
                        int n35 = byArray4[n28 + n32] & 0xFF;
                        int n36 = byArray4[n29 + n32] & 0xFF;
                        float f11 = (float)n35 + (float)(n36 - n35) * f8;
                        float f12 = f10 + (f11 - f10) * f9;
                        int n37 = f12 < 0.5f ? 0 : (f12 > 254.5f ? 255 : (int)(f12 + 0.5f));
                        byArray[n31][n19 + nArray[n31]] = (byte)(n37 & 0xFF);
                        ++n31;
                    }
                } else if (this.setBackground) {
                    n31 = 0;
                    while (n31 < n12) {
                        byArray[n31][n19 + nArray[n31]] = byArray3[n31];
                        ++n31;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n20 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n20 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n21 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n21 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n22 = (n21 - n3) * n11;
                n23 = (n20 - n2) * n10;
                n24 = n22 + n11;
                n25 = n23 + n10;
                n26 = n23 + n22;
                n27 = n25 + n22;
                n28 = n23 + n24;
                n29 = n25 + n24;
                n19 += n8;
                ++n30;
            }
            n4 += n9;
            ++n18;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n12];
        int n17 = 0;
        while (n17 < n12) {
            nArray5[n17] = (int)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = n14;
        while (n18 < n16) {
            int n19 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            float f8 = f6 - (float)n20;
            float f9 = f7 - (float)n21;
            int n22 = (n21 - n3) * n11;
            int n23 = (n20 - n2) * n10;
            int n24 = n22 + n11;
            int n25 = n23 + n10;
            int n26 = n23 + n22;
            int n27 = n25 + n22;
            int n28 = n23 + n24;
            int n29 = n25 + n24;
            int n30 = n13;
            while (n30 < n15) {
                int n31;
                if ((float)n20 >= f2 && (float)n20 < f4 - 1.0f && (float)n21 >= f3 && (float)n21 < f5 - 1.0f) {
                    n31 = 0;
                    while (n31 < n12) {
                        int[] nArray6 = nArray3[n31];
                        int n32 = nArray4[n31];
                        int n33 = nArray6[n26 + n32];
                        int n34 = nArray6[n27 + n32];
                        float f10 = (float)n33 + (float)(n34 - n33) * f8;
                        int n35 = nArray6[n28 + n32];
                        int n36 = nArray6[n29 + n32];
                        float f11 = (float)n35 + (float)(n36 - n35) * f8;
                        float f12 = f10 + (f11 - f10) * f9;
                        int n37 = f12 < -2.1474836E9f ? Integer.MIN_VALUE : (f12 > 2.1474836E9f ? Integer.MAX_VALUE : (f12 > 0.0f ? (int)(f12 + 0.5f) : (int)(f12 - 0.5f)));
                        nArray[n31][n19 + nArray2[n31]] = n37;
                        ++n31;
                    }
                } else if (this.setBackground) {
                    n31 = 0;
                    while (n31 < n12) {
                        nArray[n31][n19 + nArray2[n31]] = nArray5[n31];
                        ++n31;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n20 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n20 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n21 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n21 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n22 = (n21 - n3) * n11;
                n23 = (n20 - n2) * n10;
                n24 = n22 + n11;
                n25 = n23 + n10;
                n26 = n23 + n22;
                n27 = n25 + n22;
                n28 = n23 + n24;
                n29 = n25 + n24;
                n19 += n8;
                ++n30;
            }
            n4 += n9;
            ++n18;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n12];
        int n17 = 0;
        while (n17 < n12) {
            sArray3[n17] = (short)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = n14;
        while (n18 < n16) {
            int n19 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            float f8 = f6 - (float)n20;
            float f9 = f7 - (float)n21;
            int n22 = (n21 - n3) * n11;
            int n23 = (n20 - n2) * n10;
            int n24 = n22 + n11;
            int n25 = n23 + n10;
            int n26 = n23 + n22;
            int n27 = n25 + n22;
            int n28 = n23 + n24;
            int n29 = n25 + n24;
            int n30 = n13;
            while (n30 < n15) {
                int n31;
                if ((float)n20 >= f2 && (float)n20 < f4 - 1.0f && (float)n21 >= f3 && (float)n21 < f5 - 1.0f) {
                    n31 = 0;
                    while (n31 < n12) {
                        short[] sArray4 = sArray2[n31];
                        int n32 = nArray2[n31];
                        short s2 = sArray4[n26 + n32];
                        short s3 = sArray4[n27 + n32];
                        float f10 = (float)s2 + (float)(s3 - s2) * f8;
                        short s4 = sArray4[n28 + n32];
                        short s5 = sArray4[n29 + n32];
                        float f11 = (float)s4 + (float)(s5 - s4) * f8;
                        float f12 = f10 + (f11 - f10) * f9;
                        int n33 = f12 < -32768.0f ? Short.MIN_VALUE : (f12 > 32767.0f ? Short.MAX_VALUE : (f12 > 0.0f ? (int)(f12 + 0.5f) : (int)(f12 - 0.5f)));
                        sArray[n31][n19 + nArray[n31]] = (short)n33;
                        ++n31;
                    }
                } else if (this.setBackground) {
                    n31 = 0;
                    while (n31 < n12) {
                        sArray[n31][n19 + nArray[n31]] = sArray3[n31];
                        ++n31;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n20 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n20 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n21 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n21 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n22 = (n21 - n3) * n11;
                n23 = (n20 - n2) * n10;
                n24 = n22 + n11;
                n25 = n23 + n10;
                n26 = n23 + n22;
                n27 = n25 + n22;
                n28 = n23 + n24;
                n29 = n25 + n24;
                n19 += n8;
                ++n30;
            }
            n4 += n9;
            ++n18;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n12];
        int n17 = 0;
        while (n17 < n12) {
            sArray3[n17] = (short)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = n14;
        while (n18 < n16) {
            int n19 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            float f8 = f6 - (float)n20;
            float f9 = f7 - (float)n21;
            int n22 = (n21 - n3) * n11;
            int n23 = (n20 - n2) * n10;
            int n24 = n22 + n11;
            int n25 = n23 + n10;
            int n26 = n23 + n22;
            int n27 = n25 + n22;
            int n28 = n23 + n24;
            int n29 = n25 + n24;
            int n30 = n13;
            while (n30 < n15) {
                int n31;
                if ((float)n20 >= f2 && (float)n20 < f4 - 1.0f && (float)n21 >= f3 && (float)n21 < f5 - 1.0f) {
                    n31 = 0;
                    while (n31 < n12) {
                        short[] sArray4 = sArray2[n31];
                        int n32 = nArray2[n31];
                        int n33 = sArray4[n26 + n32] & 0xFFFF;
                        int n34 = sArray4[n27 + n32] & 0xFFFF;
                        float f10 = (float)n33 + (float)(n34 - n33) * f8;
                        int n35 = sArray4[n28 + n32] & 0xFFFF;
                        int n36 = sArray4[n29 + n32] & 0xFFFF;
                        float f11 = (float)n35 + (float)(n36 - n35) * f8;
                        float f12 = f10 + (f11 - f10) * f9;
                        int n37 = (double)f12 < 0.0 ? 0 : (f12 > 65535.0f ? 65535 : (int)(f12 + 0.5f));
                        sArray[n31][n19 + nArray[n31]] = (short)(n37 & 0xFFFF);
                        ++n31;
                    }
                } else if (this.setBackground) {
                    n31 = 0;
                    while (n31 < n12) {
                        sArray[n31][n19 + nArray[n31]] = sArray3[n31];
                        ++n31;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n20 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n20 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n21 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n21 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n22 = (n21 - n3) * n11;
                n23 = (n20 - n2) * n10;
                n24 = n22 + n11;
                n25 = n23 + n10;
                n26 = n23 + n22;
                n27 = n25 + n22;
                n28 = n23 + n24;
                n29 = n25 + n24;
                n19 += n8;
                ++n30;
            }
            n4 += n9;
            ++n18;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n12];
        int n17 = 0;
        while (n17 < n12) {
            fArray3[n17] = (float)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = n14;
        while (n18 < n16) {
            int n19 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n18 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            float f8 = f6 - (float)n20;
            float f9 = f7 - (float)n21;
            int n22 = (n21 - n3) * n11;
            int n23 = (n20 - n2) * n10;
            int n24 = n22 + n11;
            int n25 = n23 + n10;
            int n26 = n23 + n22;
            int n27 = n25 + n22;
            int n28 = n23 + n24;
            int n29 = n25 + n24;
            int n30 = n13;
            while (n30 < n15) {
                int n31;
                if ((float)n20 >= f2 && (float)n20 < f4 - 1.0f && (float)n21 >= f3 && (float)n21 < f5 - 1.0f) {
                    n31 = 0;
                    while (n31 < n12) {
                        float f10;
                        float[] fArray4 = fArray2[n31];
                        int n32 = nArray2[n31];
                        float f11 = fArray4[n26 + n32];
                        float f12 = fArray4[n27 + n32];
                        float f13 = fArray4[n28 + n32];
                        float f14 = fArray4[n29 + n32];
                        float f15 = f11 + (f12 - f11) * f8;
                        float f16 = f13 + (f14 - f13) * f8;
                        fArray[n31][n19 + nArray[n31]] = f10 = f15 + (f16 - f15) * f9;
                        ++n31;
                    }
                } else if (this.setBackground) {
                    n31 = 0;
                    while (n31 < n12) {
                        fArray[n31][n19 + nArray[n31]] = fArray3[n31];
                        ++n31;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n20 += this.incx;
                    f8 = (float)((double)f8 + this.fracdx);
                } else {
                    n20 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n21 += this.incy;
                    f9 = (float)((double)f9 + this.fracdy);
                } else {
                    n21 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n22 = (n21 - n3) * n11;
                n23 = (n20 - n2) * n10;
                n24 = n22 + n11;
                n25 = n23 + n10;
                n26 = n23 + n22;
                n27 = n25 + n22;
                n28 = n23 + n24;
                n29 = n25 + n24;
                n19 += n8;
                ++n30;
            }
            n4 += n9;
            ++n18;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n10 = rasterAccessor.getPixelStride();
        int n11 = rasterAccessor.getScanlineStride();
        int n12 = rasterAccessor2.getNumBands();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = n14;
        while (n17 < n16) {
            int n18 = n4;
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n19 = (int)Math.floor(f6);
            int n20 = (int)Math.floor(f7);
            double d2 = f6 - (float)n19;
            double d3 = f7 - (float)n20;
            int n21 = (n20 - n3) * n11;
            int n22 = (n19 - n2) * n10;
            int n23 = n21 + n11;
            int n24 = n22 + n10;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n13;
            while (n29 < n15) {
                int n30;
                if ((float)n19 >= f2 && (float)n19 < f4 - 1.0f && (float)n20 >= f3 && (float)n20 < f5 - 1.0f) {
                    n30 = 0;
                    while (n30 < n12) {
                        double d4;
                        double[] dArray3 = dArray2[n30];
                        int n31 = nArray2[n30];
                        double d5 = dArray3[n25 + n31];
                        double d6 = dArray3[n26 + n31];
                        double d7 = dArray3[n27 + n31];
                        double d8 = dArray3[n28 + n31];
                        double d9 = d5 + (d6 - d5) * d2;
                        double d10 = d7 + (d8 - d7) * d2;
                        dArray[n30][n18 + nArray[n30]] = d4 = d9 + (d10 - d9) * d3;
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n12) {
                        dArray[n30][n18 + nArray[n30]] = this.backgroundValues[n30];
                        ++n30;
                    }
                }
                if (d2 < this.fracdx1) {
                    n19 += this.incx;
                    d2 += this.fracdx;
                } else {
                    n19 += this.incx1;
                    d2 -= this.fracdx1;
                }
                if (d3 < this.fracdy1) {
                    n20 += this.incy;
                    d3 += this.fracdy;
                } else {
                    n20 += this.incy1;
                    d3 -= this.fracdy1;
                }
                n21 = (n20 - n3) * n11;
                n22 = (n19 - n2) * n10;
                n23 = n21 + n11;
                n24 = n22 + n10;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n8;
                ++n29;
            }
            n4 += n9;
            ++n17;
        }
    }
}

