/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBicubic2OpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;

    public AffineBicubic2OpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n2, n3, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n9];
        int n14 = 0;
        while (n14 < n9) {
            byArray3[n14] = (byte)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n19 + n20 - n8 - n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n23 + n7;
            int n25 = n21 + n8;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n27 + n7;
            int n29 = n25 + n8;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n31 + n7;
            int n33 = n29 + n8;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n35 + n7;
            int n37 = n10;
            while (n37 < n12) {
                int n38;
                if ((float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f && (float)n18 >= f3 + 1.0f && (float)n18 < f5 - 2.0f) {
                    n38 = 0;
                    while (n38 < n9) {
                        byte[] byArray4 = byArray2[n38];
                        int n39 = nArray2[n38];
                        int n40 = byArray4[n21 + n39] & 0xFF;
                        int n41 = byArray4[n22 + n39] & 0xFF;
                        int n42 = byArray4[n23 + n39] & 0xFF;
                        int n43 = byArray4[n24 + n39] & 0xFF;
                        int n44 = byArray4[n25 + n39] & 0xFF;
                        int n45 = byArray4[n26 + n39] & 0xFF;
                        int n46 = byArray4[n27 + n39] & 0xFF;
                        int n47 = byArray4[n28 + n39] & 0xFF;
                        int n48 = byArray4[n29 + n39] & 0xFF;
                        int n49 = byArray4[n30 + n39] & 0xFF;
                        int n50 = byArray4[n31 + n39] & 0xFF;
                        int n51 = byArray4[n32 + n39] & 0xFF;
                        int n52 = byArray4[n33 + n39] & 0xFF;
                        int n53 = byArray4[n34 + n39] & 0xFF;
                        int n54 = byArray4[n35 + n39] & 0xFF;
                        int n55 = byArray4[n36 + n39] & 0xFF;
                        int n56 = (int)(f8 * (float)this.shiftvalue);
                        int n57 = (int)(f9 * (float)this.shiftvalue);
                        float f10 = this.interp.interpolate(n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57);
                        int n58 = f10 < 0.5f ? 0 : (f10 > 254.5f ? 255 : (int)(f10 + 0.5f));
                        byArray[n38][n16 + nArray[n38]] = (byte)(n58 & 0xFF);
                        ++n38;
                    }
                } else if (this.setBackground) {
                    n38 = 0;
                    while (n38 < n9) {
                        byArray[n38][n16 + nArray[n38]] = byArray3[n38];
                        ++n38;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    if ((f8 = (float)((double)f8 + this.fracdx)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    if ((f9 = (float)((double)f9 + this.fracdy)) == 1.0f) {
                        f9 = 0.999999f;
                    }
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n21 = n19 + n20 - n8 - n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n23 + n7;
                n25 = n21 + n8;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n27 + n7;
                n29 = n25 + n8;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n31 + n7;
                n33 = n29 + n8;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n36 = n35 + n7;
                n16 += n5;
                ++n37;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n9];
        int n14 = 0;
        while (n14 < n9) {
            nArray5[n14] = (int)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n19 + n20 - n8 - n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n23 + n7;
            int n25 = n21 + n8;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n27 + n7;
            int n29 = n25 + n8;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n31 + n7;
            int n33 = n29 + n8;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n35 + n7;
            int n37 = n10;
            while (n37 < n12) {
                int n38;
                if ((float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f && (float)n18 >= f3 + 1.0f && (float)n18 < f5 - 2.0f) {
                    n38 = 0;
                    while (n38 < n9) {
                        int[] nArray6 = nArray3[n38];
                        int n39 = nArray4[n38];
                        int n40 = nArray6[n21 + n39];
                        int n41 = nArray6[n22 + n39];
                        int n42 = nArray6[n23 + n39];
                        int n43 = nArray6[n24 + n39];
                        int n44 = nArray6[n25 + n39];
                        int n45 = nArray6[n26 + n39];
                        int n46 = nArray6[n27 + n39];
                        int n47 = nArray6[n28 + n39];
                        int n48 = nArray6[n29 + n39];
                        int n49 = nArray6[n30 + n39];
                        int n50 = nArray6[n31 + n39];
                        int n51 = nArray6[n32 + n39];
                        int n52 = nArray6[n33 + n39];
                        int n53 = nArray6[n34 + n39];
                        int n54 = nArray6[n35 + n39];
                        int n55 = nArray6[n36 + n39];
                        int n56 = (int)(f8 * (float)this.shiftvalue);
                        int n57 = (int)(f9 * (float)this.shiftvalue);
                        float f10 = this.interp.interpolate(n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57);
                        int n58 = f10 < -2.1474836E9f ? Integer.MIN_VALUE : (f10 > 2.1474836E9f ? Integer.MAX_VALUE : ((double)f10 > 0.0 ? (int)(f10 + 0.5f) : (int)(f10 - 0.5f)));
                        nArray[n38][n16 + nArray2[n38]] = n58;
                        ++n38;
                    }
                } else if (this.setBackground) {
                    n38 = 0;
                    while (n38 < n9) {
                        nArray[n38][n16 + nArray2[n38]] = nArray5[n38];
                        ++n38;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    if ((f8 = (float)((double)f8 + this.fracdx)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    if ((f9 = (float)((double)f9 + this.fracdy)) == 1.0f) {
                        f9 = 0.999999f;
                    }
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n21 = n19 + n20 - n8 - n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n23 + n7;
                n25 = n21 + n8;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n27 + n7;
                n29 = n25 + n8;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n31 + n7;
                n33 = n29 + n8;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n36 = n35 + n7;
                n16 += n5;
                ++n37;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        int n14 = 0;
        while (n14 < n9) {
            sArray3[n14] = (short)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n19 + n20 - n8 - n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n23 + n7;
            int n25 = n21 + n8;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n27 + n7;
            int n29 = n25 + n8;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n31 + n7;
            int n33 = n29 + n8;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n35 + n7;
            int n37 = n10;
            while (n37 < n12) {
                int n38;
                if ((float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f && (float)n18 >= f3 + 1.0f && (float)n18 < f5 - 2.0f) {
                    n38 = 0;
                    while (n38 < n9) {
                        short[] sArray4 = sArray2[n38];
                        int n39 = nArray2[n38];
                        short s2 = sArray4[n21 + n39];
                        short s3 = sArray4[n22 + n39];
                        short s4 = sArray4[n23 + n39];
                        short s5 = sArray4[n24 + n39];
                        short s6 = sArray4[n25 + n39];
                        short s7 = sArray4[n26 + n39];
                        short s8 = sArray4[n27 + n39];
                        short s9 = sArray4[n28 + n39];
                        short s10 = sArray4[n29 + n39];
                        short s11 = sArray4[n30 + n39];
                        short s12 = sArray4[n31 + n39];
                        short s13 = sArray4[n32 + n39];
                        short s14 = sArray4[n33 + n39];
                        short s15 = sArray4[n34 + n39];
                        short s16 = sArray4[n35 + n39];
                        short s17 = sArray4[n36 + n39];
                        int n40 = (int)(f8 * (float)this.shiftvalue);
                        int n41 = (int)(f9 * (float)this.shiftvalue);
                        float f10 = this.interp.interpolate(s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, n40, n41);
                        int n42 = f10 < -32768.0f ? Short.MIN_VALUE : (f10 > 32767.0f ? Short.MAX_VALUE : ((double)f10 > 0.0 ? (int)((short)(f10 + 0.5f)) : (int)((short)(f10 - 0.5f))));
                        sArray[n38][n16 + nArray[n38]] = n42;
                        ++n38;
                    }
                } else if (this.setBackground) {
                    n38 = 0;
                    while (n38 < n9) {
                        sArray[n38][n16 + nArray[n38]] = sArray3[n38];
                        ++n38;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    if ((f8 = (float)((double)f8 + this.fracdx)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    if ((f9 = (float)((double)f9 + this.fracdy)) == 1.0f) {
                        f9 = 0.999999f;
                    }
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n21 = n19 + n20 - n8 - n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n23 + n7;
                n25 = n21 + n8;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n27 + n7;
                n29 = n25 + n8;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n31 + n7;
                n33 = n29 + n8;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n36 = n35 + n7;
                n16 += n5;
                ++n37;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        int n14 = 0;
        while (n14 < n9) {
            sArray3[n14] = (short)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n19 + n20 - n8 - n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n23 + n7;
            int n25 = n21 + n8;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n27 + n7;
            int n29 = n25 + n8;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n31 + n7;
            int n33 = n29 + n8;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n35 + n7;
            int n37 = n10;
            while (n37 < n12) {
                int n38;
                if ((float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f && (float)n18 >= f3 + 1.0f && (float)n18 < f5 - 2.0f) {
                    n38 = 0;
                    while (n38 < n9) {
                        short[] sArray4 = sArray2[n38];
                        int n39 = nArray2[n38];
                        int n40 = sArray4[n21 + n39] & 0xFFFF;
                        int n41 = sArray4[n22 + n39] & 0xFFFF;
                        int n42 = sArray4[n23 + n39] & 0xFFFF;
                        int n43 = sArray4[n24 + n39] & 0xFFFF;
                        int n44 = sArray4[n25 + n39] & 0xFFFF;
                        int n45 = sArray4[n26 + n39] & 0xFFFF;
                        int n46 = sArray4[n27 + n39] & 0xFFFF;
                        int n47 = sArray4[n28 + n39] & 0xFFFF;
                        int n48 = sArray4[n29 + n39] & 0xFFFF;
                        int n49 = sArray4[n30 + n39] & 0xFFFF;
                        int n50 = sArray4[n31 + n39] & 0xFFFF;
                        int n51 = sArray4[n32 + n39] & 0xFFFF;
                        int n52 = sArray4[n33 + n39] & 0xFFFF;
                        int n53 = sArray4[n34 + n39] & 0xFFFF;
                        int n54 = sArray4[n35 + n39] & 0xFFFF;
                        int n55 = sArray4[n36 + n39] & 0xFFFF;
                        int n56 = (int)(f8 * (float)this.shiftvalue);
                        int n57 = (int)(f9 * (float)this.shiftvalue);
                        float f10 = this.interp.interpolate(n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57);
                        int n58 = (double)f10 < 0.0 ? 0 : (f10 > 65535.0f ? 65535 : (int)(f10 + 0.5f));
                        sArray[n38][n16 + nArray[n38]] = (short)(n58 & 0xFFFF);
                        ++n38;
                    }
                } else if (this.setBackground) {
                    n38 = 0;
                    while (n38 < n9) {
                        sArray[n38][n16 + nArray[n38]] = sArray3[n38];
                        ++n38;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    if ((f8 = (float)((double)f8 + this.fracdx)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    if ((f9 = (float)((double)f9 + this.fracdy)) == 1.0f) {
                        f9 = 0.999999f;
                    }
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n21 = n19 + n20 - n8 - n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n23 + n7;
                n25 = n21 + n8;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n27 + n7;
                n29 = n25 + n8;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n31 + n7;
                n33 = n29 + n8;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n36 = n35 + n7;
                n16 += n5;
                ++n37;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n9];
        int n14 = 0;
        while (n14 < n9) {
            fArray3[n14] = (float)this.backgroundValues[n14];
            ++n14;
        }
        int n15 = n11;
        while (n15 < n13) {
            int n16 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n15 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            f6 = (float)((double)f6 - 0.5);
            f7 = (float)((double)f7 - 0.5);
            int n17 = (int)Math.floor(f6);
            int n18 = (int)Math.floor(f7);
            float f8 = f6 - (float)n17;
            float f9 = f7 - (float)n18;
            int n19 = (n17 - n2) * n7;
            int n20 = (n18 - n3) * n8;
            int n21 = n19 + n20 - n8 - n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n23 + n7;
            int n25 = n21 + n8;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n27 + n7;
            int n29 = n25 + n8;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n31 + n7;
            int n33 = n29 + n8;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n35 + n7;
            int n37 = n10;
            while (n37 < n12) {
                int n38;
                if ((float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f && (float)n18 >= f3 + 1.0f && (float)n18 < f5 - 2.0f) {
                    n38 = 0;
                    while (n38 < n9) {
                        float f10;
                        float[] fArray4 = fArray2[n38];
                        int n39 = nArray2[n38];
                        float f11 = fArray4[n21 + n39];
                        float f12 = fArray4[n22 + n39];
                        float f13 = fArray4[n23 + n39];
                        float f14 = fArray4[n24 + n39];
                        float f15 = fArray4[n25 + n39];
                        float f16 = fArray4[n26 + n39];
                        float f17 = fArray4[n27 + n39];
                        float f18 = fArray4[n28 + n39];
                        float f19 = fArray4[n29 + n39];
                        float f20 = fArray4[n30 + n39];
                        float f21 = fArray4[n31 + n39];
                        float f22 = fArray4[n32 + n39];
                        float f23 = fArray4[n33 + n39];
                        float f24 = fArray4[n34 + n39];
                        float f25 = fArray4[n35 + n39];
                        float f26 = fArray4[n36 + n39];
                        fArray[n38][n16 + nArray[n38]] = f10 = this.interp.interpolate(f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24, f25, f26, f8, f9);
                        ++n38;
                    }
                } else if (this.setBackground) {
                    n38 = 0;
                    while (n38 < n9) {
                        fArray[n38][n16 + nArray[n38]] = fArray3[n38];
                        ++n38;
                    }
                }
                if ((double)f8 < this.fracdx1) {
                    n17 += this.incx;
                    if ((f8 = (float)((double)f8 + this.fracdx)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n17 += this.incx1;
                    f8 = (float)((double)f8 - this.fracdx1);
                }
                if ((double)f9 < this.fracdy1) {
                    n18 += this.incy;
                    if ((f9 = (float)((double)f9 + this.fracdy)) == 1.0f) {
                        f9 = 0.999999f;
                    }
                } else {
                    n18 += this.incy1;
                    f9 = (float)((double)f9 - this.fracdy1);
                }
                n19 = (n17 - n2) * n7;
                n20 = (n18 - n3) * n8;
                n21 = n19 + n20 - n8 - n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n23 + n7;
                n25 = n21 + n8;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n27 + n7;
                n29 = n25 + n8;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n31 + n7;
                n33 = n29 + n8;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n36 = n35 + n7;
                n16 += n5;
                ++n37;
            }
            n4 += n6;
            ++n15;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2) {
        float f2 = rasterAccessor.getX();
        float f3 = rasterAccessor.getY();
        float f4 = f2 + (float)rasterAccessor.getWidth();
        float f5 = f3 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int n14 = n11;
        while (n14 < n13) {
            int n15 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d2 = ((Point2D)float_2).getX();
            double d3 = ((Point2D)float_2).getY();
            int n16 = (int)Math.floor(d2 -= 0.5);
            int n17 = (int)Math.floor(d3 -= 0.5);
            double d4 = d2 - (double)n16;
            double d5 = d3 - (double)n17;
            int n18 = (n16 - n2) * n7;
            int n19 = (n17 - n3) * n8;
            int n20 = n18 + n19 - n8 - n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n22 + n7;
            int n24 = n20 + n8;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n26 + n7;
            int n28 = n24 + n8;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n30 + n7;
            int n32 = n28 + n8;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            int n35 = n34 + n7;
            int n36 = n10;
            while (n36 < n12) {
                int n37;
                if ((float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f && (float)n17 >= f3 + 1.0f && (float)n17 < f5 - 2.0f) {
                    n37 = 0;
                    while (n37 < n9) {
                        double d6;
                        double[] dArray3 = dArray2[n37];
                        int n38 = nArray2[n37];
                        double d7 = dArray3[n20 + n38];
                        double d8 = dArray3[n21 + n38];
                        double d9 = dArray3[n22 + n38];
                        double d10 = dArray3[n23 + n38];
                        double d11 = dArray3[n24 + n38];
                        double d12 = dArray3[n25 + n38];
                        double d13 = dArray3[n26 + n38];
                        double d14 = dArray3[n27 + n38];
                        double d15 = dArray3[n28 + n38];
                        double d16 = dArray3[n29 + n38];
                        double d17 = dArray3[n30 + n38];
                        double d18 = dArray3[n31 + n38];
                        double d19 = dArray3[n32 + n38];
                        double d20 = dArray3[n33 + n38];
                        double d21 = dArray3[n34 + n38];
                        double d22 = dArray3[n35 + n38];
                        dArray[n37][n15 + nArray[n37]] = d6 = this.interp.interpolate(d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22, (float)d4, (float)d5);
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n9) {
                        dArray[n37][n15 + nArray[n37]] = this.backgroundValues[n37];
                        ++n37;
                    }
                }
                if (d4 < this.fracdx1) {
                    n16 += this.incx;
                    if ((d4 += this.fracdx) == 1.0) {
                        d4 = 0.999999;
                    }
                } else {
                    n16 += this.incx1;
                    d4 -= this.fracdx1;
                }
                if (d5 < this.fracdy1) {
                    n17 += this.incy;
                    if ((d5 += this.fracdy) == 1.0) {
                        d5 = 0.999999;
                    }
                } else {
                    n17 += this.incy1;
                    d5 -= this.fracdy1;
                }
                n18 = (n16 - n2) * n7;
                n19 = (n17 - n3) * n8;
                n20 = n18 + n19 - n8 - n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n22 + n7;
                n24 = n20 + n8;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n26 + n7;
                n28 = n24 + n8;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n30 + n7;
                n32 = n28 + n8;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n35 = n34 + n7;
                n15 += n5;
                ++n36;
            }
            n4 += n6;
            ++n14;
        }
    }
}

