/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class AddOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;
    private boolean areBinarySampleModels = false;

    public AddOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        if (ImageUtil.isBinary(this.getSampleModel()) && ImageUtil.isBinary(renderedImage.getSampleModel()) && ImageUtil.isBinary(renderedImage2.getSampleModel())) {
            this.areBinarySampleModels = true;
        } else {
            SampleModel sampleModel;
            int n2;
            int n3 = renderedImage.getSampleModel().getNumBands();
            int n4 = renderedImage2.getSampleModel().getNumBands();
            if (imageLayout != null && imageLayout.isValid(256) && (n2 = (sampleModel = imageLayout.getSampleModel(null)).getNumBands()) > 1 && (n3 == 1 && n4 > 1 || n4 == 1 && n3 > 1)) {
                n2 = Math.min(Math.max(n3, n4), n2);
                if (n2 != this.sampleModel.getNumBands()) {
                    this.sampleModel = RasterFactory.createComponentSampleModel(sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n2);
                    if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                        this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
                    }
                }
                this.s1bd = n3 == 1 ? 0 : 1;
                this.s2bd = n4 == 1 ? 0 : 1;
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor;
        RasterAccessor rasterAccessor2;
        RasterAccessor rasterAccessor3;
        RasterFormatTag[] rasterFormatTagArray;
        if (this.areBinarySampleModels) {
            rasterFormatTagArray = this.getFormatTags();
            rasterAccessor3 = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
            rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
            rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
            if (rasterAccessor.isBinary()) {
                byte[] byArray = rasterAccessor3.getBinaryDataArray();
                byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
                byte[] byArray3 = rasterAccessor.getBinaryDataArray();
                int n2 = byArray3.length;
                int n3 = 0;
                while (n3 < n2) {
                    byArray3[n3] = (byte)(byArray[n3] | byArray2[n3]);
                    ++n3;
                }
                rasterAccessor.copyBinaryDataToRaster();
                return;
            }
        }
        rasterFormatTagArray = this.getFormatTags();
        rasterAccessor3 = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor3, rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor3, rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor3, rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor3, rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor3, rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor3, rasterAccessor2, rasterAccessor);
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n8) {
            byte[] byArray4 = byArray[n12];
            byte[] byArray5 = byArray2[n13];
            byte[] byArray6 = byArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n7) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n2;
                n15 += n4;
                n16 += n9;
                int n21 = 0;
                int n22 = 0;
                while (n22 < n6) {
                    n21 = (byArray4[n18] & 0xFF) + (byArray5[n19] & 0xFF);
                    byArray6[n20] = (byte)((n21 << 23 >> 31 | n21) & 0xFF);
                    n18 += n3;
                    n19 += n5;
                    n20 += n10;
                    ++n22;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n8) {
            short[] sArray4 = sArray[n12];
            short[] sArray5 = sArray2[n13];
            short[] sArray6 = sArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n7) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n2;
                n15 += n4;
                n16 += n9;
                int n21 = 0;
                while (n21 < n6) {
                    sArray6[n20] = ImageUtil.clampUShortPositive((sArray4[n18] & 0xFFFF) + (sArray5[n19] & 0xFFFF));
                    n18 += n3;
                    n19 += n5;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n8) {
            short[] sArray4 = sArray[n12];
            short[] sArray5 = sArray2[n13];
            short[] sArray6 = sArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n7) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n2;
                n15 += n4;
                n16 += n9;
                int n21 = 0;
                while (n21 < n6) {
                    sArray6[n20] = ImageUtil.clampShort(sArray4[n18] + sArray5[n19]);
                    n18 += n3;
                    n19 += n5;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray5 = rasterAccessor3.getBandOffsets();
        int[][] nArray6 = rasterAccessor3.getIntDataArrays();
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n11 < n8) {
                    int[] nArray7 = nArray2[n12];
                    int[] nArray8 = nArray4[n13];
                    int[] nArray9 = nArray6[n11];
                    int n14 = nArray[n12];
                    int n15 = nArray3[n13];
                    int n16 = nArray5[n11];
                    int n17 = 0;
                    while (n17 < n7) {
                        int n18 = n14;
                        int n19 = n15;
                        int n20 = n16;
                        n14 += n2;
                        n15 += n4;
                        n16 += n9;
                        int n21 = 0;
                        int n22 = 0;
                        while (n22 < n6) {
                            n21 = (nArray7[n18] & 0xFF) + (nArray8[n19] & 0xFF);
                            nArray9[n20] = (n21 << 23 >> 31 | n21) & 0xFF;
                            n18 += n3;
                            n19 += n5;
                            n20 += n10;
                            ++n22;
                        }
                        ++n17;
                    }
                    ++n11;
                    n12 += this.s1bd;
                    n13 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n23 = 0;
                int n24 = 0;
                int n25 = 0;
                while (n23 < n8) {
                    int[] nArray10 = nArray2[n24];
                    int[] nArray11 = nArray4[n25];
                    int[] nArray12 = nArray6[n23];
                    int n26 = nArray[n24];
                    int n27 = nArray3[n25];
                    int n28 = nArray5[n23];
                    int n29 = 0;
                    while (n29 < n7) {
                        int n30 = n26;
                        int n31 = n27;
                        int n32 = n28;
                        n26 += n2;
                        n27 += n4;
                        n28 += n9;
                        int n33 = 0;
                        while (n33 < n6) {
                            nArray12[n32] = ImageUtil.clampUShortPositive((nArray10[n30] & 0xFFFF) + (nArray11[n31] & 0xFFFF));
                            n30 += n3;
                            n31 += n5;
                            n32 += n10;
                            ++n33;
                        }
                        ++n29;
                    }
                    ++n23;
                    n24 += this.s1bd;
                    n25 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n34 = 0;
                int n35 = 0;
                int n36 = 0;
                while (n34 < n8) {
                    int[] nArray13 = nArray2[n35];
                    int[] nArray14 = nArray4[n36];
                    int[] nArray15 = nArray6[n34];
                    int n37 = nArray[n35];
                    int n38 = nArray3[n36];
                    int n39 = nArray5[n34];
                    int n40 = 0;
                    while (n40 < n7) {
                        int n41 = n37;
                        int n42 = n38;
                        int n43 = n39;
                        n37 += n2;
                        n38 += n4;
                        n39 += n9;
                        int n44 = 0;
                        while (n44 < n6) {
                            nArray15[n43] = ImageUtil.clampShort(nArray13[n41] + nArray14[n42]);
                            n41 += n3;
                            n42 += n5;
                            n43 += n10;
                            ++n44;
                        }
                        ++n40;
                    }
                    ++n34;
                    n35 += this.s1bd;
                    n36 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n45 = 0;
                int n46 = 0;
                int n47 = 0;
                while (n45 < n8) {
                    int[] nArray16 = nArray2[n46];
                    int[] nArray17 = nArray4[n47];
                    int[] nArray18 = nArray6[n45];
                    int n48 = nArray[n46];
                    int n49 = nArray3[n47];
                    int n50 = nArray5[n45];
                    int n51 = 0;
                    while (n51 < n7) {
                        int n52 = n48;
                        int n53 = n49;
                        int n54 = n50;
                        n48 += n2;
                        n49 += n4;
                        n50 += n9;
                        int n55 = 0;
                        while (n55 < n6) {
                            nArray18[n54] = ImageUtil.clampInt((long)nArray16[n52] + (long)nArray17[n53]);
                            n52 += n3;
                            n53 += n5;
                            n54 += n10;
                            ++n55;
                        }
                        ++n51;
                    }
                    ++n45;
                    n46 += this.s1bd;
                    n47 += this.s2bd;
                }
                break;
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        float[][] fArray3 = rasterAccessor3.getFloatDataArrays();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n8) {
            float[] fArray4 = fArray[n12];
            float[] fArray5 = fArray2[n13];
            float[] fArray6 = fArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n7) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n2;
                n15 += n4;
                n16 += n9;
                int n21 = 0;
                while (n21 < n6) {
                    fArray6[n20] = fArray4[n18] + fArray5[n19];
                    n18 += n3;
                    n19 += n5;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getNumBands();
        int n9 = rasterAccessor3.getScanlineStride();
        int n10 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        double[][] dArray3 = rasterAccessor3.getDoubleDataArrays();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n11 < n8) {
            double[] dArray4 = dArray[n12];
            double[] dArray5 = dArray2[n13];
            double[] dArray6 = dArray3[n11];
            int n14 = nArray[n12];
            int n15 = nArray2[n13];
            int n16 = nArray3[n11];
            int n17 = 0;
            while (n17 < n7) {
                int n18 = n14;
                int n19 = n15;
                int n20 = n16;
                n14 += n2;
                n15 += n4;
                n16 += n9;
                int n21 = 0;
                while (n21 < n6) {
                    dArray6[n20] = dArray4[n18] + dArray5[n19];
                    n18 += n3;
                    n19 += n5;
                    n20 += n10;
                    ++n21;
                }
                ++n17;
            }
            ++n11;
            n12 += this.s1bd;
            n13 += this.s2bd;
        }
    }
}

