/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibScaleBicubicOpImage;
import com.sun.media.jai.mlib.MlibScaleBilinearOpImage;
import com.sun.media.jai.mlib.MlibScaleNearestOpImage;
import com.sun.media.jai.mlib.MlibScaleTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;

public class MlibTranslateRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(2);
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (Math.abs(f2 - (float)((int)f2)) < 0.01f && Math.abs(f3 - (float)((int)f3)) < 0.01f && imageLayout == null) {
            return new TranslateIntOpImage(renderedImage, renderingHints, (int)f2, (int)f3);
        }
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout) || renderedImage.getTileWidth() >= 32768 || renderedImage.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (interpolation instanceof InterpolationNearest) {
            return new MlibScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibScaleTableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f4, f5, f2, f3, interpolation);
        }
        return null;
    }
}

