/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibThresholdOpImage
extends PointOpImage {
    private double[] low;
    private int[] lowInt;
    private double[] high;
    private int[] highInt;
    private double[] constants;
    private int[] constantsInt;

    public MlibThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.getSampleModel().getNumBands();
        this.low = new double[n2];
        this.lowInt = new int[n2];
        this.high = new double[n2];
        this.highInt = new int[n2];
        this.constants = new double[n2];
        this.constantsInt = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.low[n3] = dArray.length < n2 ? dArray[0] : dArray[n3];
            this.lowInt[n3] = ImageUtil.clampInt((int)Math.ceil(this.low[n3]));
            this.high[n3] = dArray2.length < n2 ? dArray2[0] : dArray2[n3];
            this.highInt[n3] = ImageUtil.clampInt((int)Math.floor(this.high[n3]));
            this.constants[n3] = dArray3.length < n2 ? dArray3[0] : dArray3[n3];
            this.constantsInt[n3] = ImageUtil.clampRoundInt(this.constants[n3]);
            ++n3;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    int[] nArray = mediaLibAccessor2.getIntParameters(n3, this.lowInt);
                    int[] nArray2 = mediaLibAccessor2.getIntParameters(n3, this.highInt);
                    int[] nArray3 = mediaLibAccessor2.getIntParameters(n3, this.constantsInt);
                    Image.Thresh5((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int[])nArray2, (int[])nArray, (int[])nArray3);
                    ++n3;
                }
                break;
            }
            case 4: 
            case 5: {
                int n4 = 0;
                while (n4 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n4, this.low);
                    double[] dArray2 = mediaLibAccessor2.getDoubleParameters(n4, this.high);
                    double[] dArray3 = mediaLibAccessor2.getDoubleParameters(n4, this.constants);
                    Image.Thresh5_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (double[])dArray2, (double[])dArray, (double[])dArray3);
                    ++n4;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

