/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibSubtractFromConstOpImage
extends PointOpImage {
    private double[] constants;

    public MlibSubtractFromConstOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray) {
        super(renderedImage, imageLayout, map, true);
        this.constants = MlibUtils.initConstants(dArray, this.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[this.constants.length];
                int n3 = 0;
                while (n3 < this.constants.length) {
                    nArray[n3] = ImageUtil.clampRoundInt(this.constants[n3]);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < mediaLibImageArray2.length) {
                    int[] nArray2 = mediaLibAccessor2.getIntParameters(n4, nArray);
                    Image.ConstSub((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int[])nArray2);
                    ++n4;
                }
                break;
            }
            case 4: 
            case 5: {
                int n5 = 0;
                while (n5 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n5, this.constants);
                    Image.ConstSub_Fp((mediaLibImage)mediaLibImageArray2[n5], (mediaLibImage)mediaLibImageArray[n5], (double[])dArray);
                    ++n5;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(string + JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

