/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibOrderedDitherOpImage
extends PointOpImage {
    private static final int DMASK_SCALE_EXPONENT = 16;
    protected mediaLibImageColormap mlibColormap;
    protected int[][] dmask;
    protected int dmaskWidth;
    protected int dmaskHeight;
    protected int dmaskScale;

    static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (colorCube.getNumBands() == 1 && colorCube.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n2 = colorCube.getNumEntries();
            byte[][] byArray = new byte[3][256];
            int n3 = 0;
            while (n3 < 3) {
                byte[] byArray2 = byArray[n3];
                byte[] byArray3 = colorCube.getByteData(n3);
                int n4 = colorCube.getOffset(n3);
                int n5 = n4 + n2;
                int n6 = 0;
                while (n6 < n4) {
                    byArray2[n6] = 0;
                    ++n6;
                }
                int n7 = n4;
                while (n7 < n5) {
                    byArray2[n7] = byArray3[n7 - n4];
                    ++n7;
                }
                int n8 = n5;
                while (n8 < 256) {
                    byArray2[n8] = -1;
                    ++n8;
                }
                ++n3;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public MlibOrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, MlibOrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.mlibColormap = Image.ColorDitherInit((int[])colorCube.getDimension(), (int)1, (int)(ImageUtil.isBinary(this.sampleModel) ? 0 : 1), (int)colorCube.getNumBands(), (int)colorCube.getNumEntries(), (int)colorCube.getOffset(), (Object)colorCube.getByteData());
        this.dmaskWidth = kernelJAIArray[0].getWidth();
        this.dmaskHeight = kernelJAIArray[0].getHeight();
        this.dmaskScale = 65536;
        int n2 = kernelJAIArray.length;
        this.dmask = new int[n2][];
        int n3 = 0;
        while (n3 < n2) {
            KernelJAI kernelJAI = kernelJAIArray[n3];
            if (kernelJAI.getWidth() != this.dmaskWidth || kernelJAI.getHeight() != this.dmaskHeight) {
                throw new IllegalArgumentException(JaiI18N.getString("MlibOrderedDitherOpImage0"));
            }
            float[] fArray = kernelJAIArray[n3].getKernelData();
            int n4 = fArray.length;
            this.dmask[n3] = new int[n4];
            int[] nArray = this.dmask[n3];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = (int)(fArray[n5] * (float)this.dmaskScale);
                ++n5;
            }
            ++n3;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2;
        int n3;
        Raster raster = rasterArray[0];
        if (ImageUtil.isBinary(writableRaster.getSampleModel())) {
            n3 = MediaLibAccessor.findCompatibleTag(rasterArray, raster);
            n2 = writableRaster.getSampleModel().getDataType() | 0x100 | 0;
        } else {
            n3 = n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n3, false);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2, true);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        Image.ColorOrderedDitherMxN((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0], (int[][])this.dmask, (int)this.dmaskWidth, (int)this.dmaskHeight, (int)16, (mediaLibImageColormap)this.mlibColormap);
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

