/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.TreeMap;
import javax.media.jai.Histogram;
import javax.media.jai.StatisticsOpImage;

final class MlibHistogramOpImage
extends StatisticsOpImage {
    private int[] numBins;
    private double[] lowValueFP;
    private double[] highValueFP;
    private int[] lowValue;
    private int[] highValue;
    private int numBands = this.sampleModel.getNumBands();
    private int[] bandIndexMap;
    private boolean reorderBands = false;

    public MlibHistogramOpImage(RenderedImage renderedImage, int n2, int n3, int[] nArray, double[] dArray, double[] dArray2) {
        super(renderedImage, null, renderedImage.getMinX(), renderedImage.getMinY(), n2, n3);
        this.numBins = new int[this.numBands];
        this.lowValueFP = new double[this.numBands];
        this.highValueFP = new double[this.numBands];
        int n4 = 0;
        while (n4 < this.numBands) {
            this.numBins[n4] = nArray.length == 1 ? nArray[0] : nArray[n4];
            this.lowValueFP[n4] = dArray.length == 1 ? dArray[0] : dArray[n4];
            this.highValueFP[n4] = dArray2.length == 1 ? dArray2[0] : dArray2[n4];
            ++n4;
        }
        this.lowValue = new int[this.lowValueFP.length];
        int n5 = 0;
        while (n5 < this.lowValueFP.length) {
            this.lowValue[n5] = (int)Math.ceil(this.lowValueFP[n5]);
            ++n5;
        }
        this.highValue = new int[this.highValueFP.length];
        int n6 = 0;
        while (n6 < this.highValueFP.length) {
            this.highValue[n6] = (int)Math.ceil(this.highValueFP[n6]);
            ++n6;
        }
        if (this.numBands > 1) {
            int n7;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
            int[] nArray2 = componentSampleModel.getBankIndices();
            boolean bl = false;
            int n8 = 1;
            while (n8 < this.numBands) {
                if (nArray2[n8] != nArray2[n8 - 1]) {
                    bl = true;
                    break;
                }
                ++n8;
            }
            if (bl) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    treeMap.put(new Integer(nArray2[n9]), new Integer(n9));
                    ++n9;
                }
                this.bandIndexMap = new int[this.numBands];
                Iterator iterator = treeMap.keySet().iterator();
                int n10 = 0;
                while (iterator.hasNext()) {
                    n7 = (Integer)treeMap.get(iterator.next());
                    if (n7 != n10) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n10++] = n7;
                }
            }
            if (!this.reorderBands) {
                treeMap.clear();
                if (this.bandIndexMap == null) {
                    this.bandIndexMap = new int[this.numBands];
                }
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int n11 = 0;
                while (n11 < this.numBands) {
                    treeMap.put(new Integer(nArray3[n11]), new Integer(n11));
                    ++n11;
                }
                Iterator iterator = treeMap.keySet().iterator();
                n7 = 0;
                while (iterator.hasNext()) {
                    int n12 = (Integer)treeMap.get(iterator.next());
                    if (n12 != n7) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n7++] = n12;
                }
            }
        }
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return new Histogram(this.numBins, this.lowValueFP, this.highValueFP);
        }
        return Image.UndefinedProperty;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        int n2;
        Object object2;
        Histogram histogram = (Histogram)object;
        int n3 = histogram.getNumBands();
        int[][] nArray = histogram.getBins();
        Rectangle rectangle = raster.getBounds();
        if (!this.reorderBands && rectangle.equals(this.getBounds())) {
            object2 = nArray;
        } else {
            object2 = new int[n3][];
            n2 = 0;
            while (n2 < n3) {
                object2[n2] = new int[histogram.getNumBins(n2)];
                ++n2;
            }
        }
        n2 = MediaLibAccessor.findCompatibleTag(null, raster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int n4 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
        int n5 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
        if (object2 == nArray) {
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n4, (int)n5, (int)this.xPeriod, (int)this.yPeriod);
            }
        }
        com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n4, (int)n5, (int)this.xPeriod, (int)this.yPeriod);
        Histogram histogram3 = histogram;
        synchronized (histogram3) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = object2[n6].length;
                int[] nArray2 = this.reorderBands ? nArray[this.bandIndexMap[n6]] : nArray[n6];
                int[] nArray3 = object2[n6];
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = n8;
                    nArray2[n9] = nArray2[n9] + nArray3[n8];
                    ++n8;
                }
                ++n6;
            }
        }
    }
}

