/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.UntiledOpImage;

final class MlibErrorDiffusionOpImage
extends UntiledOpImage {
    private static final int KERNEL_SCALE_EXPONENT = 16;
    protected mediaLibImageColormap mlibColormap;
    protected int[] kernel;
    protected int kernelWidth;
    protected int kernelHeight;
    protected int kernelKeyX;
    protected int kernelKeyY;
    protected int kernelScale;

    static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, LookupTableJAI lookupTableJAI) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        imageLayout2.setWidth(renderedImage.getWidth());
        imageLayout2.setHeight(renderedImage.getHeight());
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (lookupTableJAI.getNumBands() == 1 && lookupTableJAI.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && sampleModel.getDataType() == 0 && lookupTableJAI.getDataType() == 0 && lookupTableJAI.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n2 = lookupTableJAI.getNumEntries();
            byte[][] byArray = new byte[3][256];
            int n3 = 0;
            while (n3 < 3) {
                byte[] byArray2 = byArray[n3];
                byte[] byArray3 = lookupTableJAI.getByteData(n3);
                int n4 = lookupTableJAI.getOffset(n3);
                int n5 = n4 + n2;
                int n6 = 0;
                while (n6 < n4) {
                    byArray2[n6] = 0;
                    ++n6;
                }
                int n7 = n4;
                while (n7 < n5) {
                    byArray2[n7] = byArray3[n7 - n4];
                    ++n7;
                }
                int n8 = n5;
                while (n8 < 256) {
                    byArray2[n8] = -1;
                    ++n8;
                }
                ++n3;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public MlibErrorDiffusionOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI, KernelJAI kernelJAI) {
        super(renderedImage, map, imageLayout);
        this.mlibColormap = Image.ColorDitherInit((int[])(lookupTableJAI instanceof ColorCube ? ((ColorCube)lookupTableJAI).getDimension() : null), (int)1, (int)(ImageUtil.isBinary(this.sampleModel) ? 0 : 1), (int)lookupTableJAI.getNumBands(), (int)lookupTableJAI.getNumEntries(), (int)lookupTableJAI.getOffset(), (Object)lookupTableJAI.getByteData());
        this.kernelWidth = kernelJAI.getWidth();
        this.kernelHeight = kernelJAI.getHeight();
        this.kernelKeyX = kernelJAI.getXOrigin();
        this.kernelKeyY = kernelJAI.getYOrigin();
        this.kernelScale = 65536;
        float[] fArray = kernelJAI.getKernelData();
        int n2 = fArray.length;
        this.kernel = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.kernel[n3] = (int)(fArray[n3] * (float)this.kernelScale);
            ++n3;
        }
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n2;
        int n3;
        Raster raster = rasterArray[0];
        if (ImageUtil.isBinary(writableRaster.getSampleModel())) {
            n3 = MediaLibAccessor.findCompatibleTag(rasterArray, raster);
            n2 = writableRaster.getSampleModel().getDataType() | 0x100 | 0;
        } else {
            n3 = n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n3, false);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2, true);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        Image.ColorErrorDiffusionMxN((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0], (int[])this.kernel, (int)this.kernelWidth, (int)this.kernelHeight, (int)this.kernelKeyX, (int)this.kernelKeyY, (int)16, (mediaLibImageColormap)this.mlibColormap);
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

