/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibErode3PlusOpImage;
import com.sun.media.jai.mlib.MlibErode3SquareOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibErodeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        boolean bl = false;
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            if (!MediaLibAccessor.isMediaLibBinaryCompatible(parameterBlock, imageLayout)) {
                return null;
            }
            bl = true;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        KernelJAI kernelJAI = (KernelJAI)parameterBlock.getObjectParameter(0);
        KernelJAI kernelJAI2 = kernelJAI.getRotatedKernel();
        int n2 = kernelJAI2.getWidth();
        int n3 = kernelJAI2.getHeight();
        int n4 = kernelJAI2.getXOrigin();
        int n5 = kernelJAI2.getYOrigin();
        int n6 = renderedImage.getSampleModel().getNumBands();
        if (n4 != 1 || n5 != 1 || n2 != 3 || n3 != 3 || n6 != 1) {
            return null;
        }
        float[] fArray = kernelJAI2.getKernelData();
        if (bl && this.isKernel3Square1(fArray) || !bl && this.isKernel3Square0(fArray)) {
            return new MlibErode3SquareOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout);
        }
        if (bl && this.isKernel3Plus1(fArray)) {
            return new MlibErode3PlusOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout);
        }
        return null;
    }

    private boolean isKernel3Plus1(float[] fArray) {
        return fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 1.0f && fArray[5] == 1.0f && fArray[6] == 0.0f && fArray[7] == 1.0f && fArray[8] == 0.0f;
    }

    private boolean isKernel3Square0(float[] fArray) {
        return fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f && fArray[3] == 0.0f && fArray[4] == 0.0f && fArray[5] == 0.0f && fArray[6] == 0.0f && fArray[7] == 0.0f && fArray[8] == 0.0f;
    }

    private boolean isKernel3Square1(float[] fArray) {
        return fArray[0] == 1.0f && fArray[1] == 1.0f && fArray[2] == 1.0f && fArray[3] == 1.0f && fArray[4] == 1.0f && fArray[5] == 1.0f && fArray[6] == 1.0f && fArray[7] == 1.0f && fArray[8] == 1.0f;
    }
}

