/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;

final class MlibDFTOpImage
extends UntiledOpImage {
    private int DFTMode;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, EnumeratedParameter enumeratedParameter) {
        int n2;
        int n3;
        int n4;
        boolean bl = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        boolean bl2 = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n5 = sampleModel.getNumBands();
        if (bl && n5 != 2 || !bl && n5 != 1) {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage0"));
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n6 = imageLayout2.getWidth(renderedImage);
        int n7 = imageLayout2.getHeight(renderedImage);
        if (n6 == 1 && n7 == 1) {
            n4 = 1;
            n3 = 1;
        } else if (n6 == 1 && n7 > 1) {
            n3 = 1;
            n4 = MathJAI.nextPositivePowerOf2(n7);
        } else if (n6 > 1 && n7 == 1) {
            n3 = MathJAI.nextPositivePowerOf2(n6);
            n4 = 1;
        } else {
            n3 = MathJAI.nextPositivePowerOf2(n6);
            n4 = MathJAI.nextPositivePowerOf2(n7);
        }
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        boolean bl3 = false;
        int n8 = n5;
        if (bl && !bl2) {
            n8 /= 2;
        } else if (!bl && bl2) {
            n8 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n9 = sampleModel2.getNumBands();
        if (n9 != n8) {
            n9 = n8;
            bl3 = true;
        }
        if ((n2 = sampleModel2.getTransferType()) != 4 && n2 != 5) {
            n2 = 4;
            bl3 = true;
        }
        if (bl3) {
            int[] nArray = new int[n9];
            int n10 = 0;
            while (n10 < n9) {
                nArray[n10] = n10;
                ++n10;
            }
            int n11 = n3 * n9;
            sampleModel2 = RasterFactory.createPixelInterleavedSampleModel(n2, n3, n4, n9, n11, nArray);
            imageLayout2.setSampleModel(sampleModel2);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public MlibDFTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, EnumeratedParameter enumeratedParameter, boolean bl, EnumeratedParameter enumeratedParameter2) {
        super(renderedImage, map, MlibDFTOpImage.layoutHelper(imageLayout, renderedImage, enumeratedParameter));
        if (enumeratedParameter2.equals(DFTDescriptor.SCALING_NONE)) {
            this.DFTMode = bl ? 0 : 3;
        } else if (enumeratedParameter2.equals(DFTDescriptor.SCALING_UNITARY)) {
            this.DFTMode = bl ? 2 : 5;
        } else if (enumeratedParameter2.equals(DFTDescriptor.SCALING_DIMENSIONS)) {
            this.DFTMode = bl ? 1 : 4;
        } else {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage1"));
        }
    }

    public static boolean isAcceptableSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return true;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        int[] nArray = componentSampleModel.getBandOffsets();
        return nArray.length == 2 && nArray[1] == nArray[0] + 1;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n2 = MediaLibAccessor.findCompatibleTag(new Raster[]{raster}, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, this.mapDestRect(rectangle, 0), n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n3 = 0;
        while (n3 < mediaLibImageArray2.length) {
            Image.FourierTransform((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int)this.DFTMode);
            ++n3;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

