/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibConvolve3x3Or5x5OpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    float[] kData;
    double[] doublekData;
    int[] intkData;
    int shift = -1;

    public MlibConvolve3x3Or5x5OpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kData = kernelJAI.getKernelData();
        int n2 = this.kw * this.kh;
        this.intkData = new int[n2];
        this.doublekData = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.doublekData[n3] = this.kData[n3];
            ++n3;
        }
    }

    private synchronized void setShift(int n2) {
        if (this.shift == -1) {
            int n3 = MediaLibAccessor.getMediaLibDataType(n2);
            this.shift = Image.ConvKernelConvert((int[])this.intkData, (double[])this.doublekData, (int)this.kw, (int)this.kh, (int)n3);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2, true);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2, true);
        int n3 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n4 = 0;
        while (n4 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.shift == -1) {
                        this.setShift(n2);
                    }
                    if (this.kw == 3) {
                        Image.Conv3x3((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int[])this.intkData, (int)this.shift, (int)((1 << n3) - 1), (int)0);
                        break;
                    }
                    Image.Conv5x5((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int[])this.intkData, (int)this.shift, (int)((1 << n3) - 1), (int)0);
                    break;
                }
                case 4: 
                case 5: {
                    if (this.kw == 3) {
                        Image.Conv3x3_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (double[])this.doublekData, (int)((1 << n3) - 1), (int)0);
                        break;
                    }
                    Image.Conv5x5_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (double[])this.doublekData, (int)((1 << n3) - 1), (int)0);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
            ++n4;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

