/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.OpImage;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

class MlibAffineOpImage
extends GeometricOpImage {
    protected double[] f_transform;
    protected double[] m_transform;
    protected double[] medialib_tr;
    protected AffineTransform transform;
    protected AffineTransform i_transform;
    protected Interpolation interp;
    private Rectangle srcimg;
    private Rectangle padimg;
    protected BorderExtender extender;
    private Rectangle theDest;
    private ImagingListener listener;
    public int lpad;
    public int rpad;
    public int tpad;
    public int bpad;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, AffineTransform affineTransform) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        float f2 = renderedImage.getMinX();
        float f3 = renderedImage.getMinY();
        float f4 = renderedImage.getWidth();
        float f5 = renderedImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2, f3), new Point2D.Float(f2 + f4, f3), new Point2D.Float(f2 + f4, f3 + f5), new Point2D.Float(f2, f3 + f5)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f6 = Float.MAX_VALUE;
        float f7 = Float.MAX_VALUE;
        float f8 = -3.4028235E38f;
        float f9 = -3.4028235E38f;
        int n2 = 0;
        while (n2 < 4) {
            float f10 = (float)point2DArray[n2].getX();
            float f11 = (float)point2DArray[n2].getY();
            f6 = Math.min(f6, f10);
            f7 = Math.min(f7, f11);
            f8 = Math.max(f8, f10);
            f9 = Math.max(f9, f11);
            ++n2;
        }
        int n3 = (int)(f8 - f6);
        int n4 = (int)(f9 - f7);
        int n5 = (int)Math.floor(f6);
        int n6 = (double)Math.abs(f6 - (float)n5) <= 0.5 ? n5 : (int)Math.ceil(f6);
        int n7 = (int)Math.floor(f7);
        int n8 = (double)Math.abs(f7 - (float)n7) <= 0.5 ? n7 : (int)Math.ceil(f7);
        imageLayout2.setMinX(n6);
        imageLayout2.setMinY(n8);
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        return imageLayout2;
    }

    public MlibAffineOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, BorderExtender borderExtender, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(OpImage.vectorize(renderedImage), MlibAffineOpImage.layoutHelper(imageLayout, renderedImage, affineTransform), map, true, borderExtender, interpolation, dArray);
        this.interp = interpolation;
        this.extender = borderExtender;
        this.listener = ImageUtil.getImagingListener((RenderingHints)map);
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        this.srcimg = new Rectangle(this.getSourceImage(0).getMinX(), this.getSourceImage(0).getMinY(), this.getSourceImage(0).getWidth(), this.getSourceImage(0).getHeight());
        this.padimg = new Rectangle(this.srcimg.x - this.lpad, this.srcimg.y - this.tpad, this.srcimg.width + this.lpad + this.rpad, this.srcimg.height + this.tpad + this.bpad);
        if (borderExtender == null) {
            float f2 = this.srcimg.x;
            float f3 = this.srcimg.y;
            float f4 = this.srcimg.width;
            float f5 = this.srcimg.height;
            float f6 = this.lpad;
            float f7 = this.rpad;
            float f8 = this.tpad;
            float f9 = this.bpad;
            if (interpolation instanceof InterpolationBilinear || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
                f6 = (float)((double)f6 + 0.5);
                f8 = (float)((double)f8 + 0.5);
                f7 = (float)((double)f7 + 0.5);
                f9 = (float)((double)f9 + 0.5);
            }
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2 += f6, f3 += f8), new Point2D.Float(f2 + (f4 -= f6 + f7), f3), new Point2D.Float(f2 + f4, f3 + (f5 -= f8 + f9)), new Point2D.Float(f2, f3 + f5)};
            affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
            float f10 = Float.MAX_VALUE;
            float f11 = Float.MAX_VALUE;
            float f12 = -3.4028235E38f;
            float f13 = -3.4028235E38f;
            int n2 = 0;
            while (n2 < 4) {
                float f14 = (float)point2DArray[n2].getX();
                float f15 = (float)point2DArray[n2].getY();
                f10 = Math.min(f10, f14);
                f11 = Math.min(f11, f15);
                f12 = Math.max(f12, f14);
                f13 = Math.max(f13, f15);
                ++n2;
            }
            int n3 = (int)Math.ceil(f10);
            int n4 = (int)Math.ceil(f11);
            int n5 = (int)Math.floor(f12);
            int n6 = (int)Math.floor(f13);
            this.theDest = new Rectangle(n3, n4, n5 - n3, n6 - n4);
        } else {
            this.theDest = this.getBounds();
        }
        try {
            this.i_transform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            String string = JaiI18N.getString("MlibAffineOpImage0");
            this.listener.errorOccurred(string, new ImagingException(string, noninvertibleTransformException), this, false);
        }
        this.transform = (AffineTransform)affineTransform.clone();
        this.f_transform = new double[6];
        affineTransform.getMatrix(this.f_transform);
        this.medialib_tr = new double[6];
        this.medialib_tr[0] = this.f_transform[0];
        this.medialib_tr[1] = this.f_transform[2];
        this.medialib_tr[2] = this.f_transform[4];
        this.medialib_tr[3] = this.f_transform[1];
        this.medialib_tr[4] = this.f_transform[3];
        this.medialib_tr[5] = this.f_transform[5];
        this.m_transform = new double[6];
        this.m_transform[0] = this.f_transform[0];
        this.m_transform[1] = this.f_transform[2];
        this.m_transform[2] = this.f_transform[4];
        this.m_transform[3] = this.f_transform[1];
        this.m_transform[4] = this.f_transform[3];
        this.m_transform[5] = this.f_transform[5];
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D2.getX() + 0.5, point2D2.getY() + 0.5);
        Point2D point2D3 = this.i_transform.transform(point2D2, null);
        point2D3.setLocation(point2D3.getX() - 0.5, point2D3.getY() - 0.5);
        return point2D3;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D2.getX() + 0.5, point2D2.getY() + 0.5);
        Point2D point2D3 = this.transform.transform(point2D2, null);
        point2D3.setLocation(point2D3.getX() - 0.5, point2D3.getY() - 0.5);
        return point2D3;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        return this.transform.createTransformedShape(rectangle).getBounds();
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        float f2 = rectangle.x;
        float f3 = rectangle.y;
        float f4 = rectangle.width;
        float f5 = rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f2, f3), new Point2D.Float(f2 + f4, f3), new Point2D.Float(f2 + f4, f3 + f5), new Point2D.Float(f2, f3 + f5)};
        this.i_transform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f6 = Float.MAX_VALUE;
        float f7 = Float.MAX_VALUE;
        float f8 = -3.4028235E38f;
        float f9 = -3.4028235E38f;
        int n3 = 0;
        while (n3 < 4) {
            float f10 = (float)point2DArray[n3].getX();
            float f11 = (float)point2DArray[n3].getY();
            f6 = Math.min(f6, f10);
            f7 = Math.min(f7, f11);
            f8 = Math.max(f8, f10);
            f9 = Math.max(f9, f11);
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n4 = (int)Math.floor(f6);
            n5 = (int)Math.floor(f7);
            n6 = (int)Math.ceil(f8);
            n7 = (int)Math.ceil(f9);
        } else {
            n4 = (int)Math.floor((double)f6 - 0.5);
            n5 = (int)Math.floor((double)f7 - 0.5);
            n6 = (int)Math.ceil(f8);
            n7 = (int)Math.ceil(f9);
        }
        return new Rectangle(n4, n5, n6 - n4, n7 - n5);
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.theDest);
        Rectangle rectangle3 = rectangle.intersection(this.getBounds());
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        Rectangle rectangle4 = this.mapDestRect(rectangle2, 0);
        rectangle4 = this.extender == null ? rectangle4.intersection(this.srcimg) : rectangle4.intersection(this.padimg);
        if (rectangle4.width <= 0 || rectangle4.height <= 0) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        if (!rectangle3.equals(rectangle2)) {
            ImageUtil.fillBordersWithBackgroundValues(rectangle3, rectangle2, writableRaster, this.backgroundValues);
        }
        Raster[] rasterArray = new Raster[]{this.extender == null ? this.getSourceImage(0).getData(rectangle4) : this.getSourceImage(0).getExtendedData(rectangle4, this.extender)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        if (this.getSourceImage(0).overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[0]);
        }
        return writableRaster;
    }
}

