/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.jai.ImageLayout;

public class MediaLibAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 1;
    public static final int COPY_MASK = 128;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    public static final int DATATYPE_MASK = 127;
    private static final int BINARY_MASK_SHIFT = 8;
    private static final int BINARY_MASK_SIZE = 1;
    public static final int BINARY_MASK = 256;
    public static final int NONBINARY = 0;
    public static final int BINARY = 256;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_BYTE_COPIED = 128;
    public static final int TAG_USHORT_COPIED = 129;
    public static final int TAG_SHORT_COPIED = 130;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    protected Raster raster;
    protected Rectangle rect;
    protected int numBands;
    protected int[] bandOffsets;
    protected int formatTag;
    protected mediaLibImage[] mlimages;
    private boolean areBinaryDataPacked;
    private static boolean useMlibVar = false;
    private static boolean useMlibVarSet = false;
    static /* synthetic */ Class class$com$sun$media$jai$mlib$MediaLibAccessor;

    private static synchronized boolean useMlib() {
        if (!useMlibVarSet) {
            MediaLibAccessor.setUseMlib();
            useMlibVarSet = true;
        }
        return useMlibVar;
    }

    private static void setUseMlib() {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        if (bl) {
            useMlibVar = false;
            return;
        }
        try {
            Object object;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (class$com$sun$media$jai$mlib$MediaLibAccessor == null ? (class$com$sun$media$jai$mlib$MediaLibAccessor = MediaLibAccessor.class$("com.sun.media.jai.mlib.MediaLibAccessor")) : class$com$sun$media$jai$mlib$MediaLibAccessor).getClassLoader() != null) {
                object = System.getProperty("os.name");
                String string = System.getProperty("os.arch");
                if ((((String)object).equals("Solaris") || ((String)object).equals("SunOS")) && string.equals("sparc")) {
                    FilePermission filePermission = new FilePermission("/usr/bin/uname", "execute");
                    securityManager.checkPermission(filePermission);
                }
            }
            if (!(useMlibVar = ((Boolean)(object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(Image.isAvailable());
                }
            }))).booleanValue())) {
                System.err.println(JaiI18N.getString("MediaLibAccessor2"));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor3"));
        }
        catch (ClassFormatError classFormatError) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor3"));
        }
        catch (SecurityException securityException) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor4"));
        }
        if (!useMlibVar) {
            return;
        }
    }

    public static boolean isMediaLibCompatible(ParameterBlock parameterBlock, ImageLayout imageLayout) {
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock)) {
            return false;
        }
        if (imageLayout != null) {
            SampleModel sampleModel = imageLayout.getSampleModel(null);
            if (!(sampleModel == null || sampleModel instanceof ComponentSampleModel && sampleModel.getNumBands() <= 4)) {
                return false;
            }
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (colorModel != null && !(colorModel instanceof ComponentColorModel)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isMediaLibCompatible(ParameterBlock parameterBlock) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        int n2 = parameterBlock.getNumSources();
        int n3 = 0;
        while (n3 < n2) {
            Object object = parameterBlock.getSource(n3);
            if (!(object instanceof RenderedImage) || !MediaLibAccessor.isMediaLibCompatible((RenderedImage)object)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isMediaLibCompatible(RenderedImage renderedImage) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        return sampleModel instanceof ComponentSampleModel && sampleModel.getNumBands() <= 4 && (colorModel == null || colorModel instanceof ComponentColorModel);
    }

    public static boolean isMediaLibCompatible(SampleModel sampleModel, ColorModel colorModel) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        return sampleModel instanceof ComponentSampleModel && sampleModel.getNumBands() <= 4 && (colorModel == null || colorModel instanceof ComponentColorModel);
    }

    public static boolean isMediaLibBinaryCompatible(ParameterBlock parameterBlock, ImageLayout imageLayout) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        SampleModel sampleModel = null;
        int n2 = parameterBlock.getNumSources();
        int n3 = 0;
        while (n3 < n2) {
            Object object = parameterBlock.getSource(n3);
            if (!(object instanceof RenderedImage) || (sampleModel = ((RenderedImage)object).getSampleModel()) == null || !ImageUtil.isBinary(sampleModel)) {
                return false;
            }
            ++n3;
        }
        return imageLayout == null || (sampleModel = imageLayout.getSampleModel(null)) == null || ImageUtil.isBinary(sampleModel);
    }

    public static boolean hasSameNumBands(ParameterBlock parameterBlock, ImageLayout imageLayout) {
        int n2 = parameterBlock.getNumSources();
        if (n2 > 0) {
            SampleModel sampleModel;
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            int n3 = renderedImage.getSampleModel().getNumBands();
            int n4 = 1;
            while (n4 < n2) {
                renderedImage = parameterBlock.getRenderedSource(n4);
                if (renderedImage.getSampleModel().getNumBands() != n3) {
                    return false;
                }
                ++n4;
            }
            if (imageLayout != null && (sampleModel = imageLayout.getSampleModel(null)) != null && sampleModel.getNumBands() != n3) {
                return false;
            }
        }
        return true;
    }

    public static int findCompatibleTag(Raster[] rasterArray, Raster raster) {
        int n2;
        int n3;
        SampleModel sampleModel = raster.getSampleModel();
        int n4 = sampleModel.getDataType();
        int n5 = sampleModel.getDataType();
        boolean bl = sampleModel instanceof ComponentSampleModel;
        boolean bl2 = ImageUtil.isBinary(sampleModel);
        if (rasterArray != null) {
            n3 = rasterArray.length;
            int n6 = 0;
            while (n6 < n3) {
                SampleModel sampleModel2 = rasterArray[n6].getSampleModel();
                if (!(sampleModel2 instanceof ComponentSampleModel)) {
                    bl = false;
                }
                if (!ImageUtil.isBinary(sampleModel2)) {
                    bl2 = false;
                }
                if ((n2 = sampleModel2.getTransferType()) > n5) {
                    n5 = n2;
                }
                ++n6;
            }
        }
        if (bl2) {
            return 256;
        }
        if (!(bl || n5 != 0 && n5 != 1 && n5 != 2)) {
            n5 = 3;
        }
        n3 = n5 | 0x80;
        if (!bl) {
            return n3;
        }
        SampleModel[] sampleModelArray = rasterArray == null ? new SampleModel[]{} : new SampleModel[rasterArray.length];
        int n7 = 0;
        while (n7 < sampleModelArray.length) {
            sampleModelArray[n7] = rasterArray[n7].getSampleModel();
            if (n4 != sampleModelArray[n7].getDataType()) {
                return n3;
            }
            ++n7;
        }
        if (MediaLibAccessor.isPixelSequential(sampleModel)) {
            n2 = 0;
            while (n2 < sampleModelArray.length) {
                if (!MediaLibAccessor.isPixelSequential(sampleModelArray[n2])) {
                    return n3;
                }
                ++n2;
            }
            int n8 = 0;
            while (n8 < sampleModelArray.length) {
                if (!MediaLibAccessor.hasMatchingBandOffsets((ComponentSampleModel)sampleModel, (ComponentSampleModel)sampleModelArray[n8])) {
                    return n3;
                }
                ++n8;
            }
            return n4 | 0;
        }
        return n3;
    }

    public static boolean isPixelSequential(SampleModel sampleModel) {
        ComponentSampleModel componentSampleModel = null;
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        componentSampleModel = (ComponentSampleModel)sampleModel;
        int n2 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        int[] nArray2 = componentSampleModel.getBankIndices();
        if (n2 != nArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] >= n2 || nArray2[n3] != nArray2[0]) {
                return false;
            }
            int n4 = n3 + 1;
            while (n4 < nArray.length) {
                if (nArray[n3] == nArray[n4]) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public static boolean hasMatchingBandOffsets(ComponentSampleModel componentSampleModel, ComponentSampleModel componentSampleModel2) {
        int[] nArray;
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray2.length != (nArray = componentSampleModel2.getBandOffsets()).length) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray2[n2] != nArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int getMediaLibDataType(int n2) {
        int n3 = n2 & 0x7F;
        switch (n3) {
            case 0: {
                return 1;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public MediaLibAccessor(Raster raster, Rectangle rectangle, int n2, boolean bl) {
        block21: {
            block20: {
                this.mlimages = null;
                this.areBinaryDataPacked = false;
                this.areBinaryDataPacked = bl;
                this.raster = raster;
                this.rect = new Rectangle(rectangle);
                this.formatTag = n2;
                if (this.isBinary()) {
                    byte[] byArray;
                    int n3;
                    int n4;
                    this.numBands = 1;
                    this.bandOffsets = new int[]{0};
                    this.mlimages = new mediaLibImage[1];
                    if (this.areBinaryDataPacked) {
                        n4 = 0;
                        n3 = (rectangle.width + 7) / 8;
                        byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
                        this.formatTag = byArray == ((DataBufferByte)raster.getDataBuffer()).getData() ? (this.formatTag |= 0) : (this.formatTag |= 0x80);
                    } else {
                        n4 = 1;
                        n3 = rectangle.width;
                        byArray = ImageUtil.getUnpackedBinaryData(raster, rectangle);
                        this.formatTag |= 0x80;
                    }
                    this.mlimages[0] = new mediaLibImage(n4, 1, rectangle.width, rectangle.height, n3, 0, (Object)byArray);
                    return;
                }
                if ((n2 & 0x80) != 0) break block20;
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                this.numBands = componentSampleModel.getNumBands();
                this.bandOffsets = componentSampleModel.getBandOffsets();
                int n5 = raster.getDataBuffer().getOffset();
                n5 += (rectangle.y - raster.getSampleModelTranslateY()) * componentSampleModel.getScanlineStride() + (rectangle.x - raster.getSampleModelTranslateX()) * componentSampleModel.getPixelStride();
                int n6 = componentSampleModel.getScanlineStride();
                switch (n2 & 0x7F) {
                    case 0: {
                        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)dataBufferByte.getData());
                        break block21;
                    }
                    case 1: {
                        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(6, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)dataBufferUShort.getData());
                        break block21;
                    }
                    case 2: {
                        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)dataBufferShort.getData());
                        break block21;
                    }
                    case 3: {
                        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)dataBufferInt.getData());
                        break block21;
                    }
                    case 4: {
                        DataBuffer dataBuffer = raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)DataBufferUtils.getDataFloat(dataBuffer));
                        break block21;
                    }
                    case 5: {
                        DataBuffer dataBuffer = raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n6, n5, (Object)DataBufferUtils.getDataDouble(dataBuffer));
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException((n2 & 0x7F) + JaiI18N.getString("MediaLibAccessor1"));
                    }
                }
            }
            this.numBands = raster.getNumBands();
            this.bandOffsets = new int[this.numBands];
            int n7 = 0;
            while (n7 < this.numBands) {
                this.bandOffsets[n7] = n7;
                ++n7;
            }
            int n8 = rectangle.width * this.numBands;
            switch (n2 & 0x7F) {
                case 0: {
                    byte[] byArray = new byte[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)byArray);
                    break;
                }
                case 1: {
                    short[] sArray = new short[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(6, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)sArray);
                    break;
                }
                case 2: {
                    short[] sArray = new short[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)sArray);
                    break;
                }
                case 3: {
                    int[] nArray = new int[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)nArray);
                    break;
                }
                case 4: {
                    float[] fArray = new float[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)fArray);
                    break;
                }
                case 5: {
                    double[] dArray = new double[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n8, 0, (Object)dArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((n2 & 0x7F) + JaiI18N.getString("MediaLibAccessor1"));
                }
            }
            this.copyDataFromRaster();
        }
    }

    public MediaLibAccessor(Raster raster, Rectangle rectangle, int n2) {
        this(raster, rectangle, n2, false);
    }

    public boolean isBinary() {
        return (this.formatTag & 0x100) == 256;
    }

    public mediaLibImage[] getMediaLibImages() {
        return this.mlimages;
    }

    public int getDataType() {
        return this.formatTag & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTag & 0x80) == 128;
    }

    public int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public int[] getIntParameters(int n2, int[] nArray) {
        int[] nArray2 = new int[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            nArray2[n3] = nArray[this.bandOffsets[n3 + n2]];
            ++n3;
        }
        return nArray2;
    }

    public int[][] getIntArrayParameters(int n2, int[][] nArray) {
        int[][] nArrayArray = new int[this.numBands][];
        int n3 = 0;
        while (n3 < this.numBands) {
            nArrayArray[n3] = nArray[this.bandOffsets[n3 + n2]];
            ++n3;
        }
        return nArrayArray;
    }

    public double[] getDoubleParameters(int n2, double[] dArray) {
        double[] dArray2 = new double[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            dArray2[n3] = dArray[this.bandOffsets[n3 + n2]];
            ++n3;
        }
        return dArray2;
    }

    private void copyDataFromRaster() {
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            int n2;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.raster.getSampleModel();
            int n3 = componentSampleModel.getScanlineStride();
            int n4 = componentSampleModel.getPixelStride();
            int n5 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n3 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n4;
            int[] nArray = componentSampleModel.getBankIndices();
            int[] nArray2 = componentSampleModel.getBandOffsets();
            int[] nArray3 = this.raster.getDataBuffer().getOffsets();
            if (nArray3.length == 1) {
                n2 = 0;
                while (n2 < this.numBands) {
                    int n6 = n2++;
                    nArray2[n6] = nArray2[n6] + (nArray3[0] + n5);
                }
            } else if (nArray3.length == nArray2.length) {
                n2 = 0;
                while (n2 < this.numBands) {
                    int n7 = n2;
                    nArray2[n7] = nArray2[n7] + (nArray3[n2] + n5);
                    ++n2;
                }
            }
            Object object = null;
            switch (this.getDataType()) {
                case 0: {
                    byte[][] byArrayArray = new byte[this.numBands][];
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        byArrayArray[n8] = this.mlimages[0].getByteData();
                        ++n8;
                    }
                    object = byArrayArray;
                    break;
                }
                case 1: {
                    short[][] sArrayArray = new short[this.numBands][];
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        sArrayArray[n9] = this.mlimages[0].getUShortData();
                        ++n9;
                    }
                    object = sArrayArray;
                    break;
                }
                case 2: {
                    short[][] sArrayArray = new short[this.numBands][];
                    int n10 = 0;
                    while (n10 < this.numBands) {
                        sArrayArray[n10] = this.mlimages[0].getShortData();
                        ++n10;
                    }
                    object = sArrayArray;
                    break;
                }
                case 3: {
                    int[][] nArrayArray = new int[this.numBands][];
                    int n11 = 0;
                    while (n11 < this.numBands) {
                        nArrayArray[n11] = this.mlimages[0].getIntData();
                        ++n11;
                    }
                    object = nArrayArray;
                    break;
                }
                case 4: {
                    float[][] fArrayArray = new float[this.numBands][];
                    int n12 = 0;
                    while (n12 < this.numBands) {
                        fArrayArray[n12] = this.mlimages[0].getFloatData();
                        ++n12;
                    }
                    object = fArrayArray;
                    break;
                }
                case 5: {
                    double[][] dArrayArray = new double[this.numBands][];
                    int n13 = 0;
                    while (n13 < this.numBands) {
                        dArrayArray[n13] = this.mlimages[0].getDoubleData();
                        ++n13;
                    }
                    object = dArrayArray;
                }
            }
            Object object2 = null;
            switch (componentSampleModel.getDataType()) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                    byte[][] byArrayArray = new byte[this.numBands][];
                    int n14 = 0;
                    while (n14 < this.numBands) {
                        byArrayArray[n14] = dataBufferByte.getData(nArray[n14]);
                        ++n14;
                    }
                    object2 = byArrayArray;
                    break;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)this.raster.getDataBuffer();
                    short[][] sArrayArray = new short[this.numBands][];
                    int n15 = 0;
                    while (n15 < this.numBands) {
                        sArrayArray[n15] = dataBufferUShort.getData(nArray[n15]);
                        ++n15;
                    }
                    object2 = sArrayArray;
                    break;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                    short[][] sArrayArray = new short[this.numBands][];
                    int n16 = 0;
                    while (n16 < this.numBands) {
                        sArrayArray[n16] = dataBufferShort.getData(nArray[n16]);
                        ++n16;
                    }
                    object2 = sArrayArray;
                    break;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                    int[][] nArrayArray = new int[this.numBands][];
                    int n17 = 0;
                    while (n17 < this.numBands) {
                        nArrayArray[n17] = dataBufferInt.getData(nArray[n17]);
                        ++n17;
                    }
                    object2 = nArrayArray;
                    break;
                }
                case 4: {
                    DataBuffer dataBuffer = this.raster.getDataBuffer();
                    float[][] fArrayArray = new float[this.numBands][];
                    int n18 = 0;
                    while (n18 < this.numBands) {
                        fArrayArray[n18] = DataBufferUtils.getDataFloat(dataBuffer, nArray[n18]);
                        ++n18;
                    }
                    object2 = fArrayArray;
                    break;
                }
                case 5: {
                    DataBuffer dataBuffer = this.raster.getDataBuffer();
                    double[][] dArrayArray = new double[this.numBands][];
                    int n19 = 0;
                    while (n19 < this.numBands) {
                        dArrayArray[n19] = DataBufferUtils.getDataDouble(dataBuffer, nArray[n19]);
                        ++n19;
                    }
                    object2 = dArrayArray;
                }
            }
            Image.Reformat((Object)object, (Object)object2, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray2, (int)n3, (int)n4);
        } else {
            switch (this.getDataType()) {
                case 3: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                    break;
                }
                case 4: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                    break;
                }
                case 5: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                }
            }
        }
    }

    public void copyDataToRaster() {
        if (this.isDataCopy()) {
            if (this.isBinary()) {
                if (this.areBinaryDataPacked) {
                    ImageUtil.setPackedBinaryData(this.mlimages[0].getBitData(), (WritableRaster)this.raster, this.rect);
                } else {
                    ImageUtil.setUnpackedBinaryData(this.mlimages[0].getByteData(), (WritableRaster)this.raster, this.rect);
                }
                return;
            }
            WritableRaster writableRaster = (WritableRaster)this.raster;
            if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
                int n2;
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
                int n3 = componentSampleModel.getScanlineStride();
                int n4 = componentSampleModel.getPixelStride();
                int n5 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n3 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n4;
                int[] nArray = componentSampleModel.getBankIndices();
                int[] nArray2 = componentSampleModel.getBandOffsets();
                int[] nArray3 = this.raster.getDataBuffer().getOffsets();
                if (nArray3.length == 1) {
                    n2 = 0;
                    while (n2 < this.numBands) {
                        int n6 = n2++;
                        nArray2[n6] = nArray2[n6] + (nArray3[0] + n5);
                    }
                } else if (nArray3.length == nArray2.length) {
                    n2 = 0;
                    while (n2 < this.numBands) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] + (nArray3[n2] + n5);
                        ++n2;
                    }
                }
                Object object = null;
                switch (this.getDataType()) {
                    case 0: {
                        byte[][] byArrayArray = new byte[this.numBands][];
                        int n8 = 0;
                        while (n8 < this.numBands) {
                            byArrayArray[n8] = this.mlimages[0].getByteData();
                            ++n8;
                        }
                        object = byArrayArray;
                        break;
                    }
                    case 1: {
                        short[][] sArrayArray = new short[this.numBands][];
                        int n9 = 0;
                        while (n9 < this.numBands) {
                            sArrayArray[n9] = this.mlimages[0].getUShortData();
                            ++n9;
                        }
                        object = sArrayArray;
                        break;
                    }
                    case 2: {
                        short[][] sArrayArray = new short[this.numBands][];
                        int n10 = 0;
                        while (n10 < this.numBands) {
                            sArrayArray[n10] = this.mlimages[0].getShortData();
                            ++n10;
                        }
                        object = sArrayArray;
                        break;
                    }
                    case 3: {
                        int[][] nArrayArray = new int[this.numBands][];
                        int n11 = 0;
                        while (n11 < this.numBands) {
                            nArrayArray[n11] = this.mlimages[0].getIntData();
                            ++n11;
                        }
                        object = nArrayArray;
                        break;
                    }
                    case 4: {
                        float[][] fArrayArray = new float[this.numBands][];
                        int n12 = 0;
                        while (n12 < this.numBands) {
                            fArrayArray[n12] = this.mlimages[0].getFloatData();
                            ++n12;
                        }
                        object = fArrayArray;
                        break;
                    }
                    case 5: {
                        double[][] dArrayArray = new double[this.numBands][];
                        int n13 = 0;
                        while (n13 < this.numBands) {
                            dArrayArray[n13] = this.mlimages[0].getDoubleData();
                            ++n13;
                        }
                        object = dArrayArray;
                    }
                }
                byte[] byArray = null;
                Object object2 = null;
                switch (componentSampleModel.getDataType()) {
                    case 0: {
                        DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                        byte[][] byArrayArray = new byte[this.numBands][];
                        int n14 = 0;
                        while (n14 < this.numBands) {
                            byArrayArray[n14] = dataBufferByte.getData(nArray[n14]);
                            ++n14;
                        }
                        byArray = byArrayArray[0];
                        object2 = byArrayArray;
                        break;
                    }
                    case 1: {
                        DataBufferUShort dataBufferUShort = (DataBufferUShort)this.raster.getDataBuffer();
                        short[][] sArrayArray = new short[this.numBands][];
                        int n15 = 0;
                        while (n15 < this.numBands) {
                            sArrayArray[n15] = dataBufferUShort.getData(nArray[n15]);
                            ++n15;
                        }
                        object2 = sArrayArray;
                        break;
                    }
                    case 2: {
                        DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                        short[][] sArrayArray = new short[this.numBands][];
                        int n16 = 0;
                        while (n16 < this.numBands) {
                            sArrayArray[n16] = dataBufferShort.getData(nArray[n16]);
                            ++n16;
                        }
                        object2 = sArrayArray;
                        break;
                    }
                    case 3: {
                        DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                        int[][] nArrayArray = new int[this.numBands][];
                        int n17 = 0;
                        while (n17 < this.numBands) {
                            nArrayArray[n17] = dataBufferInt.getData(nArray[n17]);
                            ++n17;
                        }
                        object2 = nArrayArray;
                        break;
                    }
                    case 4: {
                        DataBuffer dataBuffer = this.raster.getDataBuffer();
                        float[][] fArrayArray = new float[this.numBands][];
                        int n18 = 0;
                        while (n18 < this.numBands) {
                            fArrayArray[n18] = DataBufferUtils.getDataFloat(dataBuffer, nArray[n18]);
                            ++n18;
                        }
                        object2 = fArrayArray;
                        break;
                    }
                    case 5: {
                        DataBuffer dataBuffer = this.raster.getDataBuffer();
                        double[][] dArrayArray = new double[this.numBands][];
                        int n19 = 0;
                        while (n19 < this.numBands) {
                            dArrayArray[n19] = DataBufferUtils.getDataDouble(dataBuffer, nArray[n19]);
                            ++n19;
                        }
                        object2 = dArrayArray;
                    }
                }
                Image.Reformat((Object)object2, (Object)object, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray2, (int)n3, (int)n4, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands);
            } else {
                switch (this.getDataType()) {
                    case 3: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                        break;
                    }
                    case 4: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                        break;
                    }
                    case 5: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                    }
                }
            }
        }
    }

    public void clampDataArrays() {
        int n2;
        if (!this.isDataCopy()) {
            return;
        }
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            return;
        }
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 = nArray[0];
            if (nArray[n3] < 32) {
                bl = true;
            }
            if (nArray[n3] != n2) {
                bl2 = false;
            }
            ++n3;
        }
        if (!bl) {
            return;
        }
        n2 = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n2 == 1 && bl2 && nArray[0] == 16) {
            int n4 = 0;
            while (n4 < nArray.length) {
                dArray[n4] = 65535.0;
                dArray2[n4] = 0.0;
                ++n4;
            }
        } else if (n2 == 2 && bl2 && nArray[0] == 16) {
            int n5 = 0;
            while (n5 < nArray.length) {
                dArray[n5] = 32767.0;
                dArray2[n5] = -32768.0;
                ++n5;
            }
        } else if (n2 == 3 && bl2 && nArray[0] == 32) {
            int n6 = 0;
            while (n6 < nArray.length) {
                dArray[n6] = 2.147483647E9;
                dArray2[n6] = -2.147483648E9;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < nArray.length) {
                dArray[n7] = (1 << nArray[n7]) - 1;
                dArray2[n7] = 0.0;
                ++n7;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
            }
        }
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            nArray[n2] = (int)dArray[n2];
            ++n2;
        }
        return nArray;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            fArray[n2] = (float)dArray[n2];
            ++n2;
        }
        return fArray;
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n2 = this.rect.width;
        int n3 = this.rect.height;
        int n4 = this.numBands * n2;
        int n5 = 0;
        while (n5 < this.numBands) {
            int[] nArray3 = this.mlimages[0].getIntData();
            int n6 = n5;
            int n7 = nArray[n5];
            int n8 = nArray2[n5];
            int n9 = 0;
            while (n9 < n3) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n2) {
                    int n12 = nArray3[n10];
                    if (n12 < n8) {
                        nArray3[n10] = n8;
                    } else if (n12 > n7) {
                        nArray3[n10] = n7;
                    }
                    n10 += this.numBands;
                    ++n11;
                }
                n6 += n4;
                ++n9;
            }
            ++n5;
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n2 = this.rect.width;
        int n3 = this.rect.height;
        int n4 = this.numBands * n2;
        int n5 = 0;
        while (n5 < this.numBands) {
            float[] fArray3 = this.mlimages[0].getFloatData();
            int n6 = n5;
            float f2 = fArray[n5];
            float f3 = fArray2[n5];
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n6;
                int n9 = 0;
                while (n9 < n2) {
                    float f4 = fArray3[n8];
                    if (f4 < f3) {
                        fArray3[n8] = f3;
                    } else if (f4 > f2) {
                        fArray3[n8] = f2;
                    }
                    n8 += this.numBands;
                    ++n9;
                }
                n6 += n4;
                ++n7;
            }
            ++n5;
        }
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n2 = this.rect.width;
        int n3 = this.rect.height;
        int n4 = this.numBands * n2;
        int n5 = 0;
        while (n5 < this.numBands) {
            double[] dArray3 = this.mlimages[0].getDoubleData();
            int n6 = n5;
            double d2 = dArray[n5];
            double d3 = dArray2[n5];
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n6;
                int n9 = 0;
                while (n9 < n2) {
                    double d4 = dArray3[n8];
                    if (d4 < d3) {
                        dArray3[n8] = d3;
                    } else if (d4 > d2) {
                        dArray3[n8] = d2;
                    }
                    n8 += this.numBands;
                    ++n9;
                }
                n6 += n4;
                ++n7;
            }
            ++n5;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

