/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.opimage.FCT;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;
import java.util.Arrays;

public class FCTmediaLib
extends FCT {
    private int length;
    private boolean lengthIsSet = false;
    private double[] wr;
    private double[] wi;
    protected double[] real;
    protected double[] imag;

    public FCTmediaLib(boolean bl, int n2) {
        this.isForwardTransform = bl;
        this.setLength(n2);
    }

    public void setLength(int n2) {
        if (this.lengthIsSet && n2 == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n2)) {
            throw new RuntimeException(JaiI18N.getString("FCTmediaLib0"));
        }
        this.length = n2;
        if (this.real == null || n2 != this.real.length) {
            this.real = new double[n2];
            this.imag = new double[n2];
        }
        this.calculateFCTLUTs();
        this.lengthIsSet = true;
    }

    private void calculateFCTLUTs() {
        this.wr = new double[this.length];
        this.wi = new double[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            double d2 = n2 == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d3 = Math.PI * (double)n2 / (2.0 * (double)this.length);
            this.wr[n2] = d2 * Math.cos(d3);
            this.wi[n2] = d2 * Math.sin(d3);
            ++n2;
        }
    }

    public void setData(int n2, Object object, int n3, int n4, int n5) {
        if (this.isForwardTransform) {
            this.setFCTData(n2, object, n3, n4, n5);
        } else {
            this.setIFCTData(n2, object, n3, n4, n5);
        }
    }

    public void getData(int n2, Object object, int n3, int n4) {
        if (this.isForwardTransform) {
            this.getFCTData(n2, object, n3, n4);
        } else {
            this.getIFCTData(n2, object, n3, n4);
        }
    }

    private void setFCTData(int n2, Object object, int n3, int n4, int n5) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n6 = 0;
                while (n6 < n5) {
                    this.imag[n6] = fArray[n3];
                    n3 += n4;
                    ++n6;
                }
                int n7 = n5;
                while (n7 < this.length) {
                    this.imag[n7] = 0.0;
                    ++n7;
                }
                int n8 = this.length - 1;
                int n9 = 0;
                int n10 = 0;
                while (n10 < n8) {
                    this.real[n10] = this.imag[n9++];
                    this.real[n8--] = this.imag[n9++];
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    this.imag[n11] = dArray[n3];
                    n3 += n4;
                    ++n11;
                }
                int n12 = n5;
                while (n12 < this.length) {
                    this.imag[n12] = 0.0;
                    ++n12;
                }
                int n13 = this.length - 1;
                int n14 = 0;
                int n15 = 0;
                while (n15 < n13) {
                    this.real[n15] = this.imag[n14++];
                    this.real[n13--] = this.imag[n14++];
                    ++n15;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    private void getFCTData(int n2, Object object, int n3, int n4) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < this.length) {
                    fArray[n3] = (float)(this.wr[n5] * this.real[n5] + this.wi[n5] * this.imag[n5]);
                    n3 += n4;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = 0;
                while (n6 < this.length) {
                    dArray[n3] = this.wr[n6] * this.real[n6] + this.wi[n6] * this.imag[n6];
                    n3 += n4;
                    ++n6;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    private void setIFCTData(int n2, Object object, int n3, int n4, int n5) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n6 = 0;
                while (n6 < n5) {
                    float f2 = fArray[n3];
                    this.real[n6] = (double)f2 * this.wr[n6];
                    this.imag[n6] = (double)f2 * this.wi[n6];
                    n3 += n4;
                    ++n6;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n7 = 0;
                while (n7 < n5) {
                    double d2 = dArray[n3];
                    this.real[n7] = d2 * this.wr[n7];
                    this.imag[n7] = d2 * this.wi[n7];
                    n3 += n4;
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        if (n5 < this.length) {
            Arrays.fill(this.real, n5, this.length, 0.0);
            Arrays.fill(this.imag, n5, this.length, 0.0);
        }
    }

    private void getIFCTData(int n2, Object object, int n3, int n4) {
        switch (n2) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = this.length - 1;
                int n6 = 0;
                while (n6 < n5) {
                    fArray[n3] = (float)this.real[n6];
                    fArray[n3 += n4] = (float)this.real[n5--];
                    n3 += n4;
                    ++n6;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n7 = this.length - 1;
                int n8 = 0;
                while (n8 < n7) {
                    dArray[n3] = (float)this.real[n8];
                    dArray[n3 += n4] = (float)this.real[n7--];
                    n3 += n4;
                    ++n8;
                }
                break;
            }
            default: {
                throw new RuntimeException(n2 + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    public void transform() {
        if (this.isForwardTransform) {
            Image.FFT_1((double[])this.real, (double[])this.imag);
        } else {
            Image.IFFT_2((double[])this.real, (double[])this.imag);
        }
    }
}

