/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;

public class RandomIterFallback
implements RandomIter {
    protected RenderedImage im;
    protected Rectangle boundsRect;
    protected SampleModel sampleModel;
    protected int xID;
    protected int yID;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected DataBuffer dataBuffer = null;
    protected int boundsX;
    protected int boundsY;
    protected int[] xTiles;
    protected int[] yTiles;

    public RandomIterFallback(RenderedImage renderedImage, Rectangle rectangle) {
        this.im = renderedImage;
        Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        this.boundsRect = rectangle2.intersection(rectangle);
        this.sampleModel = renderedImage.getSampleModel();
        int n2 = this.boundsRect.x;
        int n3 = this.boundsRect.y;
        int n4 = this.boundsRect.width;
        int n5 = this.boundsRect.height;
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        this.xTiles = new int[n4];
        this.yTiles = new int[n5];
        int n6 = renderedImage.getTileWidth();
        int n7 = renderedImage.getTileGridXOffset();
        int n8 = PlanarImage.XToTileX(n2, n7, n6);
        int n9 = n2 - PlanarImage.tileXToX(n8, n7, n6);
        int n10 = n8;
        int n11 = 0;
        while (n11 < n4) {
            this.xTiles[n11] = n10++;
            if (++n9 == n6) {
                n9 = 0;
            }
            ++n11;
        }
        int n12 = renderedImage.getTileHeight();
        int n13 = renderedImage.getTileGridYOffset();
        int n14 = PlanarImage.YToTileY(n3, n13, n12);
        int n15 = n3 - PlanarImage.tileYToY(n14, n13, n12);
        int n16 = n14;
        int n17 = 0;
        while (n17 < n5) {
            this.yTiles[n17] = n16++;
            if (++n15 == n12) {
                n15 = 0;
            }
            ++n17;
        }
    }

    private void makeCurrent(int n2, int n3) {
        int n4 = this.xTiles[n2];
        int n5 = this.yTiles[n3];
        if (n4 != this.xID || n5 != this.yID || this.dataBuffer == null) {
            this.xID = n4;
            this.yID = n5;
            Raster raster = this.im.getTile(this.xID, this.yID);
            this.dataBuffer = raster.getDataBuffer();
            this.sampleModelTranslateX = raster.getSampleModelTranslateX();
            this.sampleModelTranslateY = raster.getSampleModelTranslateY();
        }
    }

    public int getSample(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getSample(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public float getSampleFloat(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getSampleFloat(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public double getSampleDouble(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getSampleDouble(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, this.dataBuffer);
    }

    public int[] getPixel(int n2, int n3, int[] nArray) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n2, int n3, float[] fArray) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n2, int n3, double[] dArray) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsY);
        return this.sampleModel.getPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void done() {
        this.xTiles = null;
        this.yTiles = null;
        this.dataBuffer = null;
    }
}

