/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterCSM;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;

public class RandomIterCSMFloat
extends RandomIterCSM {
    float[][] bankData;

    public RandomIterCSMFloat(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
    }

    protected final void dataBufferChanged() {
        this.bankData = DataBufferUtils.getBankDataFloat(this.dataBuffer);
    }

    public final int getSample(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsX);
        return (int)this.bankData[n4][(n2 - this.sampleModelTranslateX) * this.pixelStride + (n3 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n4]];
    }

    public final float getSampleFloat(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsX);
        return this.bankData[n4][(n2 - this.sampleModelTranslateX) * this.pixelStride + (n3 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n4]];
    }

    public final double getSampleDouble(int n2, int n3, int n4) {
        this.makeCurrent(n2 - this.boundsX, n3 - this.boundsX);
        return this.bankData[n4][(n2 - this.sampleModelTranslateX) * this.pixelStride + (n3 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n4]];
    }

    public float[] getPixel(int n2, int n3, float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n4 = (n2 - this.sampleModelTranslateX) * this.pixelStride + (n3 - this.sampleModelTranslateY) * this.scanlineStride;
        int n5 = 0;
        while (n5 < this.numBands) {
            fArray[n5] = this.bankData[n5][n4 + this.bandOffsets[n5]];
            ++n5;
        }
        return fArray;
    }
}

